/*
 * Decompiled with CFR 0.152.
 */
package org.plutext.msgraph.convert.graphsdk;

import com.microsoft.graph.auth.confidentialClient.ClientCredentialProvider;
import com.microsoft.graph.auth.enums.NationalCloud;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.FutureTask;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.plutext.msgraph.convert.AbstractOpenXmlToPDF;
import org.plutext.msgraph.convert.AuthConfig;
import org.plutext.msgraph.convert.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Limited4MB
extends AbstractOpenXmlToPDF {
    private static final Logger log = LoggerFactory.getLogger(Limited4MB.class);

    public Limited4MB(AuthConfig authConfig) {
        super(authConfig);
    }

    public byte[] convert(byte[] bytes, String ext) throws ConversionException {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        ClientCredentialProvider authProvider = new ClientCredentialProvider(this.authConfig.apiKey(), scopes, this.authConfig.apiSecret(), this.authConfig.tenant(), NationalCloud.Global);
        IGraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)authProvider).buildClient();
        String tmpFileName = UUID.randomUUID().toString() + ".docx";
        String convertPathPrefix = "/sites/" + this.authConfig.site() + "/drive/items/";
        String item = "root:/" + tmpFileName + ":";
        MyCallback myCallback = new MyCallback(graphClient, convertPathPrefix, this.authConfig.site(), item);
        graphClient.sites(this.authConfig.site()).drive().items(item).content().buildRequest().put(bytes, (ICallback)myCallback);
        try {
            myCallback.ft.get();
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
        return myCallback.pdf;
    }

    public byte[] convert(File docx) throws ConversionException, IOException {
        String filename = docx.getName();
        String ext = filename.substring(filename.lastIndexOf("."));
        return this.convert(FileUtils.readFileToByteArray((File)docx), ext);
    }

    public byte[] convert(InputStream docx, String ext) throws ConversionException, IOException {
        return this.convert(IOUtils.toByteArray((InputStream)docx), ext);
    }

    static class MyCallback
    implements ICallback<DriveItem> {
        String convertPathPrefix;
        String site;
        String item;
        IGraphServiceClient graphClient;
        byte[] pdf;
        final FutureTask<Object> ft = new FutureTask<Object>(() -> {}, new Object());

        MyCallback(IGraphServiceClient graphClient, String convertPathPrefix, String site, String item) {
            this.graphClient = graphClient;
            this.convertPathPrefix = convertPathPrefix;
            this.site = site;
            this.item = item;
        }

        public void success(DriveItem result) {
            try (BufferedInputStream inputStream = (BufferedInputStream)this.graphClient.customRequest(this.convertPathPrefix + this.item + "/content?format=pdf", Stream.class).buildRequest().get();){
                this.pdf = IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (ClientException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            this.graphClient.sites(this.site).drive().items(this.item).buildRequest().delete();
            this.ft.run();
        }

        public void failure(ClientException ex) {
            log.error("Conversion failed", (Throwable)ex);
        }
    }
}

