/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MaterialImporter;
import org.pepsoft.util.CSVDataSource;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.dynmap.DynmapColourScheme;

public class UpdateMaterials {
    private static final String[] EXTENSIONS = new String[]{"", "s", "_block", "_top", "_block_top", "_front", "_planks", "_stage7", "_stage3", "_stage2", "_0"};
    private static final String[] PREFIXES = new String[]{"", "infested_", "smooth_"};
    private static final Map<String, Integer> HARDCODED_COLOURS = ImmutableMap.builder().put((Object)"minecraft:water", (Object)-12618012).put((Object)"minecraft:flowing_water", (Object)-12618012).put((Object)"minecraft:lava", (Object)-113878).put((Object)"minecraft:flowing_lava", (Object)-113878).put((Object)"minecraft:birch_leaves", (Object)-8345771).put((Object)"minecraft:spruce_leaves", (Object)-10380959).put((Object)"minecraft:lily_pad", (Object)-14647248).put((Object)"minecraft:grass_block", (Object)-7226023).put((Object)"minecraft:dirt_path", (Object)-7226023).put((Object)"minecraft:grass_path", (Object)-7226023).put((Object)"minecraft:grass", (Object)-7226023).put((Object)"minecraft:tall_grass", (Object)-7226023).put((Object)"minecraft:fern", (Object)-7226023).put((Object)"minecraft:large_fern", (Object)-7226023).put((Object)"minecraft:potted_fern", (Object)-7226023).put((Object)"minecraft:sugar_cane", (Object)-7226023).put((Object)"minecraft:oak_leaves", (Object)-8934609).put((Object)"minecraft:jungle_leaves", (Object)-8934609).put((Object)"minecraft:acacia_leaves", (Object)-8934609).put((Object)"minecraft:dark_oak_leaves", (Object)-8934609).put((Object)"minecraft:vine", (Object)-8934609).put((Object)"minecraft:melon_stem", (Object)-8934609).put((Object)"minecraft:pumpkin_stem", (Object)-8934609).build();
    private static final Map<String, Material> PATCHES = ImmutableMap.of((Object)"minecraft:grass_path", (Object)Material.DIRT_PATH);
    private static final ColourScheme DYNMAP_COLOUR_SCHEME = DynmapColourScheme.loadDynMapColourScheme("default", 0);
    private static final Map<String, Set<Map<String, Object>>> MATERIAL_SPECS = new HashMap<String, Set<Map<String, Object>>>();

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        UpdateMaterials.enrichMaterialsFromPluginDump(args);
    }

    private static void enrichMaterialsWithTransmissiveness() throws IOException, ClassNotFoundException {
        Configuration config = Configuration.load();
        if (config == null) {
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        try (InputStreamReader in = new InputStreamReader(Material.class.getResourceAsStream("mc-materials.csv"), StandardCharsets.UTF_8);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);){
            CSVDataSource csvIn = new CSVDataSource();
            csvIn.openForReading((Reader)in);
            CSVDataSource csvOut = new CSVDataSource();
            csvOut.openForWriting((Writer)out, new String[]{"name", "discriminator", "properties", "opacity", "receivesLight", "terrain", "insubstantial", "veryInsubstantial", "resource", "tileEntity", "tileEntityId", "treeRelated", "vegetation", "blockLight", "natural", "watery", "colour", "colourOrigin"});
            do {
                String name = csvIn.getString("name");
                csvOut.setString("name", name);
                csvOut.setString("discriminator", csvIn.getString("discriminator"));
                csvOut.setString("properties", csvIn.getString("properties"));
                csvOut.setInt("opacity", csvIn.getInt("opacity"));
                csvOut.setBoolean("receivesLight", MaterialImporter.guessReceivesLight((String)name));
                csvOut.setBoolean("terrain", csvIn.getBoolean("terrain"));
                csvOut.setBoolean("insubstantial", csvIn.getBoolean("insubstantial"));
                csvOut.setBoolean("veryInsubstantial", csvIn.getBoolean("veryInsubstantial"));
                csvOut.setBoolean("resource", csvIn.getBoolean("resource"));
                csvOut.setBoolean("tileEntity", csvIn.getBoolean("tileEntity"));
                csvOut.setString("tileEntityId", csvIn.getString("tileEntityId"));
                csvOut.setBoolean("treeRelated", csvIn.getBoolean("treeRelated"));
                csvOut.setBoolean("vegetation", csvIn.getBoolean("vegetation"));
                csvOut.setInt("blockLight", csvIn.getInt("blockLight"));
                csvOut.setBoolean("natural", csvIn.getBoolean("natural"));
                csvOut.setBoolean("watery", csvIn.getBoolean("watery"));
                csvOut.setString("colour", csvIn.getString("colour"));
                csvOut.setString("colourOrigin", csvIn.getString("colourOrigin"));
                csvIn.next();
                csvOut.next();
            } while (!csvIn.isEndOfFile());
        }
    }

    private static void enrichMaterialsWithColours() throws IOException, ClassNotFoundException {
        Configuration config = Configuration.load();
        if (config == null) {
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        try (JarFile jarFile = new JarFile(BiomeSchemeManager.getLatestMinecraftJar(), true, 1);
             InputStreamReader in = new InputStreamReader(Material.class.getResourceAsStream("mc-materials.csv"), StandardCharsets.UTF_8);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);){
            System.out.printf("Using jar: %s%n%n", jarFile.getName());
            CSVDataSource csvIn = new CSVDataSource();
            csvIn.openForReading((Reader)in);
            CSVDataSource csvOut = new CSVDataSource();
            csvOut.openForWriting((Writer)out, new String[]{"name", "discriminator", "properties", "opacity", "terrain", "insubstantial", "veryInsubstantial", "resource", "tileEntity", "treeRelated", "vegetation", "blockLight", "natural", "watery", "colour", "colourOrigin"});
            do {
                String name = csvIn.getString("name");
                csvOut.setString("name", name);
                String str = csvIn.getString("discriminator");
                if (!Strings.isNullOrEmpty((String)str)) {
                    csvOut.setString("discriminator", str);
                }
                if (!Strings.isNullOrEmpty((String)(str = csvIn.getString("properties")))) {
                    csvOut.setString("properties", str);
                }
                csvOut.setInt("opacity", csvIn.getInt("opacity"));
                csvOut.setBoolean("terrain", csvIn.getBoolean("terrain"));
                csvOut.setBoolean("insubstantial", csvIn.getBoolean("insubstantial"));
                csvOut.setBoolean("veryInsubstantial", csvIn.getBoolean("veryInsubstantial"));
                csvOut.setBoolean("resource", csvIn.getBoolean("resource"));
                csvOut.setBoolean("tileEntity", csvIn.getBoolean("tileEntity"));
                csvOut.setBoolean("treeRelated", csvIn.getBoolean("treeRelated"));
                csvOut.setBoolean("vegetation", csvIn.getBoolean("vegetation"));
                csvOut.setInt("blockLight", csvIn.getInt("blockLight"));
                csvOut.setBoolean("natural", csvIn.getBoolean("natural"));
                csvOut.setBoolean("watery", csvIn.getBoolean("watery"));
                if (!Strings.isNullOrEmpty((String)csvIn.getString("colour"))) {
                    csvOut.setString("colour", csvIn.getString("colour"));
                    if (csvIn.getString("colourOrigin") != null) {
                        csvOut.setString("colourOrigin", csvIn.getString("colourOrigin"));
                    }
                } else {
                    ColourAndOrigin colourAndOrigin;
                    Material material = Material.getPrototype((String)name);
                    if (material == null) {
                        material = Material.get((String)name, (Object[])new Object[0]);
                    }
                    if ((colourAndOrigin = UpdateMaterials.determineColour(material, jarFile)) != null) {
                        csvOut.setString("colour", String.format("%8x", colourAndOrigin.colour));
                        csvOut.setString("colourOrigin", colourAndOrigin.origin);
                    }
                }
                csvIn.next();
                csvOut.next();
            } while (!csvIn.isEndOfFile());
        }
    }

    private static void enrichMaterialsFromPluginDump(String[] args) throws IOException, ClassNotFoundException {
        Configuration config = Configuration.load();
        if (config == null) {
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        try (JarFile jarFile = new JarFile(BiomeSchemeManager.getLatestMinecraftJar(), true, 1);
             FileReader in = new FileReader("F:\\Projects\\Java\\Minecraft\\Forge\\BlockExporter\\run\\materials.csv");
             FileWriter out = new FileWriter("materials-out.csv");){
            CSVDataSource csvIn = new CSVDataSource();
            CSVDataSource csvOut = new CSVDataSource();
            csvIn.openForReading((Reader)in);
            csvOut.openForWriting((Writer)out, new String[]{"name", "discriminator", "properties", "opacity", "receivesLight", "terrain", "insubstantial", "veryInsubstantial", "resource", "tileEntity", "tileEntityId", "treeRelated", "vegetation", "blockLight", "natural", "watery", "colour", "colourOrigin"});
            do {
                String name = csvIn.getString("name");
                String properties = csvIn.getString("properties");
                boolean tileEntity = csvIn.getBoolean("tileEntity");
                String tileEntityId = csvIn.getString("tileEntityId");
                int blockLight = csvIn.getInt("blockLight");
                if (!MATERIAL_SPECS.containsKey(name)) {
                    csvOut.setString("name", name);
                    if (!Strings.isNullOrEmpty((String)properties)) {
                        csvOut.setString("properties", properties);
                    }
                    csvOut.setInt("opacity", MaterialImporter.guessOpacity((String)name));
                    csvOut.setBoolean("receivesLight", MaterialImporter.guessReceivesLight((String)name));
                    csvOut.setBoolean("terrain", false);
                    csvOut.setBoolean("insubstantial", MaterialImporter.guessInsubstantial((String)name));
                    csvOut.setBoolean("veryInsubstantial", MaterialImporter.guessVeryInsubstantial((String)name));
                    csvOut.setBoolean("resource", MaterialImporter.guessResource((String)name));
                    csvOut.setBoolean("tileEntity", tileEntity);
                    if (!Strings.isNullOrEmpty((String)tileEntityId)) {
                        csvOut.setString("tileEntityId", tileEntityId);
                    }
                    csvOut.setBoolean("treeRelated", MaterialImporter.guessTreeRelated((String)name));
                    csvOut.setBoolean("vegetation", MaterialImporter.guessVegetation((String)name));
                    csvOut.setInt("blockLight", blockLight);
                    csvOut.setBoolean("natural", MaterialImporter.guessNatural((String)name));
                    csvOut.setBoolean("watery", false);
                    ColourAndOrigin colourAndOrigin = UpdateMaterials.findAverageColour(jarFile, name.substring(name.indexOf(58) + 1));
                    if (colourAndOrigin != null) {
                        csvOut.setString("colour", String.format("%8x", colourAndOrigin.colour));
                        csvOut.setString("colourOrigin", colourAndOrigin.origin);
                    }
                    csvOut.next();
                }
                csvIn.next();
            } while (!csvIn.isEndOfFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ColourAndOrigin determineColour(Material material, JarFile jarFile) {
        if (DYNMAP_COLOUR_SCHEME.getColour(material = PATCHES.getOrDefault(material.name, material)) != 0xFF00FF) {
            return new ColourAndOrigin(DYNMAP_COLOUR_SCHEME.getColour(material), "old default");
        }
        if (HARDCODED_COLOURS.containsKey(material.name)) {
            return new ColourAndOrigin(HARDCODED_COLOURS.get(material.name), "hardcoded");
        }
        return UpdateMaterials.findAverageColour(jarFile, material.simpleName);
    }

    private static ColourAndOrigin findAverageColour(JarFile jarFile, String simpleName) {
        JarEntry entry = UpdateMaterials.findJarEntry(jarFile, simpleName);
        if (entry != null) {
            int red = 0;
            int green = 0;
            int blue = 0;
            int pixelCount = 0;
            try (InputStream in = jarFile.getInputStream(entry);){
                BufferedImage image = ImageIO.read(in);
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        int colour = image.getRGB(x, y);
                        if ((colour & 0xFF000000) == 0) continue;
                        red += (colour & 0xFF0000) >> 16;
                        green += (colour & 0xFF00) >> 8;
                        blue += colour & 0xFF;
                        ++pixelCount;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new ColourAndOrigin(0xFF000000 | red / pixelCount << 16 | green / pixelCount << 8 | blue / pixelCount, entry.getName().substring(entry.getName().lastIndexOf(47) + 1));
        }
        return null;
    }

    private static JarEntry findJarEntry(JarFile jarFile, String name) {
        do {
            for (String prefix : PREFIXES) {
                String subName = name.startsWith(prefix) ? name.substring(prefix.length()) : name;
                for (String extension : EXTENSIONS) {
                    JarEntry entry = jarFile.getJarEntry("assets/minecraft/textures/block/" + subName + extension + ".png");
                    if (entry == null) continue;
                    return entry;
                }
            }
        } while (!(name = name.substring(0, Math.max(name.lastIndexOf(95), 0))).isEmpty());
        return null;
    }

    static {
        try (InputStreamReader in = new InputStreamReader(Objects.requireNonNull(Material.class.getResourceAsStream("mc-materials.csv")), StandardCharsets.UTF_8);){
            CSVDataSource csvDataSource = new CSVDataSource();
            csvDataSource.openForReading((Reader)in);
            do {
                HashMap<String, Object> materialSpecs = new HashMap<String, Object>();
                String name = csvDataSource.getString("name");
                materialSpecs.put("name", name);
                String str = csvDataSource.getString("discriminator");
                if (!Strings.isNullOrEmpty((String)str)) {
                    materialSpecs.put("discriminator", ImmutableSet.copyOf((Object[])str.split(",")));
                }
                if (!Strings.isNullOrEmpty((String)(str = csvDataSource.getString("properties")))) {
                    materialSpecs.put("properties", ImmutableSet.copyOf((Object[])str.split(",")));
                }
                materialSpecs.put("opacity", csvDataSource.getInt("opacity"));
                materialSpecs.put("terrain", csvDataSource.getBoolean("terrain"));
                materialSpecs.put("insubstantial", csvDataSource.getBoolean("insubstantial"));
                materialSpecs.put("veryInsubstantial", csvDataSource.getBoolean("veryInsubstantial"));
                materialSpecs.put("resource", csvDataSource.getBoolean("resource"));
                materialSpecs.put("tileEntity", csvDataSource.getBoolean("tileEntity"));
                materialSpecs.put("treeRelated", csvDataSource.getBoolean("treeRelated"));
                materialSpecs.put("vegetation", csvDataSource.getBoolean("vegetation"));
                materialSpecs.put("blockLight", csvDataSource.getInt("blockLight"));
                materialSpecs.put("natural", csvDataSource.getBoolean("natural"));
                materialSpecs.put("watery", csvDataSource.getBoolean("watery"));
                str = csvDataSource.getString("colour");
                if (!Strings.isNullOrEmpty((String)str)) {
                    materialSpecs.put("colour", Integer.parseUnsignedInt(str, 16));
                }
                if (!Strings.isNullOrEmpty((String)(str = csvDataSource.getString("colourOrigin")))) {
                    materialSpecs.put("colourOrigin", str);
                }
                MATERIAL_SPECS.computeIfAbsent(name, s -> new HashSet()).add(materialSpecs);
                csvDataSource.next();
            } while (!csvDataSource.isEndOfFile());
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading Minecraft materials database materials.csv from classpath", e);
        }
    }

    public static class ColourAndOrigin {
        public final int colour;
        public final String origin;

        ColourAndOrigin(int colour, String origin) {
            this.colour = 0xFF000000 | colour;
            this.origin = origin;
        }
    }
}

