/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import java.util.List;
import javax.vecmath.Point3i;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.Box;
import org.pepsoft.worldpainter.dynmap.DynmapBlockStateHelper;
import org.pepsoft.worldpainter.dynmap.WPObjectMapChunkCache;
import org.pepsoft.worldpainter.objects.WPObject;

class WPObjectDynmapWorld
extends DynmapWorld {
    final WPObject object;
    final Box bounds;
    final int xOffset;
    final int yOffset;
    final DynmapBlockState[][][] blockStates;
    private final WPObjectMapChunkCache chunkCache;
    private final int[][][] lightLevels;
    private final int[][] heights;
    private static final DynmapBlockState MISSING_BLOCK_STATE = DynmapBlockStateHelper.getDynmapBlockState(Material.WOOL_MAGENTA);

    WPObjectDynmapWorld(WPObject object) {
        super(object.getName(), object.getDimensions().z, 0);
        this.object = object;
        this.chunkCache = new WPObjectMapChunkCache(this);
        Point3i offset = object.getOffset();
        this.xOffset = offset.x;
        this.yOffset = offset.y;
        Point3i dimensions = object.getDimensions();
        this.bounds = new Box(this.xOffset, dimensions.x + this.xOffset, this.yOffset, dimensions.y + this.yOffset, 0, dimensions.z);
        this.blockStates = new DynmapBlockState[dimensions.x][dimensions.y][dimensions.z];
        this.lightLevels = new int[dimensions.x][dimensions.y][dimensions.z];
        this.heights = new int[dimensions.x][dimensions.y];
        for (int x = 0; x < dimensions.x; ++x) {
            for (int y = 0; y < dimensions.y; ++y) {
                for (int z = 0; z < dimensions.z; ++z) {
                    if (object.getMask(x, y, z)) {
                        Material material = object.getMaterial(x, y, z);
                        if (material.empty) {
                            this.blockStates[x][y][z] = DynmapBlockState.AIR;
                            continue;
                        }
                        DynmapBlockState blockState = DynmapBlockStateHelper.getDynmapBlockState(material);
                        this.blockStates[x][y][z] = blockState != null ? blockState : MISSING_BLOCK_STATE;
                        this.lightLevels[x][y][z] = material.blockLight;
                        continue;
                    }
                    this.blockStates[x][y][z] = DynmapBlockState.AIR;
                }
                int height = -1;
                for (int z = object.getDimensions().z - 1; z >= 0; --z) {
                    if (!object.getMask(x, y, z)) continue;
                    height = z;
                    break;
                }
                this.heights[x][y] = height;
            }
        }
    }

    public boolean isNether() {
        return false;
    }

    public DynmapLocation getSpawnLocation() {
        return null;
    }

    public long getTime() {
        return 10000L;
    }

    public boolean hasStorm() {
        return false;
    }

    public boolean isThundering() {
        return false;
    }

    public boolean isLoaded() {
        return true;
    }

    public void setWorldUnloaded() {
    }

    public int getLightLevel(int x, int y, int z) {
        return 15;
    }

    public int getHighestBlockYAt(int x, int z) {
        if (this.bounds.containsXY(x, z)) {
            return this.heights[x - this.xOffset][z - this.yOffset];
        }
        return -1;
    }

    public boolean canGetSkyLightLevel() {
        return false;
    }

    public int getSkyLightLevel(int x, int y, int z) {
        throw new UnsupportedOperationException();
    }

    public String getEnvironment() {
        return "normal";
    }

    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        return this.chunkCache;
    }
}

