/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.dynmap.Color;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.MapTypeState;
import org.dynmap.hdmap.CustomBlockModel;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDBlockStateTextureMap;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDMapTile;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDScaledBlockModels;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.LightLevels;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.Matrix3D;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.Vector3D;

public class DynmapRenderer {
    private final HDPerspective perspective;
    private final HDMap map;
    private final Matrix3D world_to_map;
    private final Matrix3D map_to_world;
    private final int basemodscale;
    private final int[] argb_buf;
    private final BufferedImage buf_img;
    public static final int TILE_WIDTH = 128;
    public static final int TILE_HEIGHT = 128;
    private static final BlockStep[] SEMI_STEPS = new BlockStep[]{BlockStep.Y_PLUS, BlockStep.X_MINUS, BlockStep.X_PLUS, BlockStep.Z_MINUS, BlockStep.Z_PLUS};
    private static final int[] BAND_MASKS = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final Object PATCH_ACCESS_LOCK = new Object();
    private static RenderPatch[][] custom_meshes_by_globalstateindex = null;

    public DynmapRenderer(HDPerspective perspective, HDMap map, int scale, double inclination, double azimuth) {
        this.perspective = perspective;
        this.map = map;
        if (custom_meshes_by_globalstateindex == null) {
            custom_meshes_by_globalstateindex = new RenderPatch[DynmapBlockState.getGlobalIndexMax()][];
        }
        this.basemodscale = scale;
        Matrix3D transform = new Matrix3D(0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        transform.rotateXY(180.0 - azimuth);
        transform.rotateYZ(90.0 - inclination);
        transform.shearZ(0.0, Math.tan(Math.toRadians(90.0 - inclination)));
        transform.scale((double)this.basemodscale, (double)this.basemodscale, Math.sin(Math.toRadians(inclination)));
        this.world_to_map = transform;
        transform = new Matrix3D();
        transform.scale(1.0 / (double)this.basemodscale, 1.0 / (double)this.basemodscale, 1.0 / Math.sin(Math.toRadians(inclination)));
        transform.shearZ(0.0, -Math.tan(Math.toRadians(90.0 - inclination)));
        transform.rotateYZ(-(90.0 - inclination));
        transform.rotateXY(-180.0 + azimuth);
        Matrix3D coordswap = new Matrix3D(0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0);
        transform.multiply(coordswap);
        this.map_to_world = transform;
        this.argb_buf = new int[16384];
        DataBufferInt db = new DataBufferInt(this.argb_buf, 16384);
        WritableRaster raster = Raster.createPackedRaster(db, 128, 128, 128, BAND_MASKS, null);
        ColorModel color_model = ColorModel.getRGBdefault();
        this.buf_img = new BufferedImage(color_model, raster, false, null);
    }

    BufferedImage render(MapChunkCache cache, HDMapTile tile) {
        Color rslt = new Color();
        MapIterator mapiter = cache.getIterator(0, 0, 0);
        DynmapWorld world = tile.getDynmapWorld();
        int scaled = 0;
        if (tile.boostzoom > 0 && MarkerAPIImpl.testTileForBoostMarkers((DynmapWorld)cache.getWorld(), (HDPerspective)this.perspective, (double)(tile.tx * 128), (double)(tile.ty * 128), (double)128.0)) {
            scaled = tile.boostzoom;
        }
        int sizescale = 1 << scaled;
        HDShaderState shaderstate = this.map.getShader().getStateInstance(this.map, cache, mapiter, sizescale * this.basemodscale);
        boolean isnether = world.isNether();
        MapTypeState mts = world.getMapState((MapType)this.map);
        if (mts != null) {
            mts.validateTile(tile.tx, tile.ty);
        }
        OurPerspectiveState ps = new OurPerspectiveState(mapiter, isnether, scaled);
        ps.top = new Vector3D();
        ps.bottom = new Vector3D();
        ps.direction = new Vector3D();
        double xbase = tile.tx * 128;
        double ybase = tile.ty * 128;
        boolean[] shaderdone = new boolean[1];
        double height = isnether ? 127.0 : (double)(tile.getDynmapWorld().worldheight - 1);
        double miny = tile.getDynmapWorld().minY;
        for (int x = 0; x < 128 * sizescale; ++x) {
            ps.px = x;
            for (int y = 0; y < 128 * sizescale; ++y) {
                int c_argb;
                ps.top.x = ps.bottom.x = xbase + ((double)x + 0.5) / (double)sizescale;
                ps.top.y = ps.bottom.y = ybase + ((double)y + 0.5) / (double)sizescale;
                ps.top.z = height + 0.5;
                ps.bottom.z = miny - 0.5;
                this.map_to_world.transform(ps.top);
                this.map_to_world.transform(ps.bottom);
                ps.direction.set(ps.bottom);
                ps.direction.subtract(ps.top);
                ps.py = y / sizescale;
                shaderstate.reset((HDPerspectiveState)ps);
                try {
                    ps.raytrace(cache, shaderstate, shaderdone);
                }
                catch (Exception ex) {
                    Log.severe((String)("Error while raytracing tile: perspective=" + this.perspective + ", coord=" + mapiter.getX() + "," + mapiter.getY() + "," + mapiter.getZ() + ", blockid=" + mapiter.getBlockType() + ", lighting=" + mapiter.getBlockSkyLight() + ":" + mapiter.getBlockEmittedLight() + ", biome=" + mapiter.getBiome().toString()), (Throwable)ex);
                    ex.printStackTrace();
                }
                if (!shaderdone[0]) {
                    shaderstate.rayFinished((HDPerspectiveState)ps);
                } else {
                    shaderdone[0] = false;
                }
                shaderstate.getRayColor(rslt, 0);
                this.argb_buf[(128 * sizescale - y - 1) * 128 * sizescale + x] = c_argb = rslt.getARGB();
            }
        }
        return this.buf_img;
    }

    public Rectangle getTileCoords(int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        Vector3D[] blocks = new Vector3D[]{new Vector3D(), new Vector3D()};
        blocks[0].x = minx - 1;
        blocks[0].y = miny - 1;
        blocks[0].z = minz - 1;
        blocks[1].x = maxx + 1;
        blocks[1].y = maxy + 1;
        blocks[1].z = maxz + 1;
        Vector3D corner = new Vector3D();
        Vector3D tcorner = new Vector3D();
        int mintilex = Integer.MAX_VALUE;
        int maxtilex = Integer.MIN_VALUE;
        int mintiley = Integer.MAX_VALUE;
        int maxtiley = Integer.MIN_VALUE;
        for (int i = 0; i < 2; ++i) {
            corner.x = blocks[i].x;
            for (int j = 0; j < 2; ++j) {
                corner.y = blocks[j].y;
                for (int k = 0; k < 2; ++k) {
                    corner.z = blocks[k].z;
                    this.world_to_map.transform(corner, tcorner);
                    int tx = DynmapRenderer.fastFloor(tcorner.x / 128.0);
                    int ty = DynmapRenderer.fastFloor(tcorner.y / 128.0);
                    if (mintilex > tx) {
                        mintilex = tx;
                    }
                    if (maxtilex < tx) {
                        maxtilex = tx;
                    }
                    if (mintiley > ty) {
                        mintiley = ty;
                    }
                    if (maxtiley >= ty) continue;
                    maxtiley = ty;
                }
            }
        }
        return new Rectangle(mintilex, mintiley, maxtilex - mintilex + 1, maxtiley - mintiley + 1);
    }

    private static int fastFloor(double f) {
        return (int)(f + 1.0E9) - 1000000000;
    }

    private class OurPerspectiveState
    implements HDPerspectiveState {
        DynmapBlockState blocktype = DynmapBlockState.AIR;
        DynmapBlockState lastblocktype = DynmapBlockState.AIR;
        Vector3D top;
        Vector3D bottom;
        Vector3D direction;
        int px;
        int py;
        BlockStep laststep = BlockStep.Y_MINUS;
        BlockStep stepx;
        BlockStep stepy;
        BlockStep stepz;
        private final HDScaledBlockModels scalemodels;
        private final int modscale;
        int sx;
        int sy;
        int sz;
        double sdt_dx;
        double sdt_dy;
        double sdt_dz;
        double st_next_x;
        double st_next_y;
        double st_next_z;
        double dx;
        double dy;
        double dz;
        int x;
        int y;
        int z;
        double dt_dx;
        double dt_dy;
        double dt_dz;
        double t;
        int n;
        int x_inc;
        int y_inc;
        int z_inc;
        double t_next_y;
        double t_next_x;
        double t_next_z;
        boolean nonairhit;
        int mx;
        int my;
        int mz;
        double xx;
        double yy;
        double zz;
        double mdt_dx;
        double mdt_dy;
        double mdt_dz;
        double togo;
        double mt_next_x;
        double mt_next_y;
        double mt_next_z;
        int subalpha;
        double mt;
        double mtend;
        int mxout;
        int myout;
        int mzout;
        Vector3D v0 = new Vector3D();
        Vector3D vS = new Vector3D();
        Vector3D d_cross_uv = new Vector3D();
        double[] patch_t = new double[2 * HDBlockModels.getMaxPatchCount()];
        double[] patch_u = new double[2 * HDBlockModels.getMaxPatchCount()];
        double[] patch_v = new double[2 * HDBlockModels.getMaxPatchCount()];
        boolean[] patch_shade = new boolean[2 * HDBlockModels.getMaxPatchCount()];
        BlockStep[] patch_step = new BlockStep[2 * HDBlockModels.getMaxPatchCount()];
        int[] patch_id = new int[2 * HDBlockModels.getMaxPatchCount()];
        int cur_patch = -1;
        double cur_patch_u;
        double cur_patch_v;
        double cur_patch_t;
        boolean cur_shade;
        int[] subblock_xyz = new int[3];
        final MapIterator mapiter;
        final boolean isnether;
        boolean skiptoair;
        final int worldheight;
        final LightLevels[] llcache;
        private final DynLongHashMap custom_meshes;
        private final DynLongHashMap custom_fluid_meshes;

        public OurPerspectiveState(MapIterator mi, boolean isnether, int scaled) {
            this.mapiter = mi;
            this.isnether = isnether;
            this.worldheight = this.mapiter.getWorldHeight();
            this.llcache = new LightLevels[4];
            for (int i = 0; i < this.llcache.length; ++i) {
                this.llcache[i] = new LightLevels();
            }
            this.custom_meshes = new DynLongHashMap(4096);
            this.custom_fluid_meshes = new DynLongHashMap(4096);
            this.modscale = DynmapRenderer.this.basemodscale << scaled;
            this.scalemodels = HDBlockModels.getModelsForScale((int)(DynmapRenderer.this.basemodscale << scaled));
        }

        private void updateSemitransparentLight(LightLevels ll) {
            int emitted = 0;
            int sky = 0;
            for (int i = 0; i < SEMI_STEPS.length; ++i) {
                int emit_sky_light = this.mapiter.getBlockLight(SEMI_STEPS[i]);
                if (emit_sky_light >> 8 > emitted) {
                    emitted = emit_sky_light >> 8;
                }
                if ((emit_sky_light & 0xF) <= sky) continue;
                sky = emit_sky_light & 0xF;
            }
            ll.sky = sky;
            ll.emitted = emitted;
        }

        private void updateLightLevel(DynmapBlockState blk, LightLevels ll) {
            TexturePack.BlockTransparency bt = HDBlockStateTextureMap.getTransparency((DynmapBlockState)blk);
            switch (bt) {
                case TRANSPARENT: {
                    ll.sky = this.mapiter.getBlockSkyLight();
                    ll.emitted = this.mapiter.getBlockEmittedLight();
                    break;
                }
                case OPAQUE: {
                    if (HDBlockStateTextureMap.getTransparency((DynmapBlockState)this.lastblocktype) != TexturePack.BlockTransparency.SEMITRANSPARENT) {
                        int emit_sky_light = this.mapiter.getBlockLight(this.laststep.opposite());
                        ll.sky = emit_sky_light & 0xF;
                        ll.emitted = emit_sky_light >> 8;
                        break;
                    }
                    this.mapiter.unstepPosition(this.laststep);
                    this.updateSemitransparentLight(ll);
                    this.mapiter.stepPosition(this.laststep);
                    break;
                }
                case SEMITRANSPARENT: {
                    this.updateSemitransparentLight(ll);
                    break;
                }
                default: {
                    ll.sky = this.mapiter.getBlockSkyLight();
                    ll.emitted = this.mapiter.getBlockEmittedLight();
                }
            }
        }

        public final void getLightLevels(LightLevels ll) {
            this.updateLightLevel(this.blocktype, ll);
        }

        public final void getLightLevelsAtStep(BlockStep step, LightLevels ll) {
            if (step == BlockStep.Y_MINUS && this.y == 0 || step == BlockStep.Y_PLUS && this.y == this.worldheight) {
                this.getLightLevels(ll);
                return;
            }
            BlockStep blast = this.laststep;
            this.mapiter.stepPosition(step);
            this.laststep = blast;
            this.updateLightLevel(this.mapiter.getBlockType(), ll);
            this.mapiter.unstepPosition(step);
            this.laststep = blast;
        }

        public final DynmapBlockState getBlockState() {
            return this.blocktype;
        }

        public final BlockStep getLastBlockStep() {
            return this.laststep;
        }

        public final double getScale() {
            return this.modscale;
        }

        public final Vector3D getRayStart() {
            return this.top;
        }

        public final Vector3D getRayEnd() {
            return this.bottom;
        }

        public final int getPixelX() {
            return this.px;
        }

        public final int getPixelY() {
            return this.py;
        }

        public final MapIterator getMapIterator() {
            return this.mapiter;
        }

        public int getSubmodelAlpha() {
            return this.subalpha;
        }

        private void raytrace_init() {
            this.dx = Math.abs(this.direction.x);
            this.dy = Math.abs(this.direction.y);
            this.dz = Math.abs(this.direction.z);
            this.dt_dx = 1.0 / this.dx;
            this.dt_dy = 1.0 / this.dy;
            this.dt_dz = 1.0 / this.dz;
            this.t = 0.0;
            this.n = 1;
            this.sx = DynmapRenderer.fastFloor(this.top.x / 16.0);
            this.sy = DynmapRenderer.fastFloor(this.top.y / 16.0);
            this.sz = DynmapRenderer.fastFloor(this.top.z / 16.0);
            this.sdt_dx = 16.0 / this.dx;
            this.sdt_dy = 16.0 / this.dy;
            this.sdt_dz = 16.0 / this.dz;
            if (this.dx == 0.0) {
                this.x_inc = 0;
                this.st_next_x = Double.MAX_VALUE;
                this.stepx = BlockStep.X_PLUS;
                this.mxout = this.modscale;
            } else if (this.bottom.x > this.top.x) {
                this.x_inc = 1;
                this.n += DynmapRenderer.fastFloor(this.bottom.x) - this.x;
                this.st_next_x = ((double)(DynmapRenderer.fastFloor(this.top.x / 16.0) + 1) - this.top.x / 16.0) * this.sdt_dx;
                this.stepx = BlockStep.X_PLUS;
                this.mxout = this.modscale;
            } else {
                this.x_inc = -1;
                this.n += this.x - DynmapRenderer.fastFloor(this.bottom.x);
                this.st_next_x = (this.top.x / 16.0 - (double)DynmapRenderer.fastFloor(this.top.x / 16.0)) * this.sdt_dx;
                this.stepx = BlockStep.X_MINUS;
                this.mxout = -1;
            }
            if (this.dy == 0.0) {
                this.y_inc = 0;
                this.st_next_y = Double.MAX_VALUE;
                this.stepy = BlockStep.Y_PLUS;
                this.myout = this.modscale;
            } else if (this.bottom.y > this.top.y) {
                this.y_inc = 1;
                this.n += DynmapRenderer.fastFloor(this.bottom.y) - this.y;
                this.st_next_y = ((double)(DynmapRenderer.fastFloor(this.top.y / 16.0) + 1) - this.top.y / 16.0) * this.sdt_dy;
                this.stepy = BlockStep.Y_PLUS;
                this.myout = this.modscale;
            } else {
                this.y_inc = -1;
                this.n += this.y - DynmapRenderer.fastFloor(this.bottom.y);
                this.st_next_y = (this.top.y / 16.0 - (double)DynmapRenderer.fastFloor(this.top.y / 16.0)) * this.sdt_dy;
                this.stepy = BlockStep.Y_MINUS;
                this.myout = -1;
            }
            if (this.dz == 0.0) {
                this.z_inc = 0;
                this.st_next_z = Double.MAX_VALUE;
                this.stepz = BlockStep.Z_PLUS;
                this.mzout = this.modscale;
            } else if (this.bottom.z > this.top.z) {
                this.z_inc = 1;
                this.n += DynmapRenderer.fastFloor(this.bottom.z) - this.z;
                this.st_next_z = ((double)(DynmapRenderer.fastFloor(this.top.z / 16.0) + 1) - this.top.z / 16.0) * this.sdt_dz;
                this.stepz = BlockStep.Z_PLUS;
                this.mzout = this.modscale;
            } else {
                this.z_inc = -1;
                this.n += this.z - DynmapRenderer.fastFloor(this.bottom.z);
                this.st_next_z = (this.top.z / 16.0 - (double)DynmapRenderer.fastFloor(this.top.z / 16.0)) * this.sdt_dz;
                this.stepz = BlockStep.Z_MINUS;
                this.mzout = -1;
            }
            this.laststep = BlockStep.Y_MINUS;
            this.nonairhit = false;
            this.skiptoair = this.isnether;
        }

        private boolean handleSubModel(short[] model, HDShaderState shaderstate, boolean[] shaderdone) {
            boolean firststep = true;
            while (!this.raytraceSubblock(model, firststep)) {
                boolean done;
                if (!shaderdone[0]) {
                    shaderdone[0] = shaderstate.processBlock((HDPerspectiveState)this);
                }
                if (done = shaderdone[0]) {
                    return true;
                }
                this.nonairhit = true;
                firststep = false;
            }
            if (!shaderdone[0]) {
                shaderstate.setLastBlockState(this.blocktype);
            }
            return false;
        }

        private int handlePatch(PatchDefinition pd, int hitcnt) {
            this.v0.x = (double)this.x + pd.x0;
            this.v0.y = (double)this.y + pd.y0;
            this.v0.z = (double)this.z + pd.z0;
            this.d_cross_uv.set(this.direction);
            this.d_cross_uv.crossProduct(pd.v);
            double det = pd.u.innerProduct(this.d_cross_uv);
            switch (pd.sidevis) {
                case TOP: 
                case TOPFLIP: 
                case TOPFLIPV: 
                case TOPFLIPHV: {
                    if (!(det < 1.0E-6)) break;
                    return hitcnt;
                }
                case BOTTOM: {
                    if (!(det > -1.0E-6)) break;
                    return hitcnt;
                }
                case BOTH: 
                case FLIP: {
                    if (!(det > -1.0E-6) || !(det < 1.0E-6)) break;
                    return hitcnt;
                }
            }
            double inv_det = 1.0 / det;
            this.vS.set(this.top);
            this.vS.subtract(this.v0);
            double u = inv_det * this.vS.innerProduct(this.d_cross_uv);
            if (u <= pd.umin || u >= pd.umax) {
                return hitcnt;
            }
            this.vS.crossProduct(pd.u);
            double v = inv_det * this.direction.innerProduct(this.vS);
            double urel = u > pd.umin ? (u - pd.umin) / (pd.umax - pd.umin) : 0.0;
            double vmaxatu = pd.vmax + (pd.vmaxatumax - pd.vmax) * urel;
            double vminatu = pd.vmin + (pd.vminatumax - pd.vmin) * urel;
            if (v <= vminatu || v >= vmaxatu) {
                return hitcnt;
            }
            double t = inv_det * pd.v.innerProduct(this.vS);
            if (t > 1.0E-6) {
                this.patch_t[hitcnt] = t;
                this.patch_u[hitcnt] = u;
                this.patch_v[hitcnt] = v;
                this.patch_shade[hitcnt] = pd.shade;
                this.patch_id[hitcnt] = pd.textureindex;
                if (det > 0.0) {
                    this.patch_step[hitcnt] = pd.step.opposite();
                    if (pd.sidevis == RenderPatchFactory.SideVisible.TOPFLIP) {
                        this.patch_u[hitcnt] = 1.0 - u;
                    } else if (pd.sidevis == RenderPatchFactory.SideVisible.TOPFLIPV) {
                        this.patch_v[hitcnt] = 1.0 - v;
                    } else if (pd.sidevis == RenderPatchFactory.SideVisible.TOPFLIPHV) {
                        this.patch_u[hitcnt] = 1.0 - u;
                        this.patch_v[hitcnt] = 1.0 - v;
                    }
                } else {
                    if (pd.sidevis == RenderPatchFactory.SideVisible.FLIP) {
                        this.patch_u[hitcnt] = 1.0 - u;
                    }
                    this.patch_step[hitcnt] = pd.step;
                }
                ++hitcnt;
            }
            return hitcnt;
        }

        private boolean handlePatches(RenderPatch[] patches, HDShaderState shaderstate, boolean[] shaderdone, DynmapBlockState fluidstate, RenderPatch[] fluidpatches) {
            int hitcnt = 0;
            int water_hit = Integer.MAX_VALUE;
            for (int i = 0; i < patches.length; ++i) {
                hitcnt = this.handlePatch((PatchDefinition)patches[i], hitcnt);
            }
            if (fluidpatches != null && fluidpatches.length > 0) {
                int prev_hitcnt = hitcnt;
                for (int i = 0; i < fluidpatches.length; ++i) {
                    hitcnt = this.handlePatch((PatchDefinition)fluidpatches[i], hitcnt);
                }
                if (prev_hitcnt < hitcnt) {
                    water_hit = prev_hitcnt;
                }
            }
            if (hitcnt == 0) {
                if (!shaderdone[0]) {
                    shaderstate.setLastBlockState(this.blocktype);
                }
                return false;
            }
            BlockStep old_laststep = this.laststep;
            DynmapBlockState cur_bt = this.blocktype;
            for (int i = 0; i < hitcnt; ++i) {
                double best_t = Double.MAX_VALUE;
                int best_patch = 0;
                for (int j = 0; j < hitcnt; ++j) {
                    if (!(this.patch_t[j] < best_t)) continue;
                    best_patch = j;
                    best_t = this.patch_t[j];
                }
                this.cur_patch = this.patch_id[best_patch];
                this.cur_patch_u = this.patch_u[best_patch];
                this.cur_patch_v = this.patch_v[best_patch];
                this.cur_shade = this.patch_shade[best_patch];
                this.laststep = this.patch_step[best_patch];
                this.cur_patch_t = best_t;
                if (best_patch >= water_hit) {
                    this.blocktype = fluidstate;
                }
                if (!shaderdone[0]) {
                    shaderdone[0] = shaderstate.processBlock((HDPerspectiveState)this);
                }
                boolean done = shaderdone[0];
                if (best_patch >= water_hit) {
                    this.blocktype = cur_bt;
                }
                this.cur_patch = -1;
                if (done) {
                    this.laststep = old_laststep;
                    return true;
                }
                this.nonairhit = true;
                this.patch_t[best_patch] = Double.MAX_VALUE;
            }
            this.laststep = old_laststep;
            if (!shaderdone[0]) {
                shaderstate.setLastBlockState(this.blocktype);
            }
            return false;
        }

        private RenderPatch[] getPatches(DynmapBlockState bt, boolean isFluid) {
            CustomBlockModel cbm;
            PatchDefinition[] patches = this.scalemodels.getPatchModel(bt);
            if (patches == null && (cbm = this.scalemodels.getCustomBlockModel(bt)) != null) {
                if (isFluid) {
                    patches = this.getCustomFluidMesh();
                    if (patches == null) {
                        patches = cbm.getMeshForBlock((MapDataContext)this.mapiter);
                        this.setCustomFluidMesh((RenderPatch[])patches);
                    }
                } else if (cbm.isOnlyBlockStateSensitive()) {
                    patches = this.getCustomMeshForState(bt);
                    if (patches == null) {
                        patches = cbm.getMeshForBlock((MapDataContext)this.mapiter);
                        this.setCustomMeshForState(bt, (RenderPatch[])patches);
                    }
                } else {
                    patches = this.getCustomMesh();
                    if (patches == null) {
                        patches = cbm.getMeshForBlock((MapDataContext)this.mapiter);
                        this.setCustomMesh((RenderPatch[])patches);
                    }
                }
            }
            return patches;
        }

        private boolean visit_block(HDShaderState shaderstate, boolean[] shaderdone) {
            this.lastblocktype = this.blocktype;
            this.blocktype = this.mapiter.getBlockType();
            if (this.skiptoair) {
                if (this.blocktype.isAir()) {
                    this.skiptoair = false;
                }
            } else if (this.nonairhit || this.blocktype.isNotAir()) {
                boolean done;
                RenderPatch[] patches = this.getPatches(this.blocktype, false);
                if (patches != null) {
                    RenderPatch[] fluidpatches = null;
                    DynmapBlockState fluidstate = this.blocktype.getLiquidState();
                    if (fluidstate != null) {
                        fluidpatches = this.getPatches(fluidstate, true);
                    }
                    return this.handlePatches(patches, shaderstate, shaderdone, fluidstate, fluidpatches);
                }
                short[] model = this.scalemodels.getScaledModel(this.blocktype);
                if (model != null) {
                    return this.handleSubModel(model, shaderstate, shaderdone);
                }
                this.subalpha = -1;
                if (!shaderdone[0]) {
                    shaderdone[0] = shaderstate.processBlock((HDPerspectiveState)this);
                    shaderstate.setLastBlockState(this.blocktype);
                }
                if (done = shaderdone[0]) {
                    return true;
                }
                this.nonairhit = true;
            }
            return false;
        }

        private boolean raytraceSkipEmpty(MapChunkCache cache) {
            int minsy = cache.getWorld().minY >> 4;
            while (cache.isEmptySection(this.sx, this.sy, this.sz)) {
                if (this.st_next_y <= this.st_next_x && this.st_next_y <= this.st_next_z) {
                    this.sy += this.y_inc;
                    this.t = this.st_next_y;
                    this.st_next_y += this.sdt_dy;
                    this.laststep = this.stepy;
                    if (this.sy >= minsy) continue;
                    return false;
                }
                if (this.st_next_x <= this.st_next_y && this.st_next_x <= this.st_next_z) {
                    this.sx += this.x_inc;
                    this.t = this.st_next_x;
                    this.st_next_x += this.sdt_dx;
                    this.laststep = this.stepx;
                    continue;
                }
                this.sz += this.z_inc;
                this.t = this.st_next_z;
                this.st_next_z += this.sdt_dz;
                this.laststep = this.stepz;
            }
            return true;
        }

        private boolean raytraceStepIterator(int miny, int maxy) {
            if (this.t_next_y <= this.t_next_x && this.t_next_y <= this.t_next_z) {
                this.y += this.y_inc;
                this.t = this.t_next_y;
                this.t_next_y += this.dt_dy;
                this.laststep = this.stepy;
                this.mapiter.stepPosition(this.laststep);
                if (this.y < miny || this.y > maxy) {
                    return false;
                }
            } else if (this.t_next_x <= this.t_next_y && this.t_next_x <= this.t_next_z) {
                this.x += this.x_inc;
                this.t = this.t_next_x;
                this.t_next_x += this.dt_dx;
                this.laststep = this.stepx;
                this.mapiter.stepPosition(this.laststep);
            } else {
                this.z += this.z_inc;
                this.t = this.t_next_z;
                this.t_next_z += this.dt_dz;
                this.laststep = this.stepz;
                this.mapiter.stepPosition(this.laststep);
            }
            return true;
        }

        private void raytrace(MapChunkCache cache, HDShaderState shaderstate, boolean[] shaderdone) {
            int minY = cache.getWorld().minY;
            int height = cache.getWorld().worldheight;
            this.raytrace_init();
            if (!this.raytraceSkipEmpty(cache)) {
                return;
            }
            this.raytrace_section_init();
            if (this.y < minY) {
                return;
            }
            this.mapiter.initialize(this.x, this.y, this.z);
            while (this.n > 0) {
                if (this.visit_block(shaderstate, shaderdone)) {
                    return;
                }
                if (!this.raytraceStepIterator(minY, height)) {
                    return;
                }
                --this.n;
            }
        }

        private void raytrace_section_init() {
            this.t -= 1.0E-6;
            double xx = this.top.x + this.t * this.direction.x;
            double yy = this.top.y + this.t * this.direction.y;
            double zz = this.top.z + this.t * this.direction.z;
            this.x = DynmapRenderer.fastFloor(xx);
            this.y = DynmapRenderer.fastFloor(yy);
            this.z = DynmapRenderer.fastFloor(zz);
            this.t_next_x = this.st_next_x;
            this.t_next_y = this.st_next_y;
            this.t_next_z = this.st_next_z;
            this.n = 1;
            if (this.t_next_x != Double.MAX_VALUE) {
                if (this.stepx == BlockStep.X_PLUS) {
                    this.t_next_x = this.t + ((double)(this.x + 1) - xx) * this.dt_dx;
                    this.n += DynmapRenderer.fastFloor(this.bottom.x) - this.x;
                } else {
                    this.t_next_x = this.t + (xx - (double)this.x) * this.dt_dx;
                    this.n += this.x - DynmapRenderer.fastFloor(this.bottom.x);
                }
            }
            if (this.t_next_y != Double.MAX_VALUE) {
                if (this.stepy == BlockStep.Y_PLUS) {
                    this.t_next_y = this.t + ((double)(this.y + 1) - yy) * this.dt_dy;
                    this.n += DynmapRenderer.fastFloor(this.bottom.y) - this.y;
                } else {
                    this.t_next_y = this.t + (yy - (double)this.y) * this.dt_dy;
                    this.n += this.y - DynmapRenderer.fastFloor(this.bottom.y);
                }
            }
            if (this.t_next_z != Double.MAX_VALUE) {
                if (this.stepz == BlockStep.Z_PLUS) {
                    this.t_next_z = this.t + ((double)(this.z + 1) - zz) * this.dt_dz;
                    this.n += DynmapRenderer.fastFloor(this.bottom.z) - this.z;
                } else {
                    this.t_next_z = this.t + (zz - (double)this.z) * this.dt_dz;
                    this.n += this.z - DynmapRenderer.fastFloor(this.bottom.z);
                }
            }
        }

        private boolean raytraceSubblock(short[] model, boolean firsttime) {
            boolean skip;
            if (firsttime) {
                this.mt = this.t + 1.0E-8;
                this.xx = this.top.x + this.mt * this.direction.x;
                this.yy = this.top.y + this.mt * this.direction.y;
                this.zz = this.top.z + this.mt * this.direction.z;
                this.mx = (int)((this.xx - (double)DynmapRenderer.fastFloor(this.xx)) * (double)this.modscale);
                this.my = (int)((this.yy - (double)DynmapRenderer.fastFloor(this.yy)) * (double)this.modscale);
                this.mz = (int)((this.zz - (double)DynmapRenderer.fastFloor(this.zz)) * (double)this.modscale);
                this.mdt_dx = this.dt_dx / (double)this.modscale;
                this.mdt_dy = this.dt_dy / (double)this.modscale;
                this.mdt_dz = this.dt_dz / (double)this.modscale;
                this.mt_next_x = this.t_next_x;
                this.mt_next_y = this.t_next_y;
                this.mt_next_z = this.t_next_z;
                if (this.mt_next_x != Double.MAX_VALUE) {
                    this.togo = (this.t_next_x - this.t) / this.mdt_dx;
                    this.mt_next_x = this.mt + (this.togo - (double)DynmapRenderer.fastFloor(this.togo)) * this.mdt_dx;
                }
                if (this.mt_next_y != Double.MAX_VALUE) {
                    this.togo = (this.t_next_y - this.t) / this.mdt_dy;
                    this.mt_next_y = this.mt + (this.togo - (double)DynmapRenderer.fastFloor(this.togo)) * this.mdt_dy;
                }
                if (this.mt_next_z != Double.MAX_VALUE) {
                    this.togo = (this.t_next_z - this.t) / this.mdt_dz;
                    this.mt_next_z = this.mt + (this.togo - (double)DynmapRenderer.fastFloor(this.togo)) * this.mdt_dz;
                }
                this.mtend = Math.min(this.t_next_x, Math.min(this.t_next_y, this.t_next_z));
            }
            this.subalpha = -1;
            boolean bl = skip = !firsttime;
            while (this.mt <= this.mtend) {
                block11: {
                    if (!skip) {
                        try {
                            int blkalpha = model[this.modscale * this.modscale * this.my + this.modscale * this.mz + this.mx];
                            if (blkalpha > 0) {
                                this.subalpha = blkalpha;
                                return false;
                            }
                            break block11;
                        }
                        catch (ArrayIndexOutOfBoundsException aioobx) {
                            return true;
                        }
                    }
                    skip = false;
                }
                if (this.mt_next_x <= this.mt_next_y && this.mt_next_x <= this.mt_next_z) {
                    this.mx += this.x_inc;
                    this.mt = this.mt_next_x;
                    this.mt_next_x += this.mdt_dx;
                    this.laststep = this.stepx;
                    if (this.mx != this.mxout) continue;
                    return true;
                }
                if (this.mt_next_y <= this.mt_next_x && this.mt_next_y <= this.mt_next_z) {
                    this.my += this.y_inc;
                    this.mt = this.mt_next_y;
                    this.mt_next_y += this.mdt_dy;
                    this.laststep = this.stepy;
                    if (this.my != this.myout) continue;
                    return true;
                }
                this.mz += this.z_inc;
                this.mt = this.mt_next_z;
                this.mt_next_z += this.mdt_dz;
                this.laststep = this.stepz;
                if (this.mz != this.mzout) continue;
                return true;
            }
            return true;
        }

        public final int[] getSubblockCoord() {
            if (this.cur_patch >= 0) {
                double tt = this.cur_patch_t;
                double xx = this.top.x + tt * this.direction.x;
                double yy = this.top.y + tt * this.direction.y;
                double zz = this.top.z + tt * this.direction.z;
                this.subblock_xyz[0] = (int)((xx - (double)DynmapRenderer.fastFloor(xx)) * (double)this.modscale);
                this.subblock_xyz[1] = (int)((yy - (double)DynmapRenderer.fastFloor(yy)) * (double)this.modscale);
                this.subblock_xyz[2] = (int)((zz - (double)DynmapRenderer.fastFloor(zz)) * (double)this.modscale);
            } else if (this.subalpha < 0) {
                double tt = this.t + 1.0E-7;
                double xx = this.top.x + tt * this.direction.x;
                double yy = this.top.y + tt * this.direction.y;
                double zz = this.top.z + tt * this.direction.z;
                this.subblock_xyz[0] = (int)((xx - (double)DynmapRenderer.fastFloor(xx)) * (double)this.modscale);
                this.subblock_xyz[1] = (int)((yy - (double)DynmapRenderer.fastFloor(yy)) * (double)this.modscale);
                this.subblock_xyz[2] = (int)((zz - (double)DynmapRenderer.fastFloor(zz)) * (double)this.modscale);
            } else {
                this.subblock_xyz[0] = this.mx;
                this.subblock_xyz[1] = this.my;
                this.subblock_xyz[2] = this.mz;
            }
            return this.subblock_xyz;
        }

        public final boolean isOnFace() {
            double tt;
            if (this.cur_patch >= 0) {
                tt = this.cur_patch_t;
            } else if (this.subalpha < 0) {
                tt = this.t + 1.0E-7;
            } else {
                return true;
            }
            double xx = this.top.x + tt * this.direction.x;
            double yy = this.top.y + tt * this.direction.y;
            double zz = this.top.z + tt * this.direction.z;
            double xoff = xx - (double)DynmapRenderer.fastFloor(xx);
            double yoff = yy - (double)DynmapRenderer.fastFloor(yy);
            double zoff = zz - (double)DynmapRenderer.fastFloor(zz);
            return xoff < 1.0E-5 || xoff > 0.99999 || yoff < 1.0E-5 || yoff > 0.99999 || zoff < 1.0E-5 || zoff > 0.99999;
        }

        public int getTextureIndex() {
            return this.cur_patch;
        }

        public double getPatchU() {
            return this.cur_patch_u;
        }

        public double getPatchV() {
            return this.cur_patch_v;
        }

        public final boolean getShade() {
            return this.cur_shade || this.cur_patch < 0;
        }

        public final LightLevels getCachedLightLevels(int idx) {
            return this.llcache[idx];
        }

        public final RenderPatch[] getCustomMesh() {
            long key = this.mapiter.getBlockKey();
            return (RenderPatch[])this.custom_meshes.get(key);
        }

        public final RenderPatch[] getCustomMeshForState(DynmapBlockState bs) {
            return custom_meshes_by_globalstateindex[bs.globalStateIndex];
        }

        public final void setCustomMesh(RenderPatch[] mesh) {
            long key = this.mapiter.getBlockKey();
            this.custom_meshes.put(key, (Object)mesh);
        }

        public final void setCustomMeshForState(DynmapBlockState bs, RenderPatch[] mesh) {
            DynmapRenderer.custom_meshes_by_globalstateindex[bs.globalStateIndex] = mesh;
        }

        public final RenderPatch[] getCustomFluidMesh() {
            long key = this.mapiter.getBlockKey();
            return (RenderPatch[])this.custom_fluid_meshes.get(key);
        }

        public final void setCustomFluidMesh(RenderPatch[] mesh) {
            long key = this.mapiter.getBlockKey();
            this.custom_fluid_meshes.put(key, (Object)mesh);
        }
    }
}

