/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.vecmath.Point3i;
import org.pepsoft.util.Box;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.util.swing.ManagesScale;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.WPContext;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.dynmap.DynmapTileProvider;
import org.pepsoft.worldpainter.dynmap.WPObjectDynmapWorld;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.CustomObjectManager;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class DynmapPreviewer
extends TiledImageViewer
implements ManagesScale {
    private final Action zoomIn = new AbstractAction("Zoom In", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier_zoom_in.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            DynmapPreviewer.this.setZoom(DynmapPreviewer.this.getZoom() + 1);
            DynmapPreviewer.this.setActionStates();
        }
    };
    private final Action zoomOut = new AbstractAction("Zoom Out", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier_zoom_out.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DynmapPreviewer.this.getZoom() > -4) {
                DynmapPreviewer.this.setZoom(DynmapPreviewer.this.getZoom() - 1);
                DynmapPreviewer.this.setActionStates();
            }
        }
    };
    private final Action rotateLeft = new AbstractAction("Rotate Left", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_left.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            DynmapPreviewer.this.azimuth = MathUtils.mod((double)(DynmapPreviewer.this.azimuth - 15.0), (double)360.0);
            DynmapPreviewer.this.tileProvider.setAzimuth(DynmapPreviewer.this.azimuth);
            DynmapPreviewer.this.refresh(true);
        }
    };
    private final Action rotateRight = new AbstractAction("Rotate Right", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_right.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            DynmapPreviewer.this.azimuth = MathUtils.mod((double)(DynmapPreviewer.this.azimuth + 15.0), (double)360.0);
            DynmapPreviewer.this.tileProvider.setAzimuth(DynmapPreviewer.this.azimuth);
            DynmapPreviewer.this.refresh(true);
        }
    };
    private final Action rotateUp = new AbstractAction("Rotate Up", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_up.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            double oldInclination = DynmapPreviewer.this.inclination;
            DynmapPreviewer.this.inclination = Math.max(DynmapPreviewer.this.inclination - 15.0, 30.0);
            if (DynmapPreviewer.this.inclination != oldInclination) {
                DynmapPreviewer.this.setActionStates();
                DynmapPreviewer.this.tileProvider.setInclination(DynmapPreviewer.this.inclination);
                DynmapPreviewer.this.refresh(true);
            }
        }
    };
    private final Action rotateDown = new AbstractAction("Rotate Down", IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_down.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            double oldInclination = DynmapPreviewer.this.inclination;
            DynmapPreviewer.this.inclination = Math.min(DynmapPreviewer.this.inclination + 15.0, 90.0);
            if (DynmapPreviewer.this.inclination != oldInclination) {
                DynmapPreviewer.this.setActionStates();
                DynmapPreviewer.this.tileProvider.setInclination(DynmapPreviewer.this.inclination);
                DynmapPreviewer.this.refresh(true);
            }
        }
    };
    private final Action reset = new AbstractAction("Reset"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DynmapPreviewer.this.azimuth != DynmapPreviewer.this.initialAzimuth || DynmapPreviewer.this.inclination != DynmapPreviewer.this.initialInclination || DynmapPreviewer.this.getZoom() != DynmapPreviewer.this.initialZoom) {
                if (DynmapPreviewer.this.azimuth != DynmapPreviewer.this.initialAzimuth) {
                    DynmapPreviewer.this.azimuth = DynmapPreviewer.this.initialAzimuth;
                    DynmapPreviewer.this.tileProvider.setAzimuth(DynmapPreviewer.this.azimuth);
                }
                if (DynmapPreviewer.this.inclination != DynmapPreviewer.this.initialInclination) {
                    DynmapPreviewer.this.inclination = DynmapPreviewer.this.initialInclination;
                    DynmapPreviewer.this.tileProvider.setInclination(DynmapPreviewer.this.inclination);
                }
                if (DynmapPreviewer.this.getZoom() != DynmapPreviewer.this.initialZoom) {
                    DynmapPreviewer.this.setZoom(DynmapPreviewer.this.initialZoom);
                } else {
                    DynmapPreviewer.this.refresh(true);
                }
                DynmapPreviewer.this.setActionStates();
            }
        }
    };
    private final double initialAzimuth;
    private final double initialInclination;
    private final int initialZoom;
    private WPObject object;
    private DynmapTileProvider tileProvider;
    private double azimuth;
    private double inclination;
    private boolean caves;
    private static final Logger logger = LoggerFactory.getLogger(DynmapPreviewer.class);

    public DynmapPreviewer() {
        this(135.0, 60.0, 0);
    }

    public DynmapPreviewer(double myAzimuth, double myInclination, int myZoom) {
        super(true, false, 2);
        this.initialAzimuth = myAzimuth;
        this.initialInclination = myInclination;
        this.initialZoom = myZoom;
        this.azimuth = myAzimuth;
        this.inclination = myInclination;
        this.setZoom(myZoom);
        this.setFocusable(true);
        this.addMouseWheelListener(e -> {
            if (e.getScrollType() == 0) {
                int newZoom = this.getZoom() - e.getWheelRotation();
                this.setZoom(Math.max(newZoom, -4));
            }
        });
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "rotateLeft");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "rotateRight");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "rotateUp");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "rotateDown");
        inputMap.put(KeyStroke.getKeyStroke(65, 0), "rotateLeft");
        inputMap.put(KeyStroke.getKeyStroke(68, 0), "rotateRight");
        inputMap.put(KeyStroke.getKeyStroke(87, 0), "rotateUp");
        inputMap.put(KeyStroke.getKeyStroke(83, 0), "rotateDown");
        inputMap.put(KeyStroke.getKeyStroke('-'), "zoomOut");
        inputMap.put(KeyStroke.getKeyStroke('+'), "zoomIn");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "reset");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("rotateLeft", this.rotateLeft);
        actionMap.put("rotateRight", this.rotateRight);
        actionMap.put("rotateUp", this.rotateUp);
        actionMap.put("rotateDown", this.rotateDown);
        actionMap.put("zoomIn", this.zoomIn);
        actionMap.put("zoomOut", this.zoomOut);
        actionMap.put("reset", this.reset);
        this.setActionStates();
        JPanel buttonPanel = new JPanel(new GridLayout(2, 3, 2, 2));
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.createActionButton(this.rotateLeft));
        buttonPanel.add(this.createActionButton(this.rotateUp));
        buttonPanel.add(this.createActionButton(this.rotateRight));
        buttonPanel.add(this.createActionButton(this.zoomIn));
        buttonPanel.add(this.createActionButton(this.rotateDown));
        buttonPanel.add(this.createActionButton(this.zoomOut));
        buttonPanel.setSize(buttonPanel.getPreferredSize());
        buttonPanel.setLocation(4, 4);
        this.add(buttonPanel);
    }

    public WPObject getObject() {
        return this.object;
    }

    public void setObject(WPObject object, Dimension dimension) {
        this.object = object;
        this.setActionStates();
        if (object != null) {
            object.prepareForExport(dimension);
            WPObjectDynmapWorld dmWorld = new WPObjectDynmapWorld(object);
            this.tileProvider = new DynmapTileProvider(dmWorld);
            this.tileProvider.setAzimuth(this.azimuth);
            this.tileProvider.setInclination(this.inclination);
            this.tileProvider.setCaves(this.caves);
            this.setTileProvider(this.tileProvider);
        } else {
            this.tileProvider = null;
            if (this.getTileProviderCount() > 0) {
                this.removeAllTileProviders();
            }
        }
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
        this.setActionStates();
        if (this.tileProvider != null) {
            this.tileProvider.setAzimuth(azimuth);
        }
    }

    public double getInclination() {
        return this.inclination;
    }

    public void setInclination(double inclination) {
        this.inclination = inclination;
        this.setActionStates();
        if (this.tileProvider != null) {
            this.tileProvider.setInclination(inclination);
        }
    }

    public boolean isCaves() {
        return this.caves;
    }

    public void setCaves(boolean caves) {
        this.caves = caves;
        if (this.tileProvider != null) {
            this.tileProvider.setCaves(caves);
        }
    }

    public BufferedImage createImage() {
        Point3i offset = this.object.getOffset();
        Point3i dimensions = this.object.getDimensions();
        Rectangle tileCoords = this.tileProvider.getBounds(new Box(offset.x, offset.x + dimensions.x - 1, offset.y, offset.y + dimensions.y - 1, offset.z, offset.z + dimensions.z - 1));
        BufferedImage image = new BufferedImage(tileCoords.width * 128, tileCoords.height * 128, 2);
        for (int dx = 0; dx < tileCoords.width; ++dx) {
            for (int dy = 0; dy < tileCoords.height; ++dy) {
                this.tileProvider.paintTile(image, tileCoords.x + dx, tileCoords.y + dy, dx * 128, dy * 128);
            }
        }
        return image;
    }

    private JButton createActionButton(Action action) {
        JButton button = new JButton(action);
        button.setHideActionText(true);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private void setActionStates() {
        this.zoomIn.setEnabled(this.object != null);
        this.zoomOut.setEnabled(this.object != null && this.getZoom() > -4);
        this.rotateLeft.setEnabled(this.object != null);
        this.rotateRight.setEnabled(this.object != null);
        this.rotateUp.setEnabled(this.object != null && this.inclination > 30.0);
        this.rotateDown.setEnabled(this.object != null && this.inclination < 90.0);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Configuration config = Configuration.load();
        if (config == null) {
            if (!logger.isDebugEnabled()) {
                logger.info("Creating new configuration");
            }
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        logger.info("Installation ID: " + config.getUuid());
        X509Certificate trustedCert = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            trustedCert = (X509Certificate)certificateFactory.generateCertificate(DynmapPreviewer.class.getResourceAsStream("/wproot.pem"));
        }
        catch (CertificateException e) {
            logger.error("Certificate exception while loading trusted root certificate", (Throwable)e);
        }
        if (trustedCert != null) {
            PluginManager.loadPlugins((File)new File(Configuration.getConfigDir(), "plugins"), (PublicKey)trustedCert.getPublicKey(), (String)"org.pepsoft.worldpainter.plugins", (org.pepsoft.util.Version)Version.VERSION_OBJ, (boolean)false);
        } else {
            logger.error("Trusted root certificate not available; not loading plugins");
        }
        WPPluginManager.initialise((UUID)config.getUuid(), (WPContext)WPContext.INSTANCE);
        JFrame frame = new JFrame("DynMapPreviewerTest");
        frame.setDefaultCloseOperation(2);
        DynmapPreviewer viewer = new DynmapPreviewer();
        WPObject object = CustomObjectManager.getInstance().loadObject(new File(args[0]));
        HeightMapTileFactory tileFactory = TileFactoryFactory.createNoiseTileFactory((long)0L, (Terrain)Terrain.GRASS, (int)DefaultPlugin.JAVA_ANVIL_1_15.minZ, (int)DefaultPlugin.JAVA_ANVIL_1_15.standardMaxHeight, (int)58, (int)62, (boolean)false, (boolean)true, (float)20.0f, (double)1.0);
        Dimension dimension = new World2(DefaultPlugin.JAVA_ANVIL_1_15, 0L, (TileFactory)tileFactory).getDimension(Dimension.Anchor.NORMAL_DETAIL);
        viewer.setObject(object, dimension);
        frame.getContentPane().add((Component)((Object)viewer), "Center");
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

