/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;

public class TextProgressReceiver
implements ProgressReceiver {
    private boolean headerPrinted;
    private int previousProgress = -1;

    @Override
    public synchronized void setProgress(float progressFraction) {
        if (!this.headerPrinted) {
            System.out.println("+---------+---------+---------+---------+---------+");
            this.headerPrinted = true;
        }
        int progress = (int)(progressFraction * 50.0f);
        while (progress > this.previousProgress) {
            System.out.print('.');
            ++this.previousProgress;
        }
    }

    @Override
    public void exceptionThrown(Throwable exception) {
        exception.printStackTrace();
        System.exit(1);
    }

    @Override
    public synchronized void reset() {
        System.out.println();
        this.previousProgress = -1;
    }

    @Override
    public void done() {
    }

    @Override
    public void setMessage(String message) {
    }

    @Override
    public void checkForCancellation() {
    }

    @Override
    public void subProgressStarted(SubProgressReceiver subProgressReceiver) {
    }
}

