/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.pepsoft.util.PerlinNoise;

public class PerlinNoiseLevelFinder {
    private static final float[] levels = new float[10001];
    private static final CountDownLatch latch = new CountDownLatch(6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        new Thread("Thread 1"){

            @Override
            public void run() {
                PerlinNoiseLevelFinder.findLevels(0, 1250);
            }
        }.start();
        new Thread("Thread 2"){

            @Override
            public void run() {
                PerlinNoiseLevelFinder.findLevels(1250, 2500);
            }
        }.start();
        new Thread("Thread 3"){

            @Override
            public void run() {
                PerlinNoiseLevelFinder.findLevels(2500, 3750);
            }
        }.start();
        new Thread("Thread 4"){

            @Override
            public void run() {
                PerlinNoiseLevelFinder.findLevels(3750, 5000);
            }
        }.start();
        new Thread("Thread 5"){

            @Override
            public void run() {
                PerlinNoiseLevelFinder.findLevels(5000, 6250);
            }
        }.start();
        new Thread("Thread 6"){

            @Override
            public void run() {
                PerlinNoiseLevelFinder.findLevels(6250, 7500);
            }
        }.start();
        PerlinNoiseLevelFinder.findLevels(7500, 10001, false);
        latch.await();
        float[] fArray = levels;
        synchronized (levels) {
            System.out.print('{');
            for (int i = 0; i <= 10000; ++i) {
                System.out.print(levels[i]);
                System.out.print('f');
                if (i < 10000) {
                    System.out.print(", ");
                }
                if ((i + 1) % 10 != 0) continue;
                System.out.println();
            }
            System.out.print('}');
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void findLevels(int from, int to) {
        PerlinNoiseLevelFinder.findLevels(from, to, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void findLevels(int from, int to, boolean decrementLatch) {
        PerlinNoise perlinNoise = new PerlinNoise(0L);
        int i = from;
        while (true) {
            if (i >= to) {
                if (!decrementLatch) return;
                latch.countDown();
                return;
            }
            float target = (float)i / 10000.0f;
            float level = PerlinNoiseLevelFinder.findLevelForPromillage(perlinNoise, target);
            float[] fArray = levels;
            // MONITORENTER : levels
            PerlinNoiseLevelFinder.levels[i] = level;
            // MONITOREXIT : fArray
            ++i;
        }
    }

    private static float findLevelForPromillage(PerlinNoise perlinNoise, float target) {
        float level = 0.0f;
        float step = 0.25f;
        float previousLevel = 0.0f;
        float promillage = 0.0f;
        for (int i = 0; i < 100; ++i) {
            int hits = PerlinNoiseLevelFinder.numberOfHits(perlinNoise, level, 10000000);
            promillage = (float)hits / 1.0E7f;
            if (promillage > target) {
                if ((level += step) == previousLevel) {
                    System.out.println("Promillage at level " + level + ": " + promillage * 1000.0f);
                    return level;
                }
                previousLevel = level;
                step /= 2.0f;
                continue;
            }
            if (promillage < target) {
                if ((level -= step) == previousLevel) {
                    System.out.println("Promillage at level " + level + ": " + promillage * 1000.0f);
                    return level;
                }
                previousLevel = level;
                step /= 2.0f;
                continue;
            }
            System.out.println("Promillage at level " + level + ": " + promillage * 1000.0f);
            return level;
        }
        System.out.println("Promillage at level " + level + ": " + promillage * 1000.0f);
        return level;
    }

    private static int numberOfHits(PerlinNoise perlinNoise, float level, int count) {
        int hits = 0;
        Random random = new Random(0L);
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            double x = random.nextDouble() * 256.0;
            float noise = perlinNoise.getPerlinNoise(x, y = random.nextDouble() * 256.0, z = random.nextDouble() * 256.0);
            if (!(noise >= level)) continue;
            ++hits;
        }
        return hits;
    }
}

