/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelProgressManager {
    private final ReentrantLock progressLock = new ReentrantLock();
    private final ProgressReceiver progressReceiver;
    private final AtomicInteger taskCount = new AtomicInteger();
    private final AtomicInteger taskIncrementer = new AtomicInteger();
    private final AtomicLong taskProgress = new AtomicLong();
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private volatile boolean started;
    private AtomicLongArray taskProgresses;
    private volatile int[] taskDones;
    private final int taskLimit;
    private static final VarHandle INT_ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(int[].class);
    private static final Logger logger = LoggerFactory.getLogger(ParallelProgressManager.class);

    public ParallelProgressManager(ProgressReceiver progressReceiver) {
        this.progressReceiver = progressReceiver;
        this.taskLimit = -1;
    }

    public ParallelProgressManager(ProgressReceiver progressReceiver, int taskCount) {
        this.progressReceiver = progressReceiver;
        this.taskLimit = taskCount;
        this.startIfNot();
    }

    public ProgressReceiver createProgressReceiver() {
        int id;
        this.progressLock.lock();
        try {
            if (this.taskLimit == -1 && this.started) {
                throw new IllegalStateException("Cannot create new progress receivers after tasks have started");
            }
            id = this.taskIncrementer.getAndIncrement();
            if (id >= this.taskLimit) {
                throw new IllegalStateException("Attempt to create more sub progress receivers than indicated task count (" + this.taskLimit + ")");
            }
        }
        finally {
            this.progressLock.unlock();
        }
        this.taskCount.incrementAndGet();
        return new SubProgressReceiver(id);
    }

    public void join() throws InterruptedException {
        while (!this.started || this.getTaskCount() != 0) {
            Thread.sleep(100L);
        }
    }

    public boolean isExceptionThrown() {
        return this.exception.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProgress(int index, float subProgress) throws ProgressReceiver.OperationCancelled {
        block9: {
            long SCALE_FACTOR = 1000L;
            long thisVal = (long)(subProgress * 1000.0f);
            this.startIfNot();
            this.cancelIfPreviousException();
            long totalProgress = this.taskProgress.addAndGet(thisVal - this.taskProgresses.getAndSet(index, thisVal));
            float progress = (float)((double)totalProgress / (double)this.getTaskCount() / 1000.0);
            try {
                if (!this.progressLock.tryLock()) break block9;
                try {
                    this.progressReceiver.setProgress(progress);
                }
                finally {
                    this.progressLock.unlock();
                }
            }
            catch (ProgressReceiver.OperationCancelled e) {
                if (this.exception.getAndSet(e) == null) {
                    this.progressLock.lock();
                    try {
                        this.progressReceiver.exceptionThrown(e);
                    }
                    finally {
                        this.progressLock.unlock();
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exceptionThrown(int index, Throwable exception) {
        this.startIfNot();
        this.stopRunningIfNot(index);
        Throwable ex = this.exception.compareAndExchange(null, exception);
        if (ex == null) {
            this.progressLock.lock();
            try {
                this.progressReceiver.exceptionThrown(exception);
            }
            finally {
                this.progressLock.unlock();
            }
        } else if (ExceptionUtils.chainContains(exception, ProgressReceiver.OperationCancelledByUser.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Operation cancelled by user; not reporting to progress receiver");
            }
        } else if (ExceptionUtils.chainContains(exception, ProgressReceiver.OperationCancelled.class)) {
            logger.debug("Operation cancelled on thread {} (message: \"{}\")", (Object)Thread.currentThread().getName(), (Object)exception.getMessage());
        } else {
            logger.error("Secondary exception from parallel task; not reporting to progress receiver", exception);
        }
    }

    private void done(int index) {
        this.startIfNot();
        this.stopRunningIfNot(index);
        if (this.exception.get() == null && this.taskCount.compareAndExchange(0, Integer.MIN_VALUE) == 0) {
            this.progressLock.lock();
            try {
                this.progressReceiver.done();
            }
            finally {
                this.progressLock.unlock();
            }
        }
    }

    private void setMessage(int index, String message) throws ProgressReceiver.OperationCancelled {
        this.startIfNot();
        this.cancelIfPreviousException();
        this.progressLock.lock();
        try {
            this.progressReceiver.setMessage(message);
        }
        finally {
            this.progressLock.unlock();
        }
    }

    private void checkForCancellation() throws ProgressReceiver.OperationCancelled {
        this.startIfNot();
        this.cancelIfPreviousException();
    }

    private void subProgressStarted(org.pepsoft.util.SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
        this.startIfNot();
        this.cancelIfPreviousException();
        this.progressLock.lock();
        try {
            this.progressReceiver.subProgressStarted(subProgressReceiver);
        }
        finally {
            this.progressLock.unlock();
        }
    }

    private void startIfNot() {
        if (this.started) {
            return;
        }
        this.progressLock.lock();
        try {
            if (this.started) {
                return;
            }
            int taskCount = this.taskLimit;
            if (taskCount == -1) {
                taskCount = this.taskIncrementer.get();
            }
            this.taskProgresses = new AtomicLongArray(taskCount);
            this.taskDones = new int[(taskCount + 31) / 32];
            this.started = true;
        }
        finally {
            this.progressLock.unlock();
        }
    }

    private void cancelIfPreviousException() throws ProgressReceiver.OperationCancelled {
        Throwable ex = this.exception.get();
        if (ex != null) {
            throw new ProgressReceiver.OperationCancelled("Operation cancelled due to exception on other thread (type: " + ex.getClass().getSimpleName() + ", message: " + ex.getMessage() + ")", ex);
        }
    }

    private int getTaskCount() {
        return this.taskCount.get() & Integer.MAX_VALUE;
    }

    private void stopRunningIfNot(int index) {
        int msk = 1 << (index & 0x1F);
        if ((this.taskDones[index >> 5] & msk) != 0) {
            return;
        }
        if ((INT_ARRAY_HANDLE.getAndBitwiseOr(this.taskDones, index >> 5, msk) & msk) != 0) {
            return;
        }
        this.taskCount.decrementAndGet();
    }

    private class SubProgressReceiver
    implements ProgressReceiver {
        private final int index;

        private SubProgressReceiver(int index) {
            this.index = index;
        }

        @Override
        public void setProgress(float progress) throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.setProgress(this.index, progress);
        }

        @Override
        public void exceptionThrown(Throwable exception) {
            ParallelProgressManager.this.exceptionThrown(this.index, exception);
        }

        @Override
        public void done() {
            ParallelProgressManager.this.done(this.index);
        }

        @Override
        public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.setMessage(this.index, message);
        }

        @Override
        public void checkForCancellation() throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.checkForCancellation();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void subProgressStarted(org.pepsoft.util.SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.subProgressStarted(subProgressReceiver);
        }
    }
}

