/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

public class MemoryUtils {
    private static final Map<Class<?>, Long> PRIMITIVE_TYPE_SIZES = new HashMap();

    public static long getSize(Object object, Set<Class<?>> stopAt) {
        if (object == null) {
            return 0L;
        }
        if (SystemUtils.JAVA_VERSION.isAtLeast(SystemUtils.JAVA_9)) {
            return -1L;
        }
        IdentityHashMap<Object, Void> processedObjects = new IdentityHashMap<Object, Void>();
        return MemoryUtils.getSize(object, processedObjects, stopAt);
    }

    private static long getSize(Object object, IdentityHashMap<Object, Void> processedObjects, Set<Class<?>> stopAt) {
        if (processedObjects.containsKey(object)) {
            return 0L;
        }
        processedObjects.put(object, null);
        Class<?> type = object.getClass();
        if (stopAt != null && !stopAt.isEmpty()) {
            for (Class<?> stopClass : stopAt) {
                if (!stopClass.isAssignableFrom(type)) continue;
                return 0L;
            }
        }
        long objectSize = 8L;
        if (type.isArray()) {
            objectSize += 4L;
            Class<?> arrayType = type.getComponentType();
            if (arrayType.isPrimitive()) {
                objectSize = arrayType == Boolean.TYPE ? (objectSize += (long)((boolean[])object).length) : (arrayType == Byte.TYPE ? (objectSize += (long)((byte[])object).length) : (arrayType == Character.TYPE ? (objectSize += (long)((char[])object).length * 2L) : (arrayType == Short.TYPE ? (objectSize += (long)((short[])object).length * 2L) : (arrayType == Integer.TYPE ? (objectSize += (long)((int[])object).length * 4L) : (arrayType == Float.TYPE ? (objectSize += (long)((float[])object).length * 4L) : (arrayType == Long.TYPE ? (objectSize += (long)((long[])object).length * 8L) : (objectSize += (long)((double[])object).length * 8L)))))));
            } else {
                Object[] array = (Object[])object;
                objectSize = (long)array.length * 4L;
                for (Object anArray : array) {
                    if (anArray == null) continue;
                    objectSize += MemoryUtils.getSize(anArray, processedObjects, stopAt);
                }
            }
        } else if (type.isPrimitive()) {
            objectSize += PRIMITIVE_TYPE_SIZES.get(type).longValue();
        } else {
            for (Class<?> myType = type; myType != null; myType = myType.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = myType.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    Class<?> fieldType = field.getType();
                    if (fieldType.isPrimitive()) {
                        objectSize += PRIMITIVE_TYPE_SIZES.get(fieldType).longValue();
                        continue;
                    }
                    objectSize += 4L;
                    field.setAccessible(true);
                    try {
                        Object value = field.get(object);
                        if (value == null) continue;
                        objectSize += MemoryUtils.getSize(value, processedObjects, stopAt);
                    }
                    catch (IllegalAccessException e) {
                        throw new MDCCapturingRuntimeException("Access denied trying to read field " + field.getName() + " of type " + myType.getName(), e);
                    }
                }
            }
        }
        if (objectSize % 8L != 0L) {
            objectSize = (objectSize >> 3) + 1L << 3;
        }
        return objectSize;
    }

    static {
        PRIMITIVE_TYPE_SIZES.put(Boolean.TYPE, 1L);
        PRIMITIVE_TYPE_SIZES.put(Byte.TYPE, 1L);
        PRIMITIVE_TYPE_SIZES.put(Character.TYPE, 2L);
        PRIMITIVE_TYPE_SIZES.put(Short.TYPE, 2L);
        PRIMITIVE_TYPE_SIZES.put(Integer.TYPE, 4L);
        PRIMITIVE_TYPE_SIZES.put(Float.TYPE, 4L);
        PRIMITIVE_TYPE_SIZES.put(Long.TYPE, 8L);
        PRIMITIVE_TYPE_SIZES.put(Double.TYPE, 8L);
    }
}

