/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.DataInput;
import java.io.IOException;
import java.util.BitSet;

public final class DataUtils {
    private static final long MAX_UINT_32 = 0x100000000L;

    private DataUtils() {
    }

    public static long readUnsignedInt(DataInput in) throws IOException {
        int _int = in.readInt();
        return _int < 0 ? 0x100000000L + (long)_int : (long)_int;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[][] unpackDataArray(Object data, int wordSize, int columnCount) {
        int lengthInWords;
        BitSet bitSet;
        if (data instanceof byte[]) {
            bitSet = BitSet.valueOf((byte[])data);
            lengthInWords = ((byte[])data).length * 8 / wordSize;
        } else if (data instanceof long[]) {
            bitSet = BitSet.valueOf((long[])data);
            lengthInWords = ((long[])data).length * 64 / wordSize;
        } else {
            if (!(data instanceof int[])) throw new IllegalArgumentException("Don't know how to process data of type " + data.getClass());
            int[] dataAsInts = (int[])data;
            if (dataAsInts.length % 2 != 0) throw new IllegalArgumentException("Don't know how to process data of type int[] and odd length");
            long[] dataAsLongs = new long[dataAsInts.length / 2];
            for (int i = 0; i < dataAsLongs.length; ++i) {
                dataAsLongs[i] = (long)dataAsInts[i * 2] & 0xFFFFFFFFL | (long)dataAsInts[i * 2 + 1] << 32;
            }
            bitSet = BitSet.valueOf(dataAsLongs);
            lengthInWords = dataAsLongs.length * 64 / wordSize;
        }
        int rowCount = (int)Math.ceil((double)lengthInWords / (double)columnCount);
        long[][] matrix = new long[rowCount][];
        for (int row = 0; row < rowCount; ++row) {
            matrix[row] = new long[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                int wordOffset = column * wordSize;
                long word = 0L;
                for (int b = 0; b < wordSize; ++b) {
                    word |= bitSet.get(wordOffset + b) ? 1L << b : 0L;
                }
                matrix[row][column] = word;
            }
        }
        return matrix;
    }
}

