/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPCustomObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private final Set<Class<?>> patchClasses;
    private static final Logger logger = LoggerFactory.getLogger(WPCustomObjectInputStream.class);

    public WPCustomObjectInputStream(InputStream in, ClassLoader classLoader, Class<?> ... patchClasses) throws IOException {
        super(in);
        this.classLoader = classLoader;
        this.patchClasses = new HashSet(Arrays.asList(patchClasses));
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        Class<?> localClass = this.resolveClass(resultClassDescriptor);
        if (this.patchClasses.contains(localClass)) {
            ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
            if (localClassDescriptor != null) {
                long localSUID = localClassDescriptor.getSerialVersionUID();
                long streamSUID = resultClassDescriptor.getSerialVersionUID();
                if (streamSUID != localSUID) {
                    logger.warn("Overriding serialized class version mismatch: local serialVersionUID = " + localSUID + " stream serialVersionUID = " + streamSUID);
                    resultClassDescriptor = localClassDescriptor;
                }
            }
        } else if (localClass == null) {
            logger.warn("No local class for " + resultClassDescriptor.getName());
        }
        return resultClassDescriptor;
    }
}

