/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

public final class ColourUtils {
    private ColourUtils() {
    }

    public static int mix(int colour1, int colour2) {
        int red = ((colour1 & 0xFF0000) >> 17) + ((colour2 & 0xFF0000) >> 17);
        int green = ((colour1 & 0xFF00) >> 9) + ((colour2 & 0xFF00) >> 9);
        int blue = ((colour1 & 0xFF) >> 1) + ((colour2 & 0xFF) >> 1);
        return red << 16 | green << 8 | blue;
    }

    public static int mix(int colour1, int colour2, int alpha) {
        int red1 = (colour1 & 0xFF0000) >> 16;
        int green1 = (colour1 & 0xFF00) >> 8;
        int blue1 = colour1 & 0xFF;
        int red2 = (colour2 & 0xFF0000) >> 16;
        int green2 = (colour2 & 0xFF00) >> 8;
        int blue2 = colour2 & 0xFF;
        int red = (red1 * alpha + red2 * (255 - alpha)) / 255;
        int green = (green1 * alpha + green2 * (255 - alpha)) / 255;
        int blue = (blue1 * alpha + blue2 * (255 - alpha)) / 255;
        return red << 16 | green << 8 | blue;
    }

    public static int multiply(int colour, int amount) {
        if (amount == 256) {
            return colour;
        }
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        if ((red *= amount) > 65535) {
            red = 65535;
        }
        if ((green *= amount) > 65535) {
            green = 65535;
        }
        if ((blue *= amount) > 65535) {
            blue = 65535;
        }
        return red << 8 & 0xFF0000 | green & 0xFF00 | blue >> 8 & 0xFF;
    }

    public static boolean isGreyScale(int colour) {
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        return red == green && red == blue;
    }
}

