/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static BitSet bitSetOf(int ... values) {
        BitSet bitSet = new BitSet(values[values.length - 1] + 1);
        for (int value : values) {
            bitSet.set(value);
        }
        return bitSet;
    }

    @SafeVarargs
    public static <T> List<T> listOf(final List<? extends T> ... lists) {
        final int[] cumulativeSizes = new int[lists.length];
        int runningTotal = 0;
        for (int i = 0; i < lists.length; ++i) {
            cumulativeSizes[i] = runningTotal += lists[i].size();
        }
        final int totalSize = runningTotal;
        abstract class AbstractRandomAccessList<E>
        extends AbstractList<E>
        implements RandomAccess {
            AbstractRandomAccessList() {
            }
        }
        return new AbstractRandomAccessList<T>(){
            {
            }

            @Override
            public int size() {
                return totalSize;
            }

            @Override
            public T get(int index) {
                if (index < cumulativeSizes[0]) {
                    return lists[0].get(index);
                }
                for (int i = 1; i < cumulativeSizes.length; ++i) {
                    if (index >= cumulativeSizes[i]) continue;
                    return lists[i].get(index - cumulativeSizes[i - 1]);
                }
                throw new IndexOutOfBoundsException();
            }
        };
    }

    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        int valuesLength = values.length;
        for (int i = 0; i < valuesLength; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static int unsignedMax(short[] values) {
        int max = Integer.MIN_VALUE;
        int valuesLength = values.length;
        for (int i = 0; i < valuesLength; ++i) {
            if ((values[i] & 0xFFFF) <= max) continue;
            max = values[i] & 0xFFFF;
        }
        return max;
    }

    public static int unsignedMax(byte[] values) {
        int max = Integer.MIN_VALUE;
        int valuesLength = values.length;
        for (int i = 0; i < valuesLength; ++i) {
            if ((values[i] & 0xFF) <= max) continue;
            max = values[i] & 0xFF;
        }
        return max;
    }

    public static <T> List<T> nullAnd(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection.size() + 1);
        list.add(null);
        list.addAll(collection);
        return list;
    }

    public static <E> ArrayList<E> copyOf(List<E> list) {
        return list != null ? new ArrayList<E>(list) : null;
    }

    public static <E> HashSet<E> copyOf(Set<E> set) {
        return set != null ? new HashSet<E>(set) : null;
    }

    public static <K, V> HashMap<K, V> copyOf(Map<K, V> map) {
        return map != null ? new HashMap<K, V>(map) : null;
    }
}

