/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.concurrent.Callable;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.swing.ProgressComponent;
import org.pepsoft.util.swing.ProgressTask;

public class ProgressDialog<T>
extends JDialog
implements ComponentListener,
ProgressComponent.Listener<T> {
    private ProgressComponent<T> progressComponent1;
    private boolean cancelled;
    private Throwable exception;
    private T result;
    private static final long serialVersionUID = 2011101701L;
    public static final Option NOT_CANCELABLE = new Option(){

        @Override
        void apply(ProgressDialog<?> dialog) {
            dialog.progressComponent1.setCancelable(false);
        }
    };
    public static final Option NO_FOCUS_STEALING = new Option(){

        @Override
        void apply(ProgressDialog<?> dialog) {
            dialog.setAutoRequestFocus(false);
        }
    };

    public ProgressDialog(Window parent, ProgressTask<T> task, Option ... options) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setTitle(task.getName());
        this.progressComponent1.setListener(this);
        this.progressComponent1.setTask(task);
        if (options != null) {
            for (Option option : options) {
                option.apply(this);
            }
        }
        this.setLocationRelativeTo(parent);
        this.addComponentListener(this);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public static <T> T executeTask(Window parent, ProgressTask<T> task, Option ... options) {
        ProgressDialog<T> dialog = new ProgressDialog<T>(parent, task, options);
        dialog.setVisible(true);
        if (dialog.cancelled) {
            return null;
        }
        if (dialog.exception != null) {
            if (dialog.exception instanceof Error) {
                throw (Error)dialog.exception;
            }
            if (dialog.exception instanceof RuntimeException) {
                throw (RuntimeException)dialog.exception;
            }
            throw new MDCCapturingRuntimeException("Checked exception thrown by task", dialog.exception);
        }
        return dialog.result;
    }

    public static <T> T executeTask(Window parent, final String name, final Callable<T> task, Option ... options) {
        return ProgressDialog.executeTask(parent, new ProgressTask<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public T execute(ProgressReceiver progressReceiver) {
                try {
                    return task.call();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MDCCapturingRuntimeException(e.getClass().getSimpleName() + " while performing task \"" + name + "\" (message: " + e.getMessage() + ")", (Throwable)e);
                }
            }
        }, options);
    }

    @Override
    public synchronized void componentShown(ComponentEvent e) {
        this.progressComponent1.start();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void exceptionThrown(Throwable exception) {
        this.exception = exception;
        this.dispose();
    }

    @Override
    public void done(T result) {
        this.result = result;
        this.dispose();
    }

    @Override
    public void cancelled() {
        this.cancelled = true;
        this.dispose();
    }

    private void initComponents() {
        this.progressComponent1 = new ProgressComponent();
        this.setDefaultCloseOperation(0);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.progressComponent1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.progressComponent1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static abstract class Option {
        abstract void apply(ProgressDialog<?> var1);
    }
}

