/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class BetterAction
extends AbstractAction {
    public BetterAction(String name, Icon icon) {
        super(name, icon);
    }

    public BetterAction(String name) {
        super(name);
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    public final void setShortDescription(String shortDescription) {
        StringBuilder sb = new StringBuilder();
        sb.append(shortDescription);
        KeyStroke accelerator = (KeyStroke)this.getValue("AcceleratorKey");
        if (accelerator != null) {
            int keyCode;
            sb.append(" (");
            if ((accelerator.getModifiers() & 0x80) != 0) {
                sb.append("Ctrl+");
            }
            if ((accelerator.getModifiers() & 0x100) != 0) {
                sb.append("\u2318+");
            }
            if ((accelerator.getModifiers() & 0x200) != 0) {
                sb.append("Alt+");
            }
            if ((accelerator.getModifiers() & 0x2000) != 0) {
                sb.append("AltGr+");
            }
            if ((accelerator.getModifiers() & 0x40) != 0) {
                sb.append("Shift+");
            }
            if ((keyCode = accelerator.getKeyCode()) == 107) {
                sb.append('+');
            } else if (keyCode == 109) {
                sb.append('-');
            } else {
                sb.append((char)keyCode);
            }
            sb.append(')');
        }
        this.putValue("ShortDescription", sb.toString());
    }

    public final void setAcceleratorKey(KeyStroke acceleratorKey) {
        this.putValue("AcceleratorKey", acceleratorKey);
    }

    public final KeyStroke getAcceleratorKey() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public final void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public final boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }
}

