/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Desktop;
import java.io.File;
import java.util.List;
import org.pepsoft.util.AwtUtils;

public class MacUtils {
    private MacUtils() {
    }

    public static boolean installQuitHandler(QuitHandler quitHandler) {
        Desktop.getDesktop().setQuitHandler((quitEvent, quitResponse) -> {
            boolean shouldQuit = AwtUtils.resultOfOnEventThread(quitHandler::quitRequested);
            if (shouldQuit) {
                quitResponse.performQuit();
            } else {
                quitResponse.cancelQuit();
            }
        });
        return true;
    }

    public static boolean installAboutHandler(AboutHandler aboutHandler) {
        Desktop.getDesktop().setAboutHandler(aboutEvent -> AwtUtils.doLaterOnEventThread(aboutHandler::aboutRequested));
        return true;
    }

    public static boolean installOpenFilesHandler(OpenFilesHandler openFilesHandler) {
        Desktop.getDesktop().setOpenFileHandler(openFilesEvent -> {
            List<File> files = openFilesEvent.getFiles();
            AwtUtils.doLaterOnEventThread(() -> openFilesHandler.filesOpened(files));
        });
        return true;
    }

    public static boolean installPreferencesHandler(PreferencesHandler preferencesHandler) {
        Desktop.getDesktop().setPreferencesHandler(preferencesEvent -> AwtUtils.doLaterOnEventThread(preferencesHandler::preferencesRequested));
        return true;
    }

    public static interface QuitHandler {
        public boolean quitRequested();
    }

    public static interface AboutHandler {
        public void aboutRequested();
    }

    public static interface OpenFilesHandler {
        public void filesOpened(List<File> var1);
    }

    public static interface PreferencesHandler {
        public void preferencesRequested();
    }
}

