/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

public class AwtUtils {
    private static final Map<String, Timer> TIMERS = new HashMap<String, Timer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T resultOfOnEventThread(Callable<T> task) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return task.call();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MDCCapturingRuntimeException(e.getClass().getSimpleName() + " thrown by task", (Throwable)e);
            }
        }
        Object[] result = new Object[1];
        Exception[] exception = new Exception[1];
        try {
            SwingUtilities.invokeAndWait(() -> {
                try {
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = task.call();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
                catch (Exception e) {
                    Exception[] exceptionArray = exception;
                    synchronized (exception) {
                        exception[0] = e;
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new MDCCapturingRuntimeException("Thread interrupted while waiting for task to execute on event dispatch thread", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            throw new MDCCapturingRuntimeException(cause.getClass().getSimpleName() + " thrown by task on event dispatch thread", cause);
        }
        Object[] objectArray = exception;
        synchronized (exception) {
            if (exception[0] != null) {
                throw new MDCCapturingRuntimeException(exception[0].getClass().getSimpleName() + " thrown by task on event dispatch thread", (Throwable)exception[0]);
            }
            // ** MonitorExit[var3_6] (shouldn't be in output)
            objectArray = result;
            synchronized (result) {
                // ** MonitorExit[var3_6] (shouldn't be in output)
                return (T)result[0];
            }
        }
    }

    public static void doOnEventThread(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    public static void doOnEventThreadAndWait(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException e) {
                throw new MDCCapturingRuntimeException("Thread interrupted while waiting for task to execute on event dispatch thread", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                throw new MDCCapturingRuntimeException(cause.getClass().getSimpleName() + " thrown by task on event dispatch thread", cause);
            }
        }
    }

    public static void doLaterOnEventThread(Runnable task) {
        SwingUtilities.invokeLater(task);
    }

    public static void doLaterOnEventThread(String key, int delay, Runnable task) {
        AwtUtils.doOnEventThreadAndWait(() -> {
            if (TIMERS.containsKey(key)) {
                TIMERS.get(key).stop();
                TIMERS.remove(key);
            }
            Timer timer = new Timer(delay, e -> {
                task.run();
                TIMERS.remove(key);
            });
            timer.setRepeats(false);
            TIMERS.put(key, timer);
            timer.start();
        });
    }
}

