/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.profile.HttpTGTProfile;
import org.pac4j.cas.util.HttpUtils;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.Authenticator;

public class CasRestAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    private final String casServerPrefixUrl;
    private final String casRestUrl;
    private TicketValidator ticketValidator;

    public CasRestAuthenticator(String casServerPrefixUrl) {
        this(casServerPrefixUrl, CasRestAuthenticator.buildCasRestUrlFromCasServerPrefixUrl(casServerPrefixUrl));
    }

    private static String buildCasRestUrlFromCasServerPrefixUrl(String casServerPrefixUrl) {
        String restUrl = casServerPrefixUrl;
        if (!restUrl.endsWith("/")) {
            restUrl = restUrl + "/";
        }
        restUrl = restUrl + "v1/tickets";
        return restUrl;
    }

    public CasRestAuthenticator(String casServerPrefixUrl, String casRestUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
        this.casRestUrl = casRestUrl;
        if (this.ticketValidator == null) {
            this.ticketValidator = new Cas20ServiceTicketValidator(this.getCasServerPrefixUrl());
        }
    }

    public void validate(UsernamePasswordCredentials credentials) {
        if (credentials == null || credentials.getPassword() == null || credentials.getUsername() == null) {
            throw new TechnicalException("Credentials are required");
        }
        String ticketGrantingTicketId = this.requestTicketGrantingTicket(credentials.getUsername(), credentials.getPassword());
        HttpTGTProfile profile = new HttpTGTProfile(ticketGrantingTicketId, credentials.getUsername());
        credentials.setUserProfile((UserProfile)profile);
    }

    private String requestTicketGrantingTicket(String username, String password) {
        int responseCode;
        String locationHeader;
        HttpURLConnection connection;
        block5: {
            connection = null;
            connection = HttpUtils.openPostConnection(new URL(this.getCasRestUrl()));
            String payload = HttpUtils.encodeQueryParam("username", username) + "&" + HttpUtils.encodeQueryParam("password", password);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            out.write(payload);
            out.close();
            locationHeader = connection.getHeaderField("location");
            responseCode = connection.getResponseCode();
            if (locationHeader == null || responseCode != 201) break block5;
            String string = locationHeader.substring(locationHeader.lastIndexOf("/") + 1);
            HttpUtils.closeConnection(connection);
            return string;
        }
        try {
            try {
                throw new TechnicalException("Ticket granting ticket request failed: " + locationHeader + " " + responseCode + HttpUtils.buildHttpErrorMessage(connection));
            }
            catch (IOException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            HttpUtils.closeConnection(connection);
            throw throwable;
        }
    }

    public String getCasServerPrefixUrl() {
        return this.casServerPrefixUrl;
    }

    public String getCasRestUrl() {
        return this.casRestUrl;
    }

    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }
}

