/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import java.util.Timer;
import java.util.TimerTask;
import org.jasig.cas.client.proxy.CleanUpTimerTask;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.credentials.CasCredentials;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CasProxyReceptor
extends IndirectClient<CasCredentials, CasProfile> {
    private static final Logger logger = LoggerFactory.getLogger(CasProxyReceptor.class);
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();
    public static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    public static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";
    private int millisBetweenCleanUps = 60000;
    private Timer timer;
    private TimerTask timerTask;

    protected IndirectClient<CasCredentials, CasProfile> newClient() {
        CasProxyReceptor casProxyReceptor = new CasProxyReceptor();
        casProxyReceptor.setCallbackUrl(this.callbackUrl);
        casProxyReceptor.setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
        casProxyReceptor.setMillisBetweenCleanUps(this.millisBetweenCleanUps);
        return casProxyReceptor;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        CommonHelper.assertNotNull((String)"proxyGrantingTicketStorage", (Object)this.proxyGrantingTicketStorage);
        if (this.millisBetweenCleanUps > 0) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            if (this.timerTask == null) {
                this.timerTask = new CleanUpTimerTask(this.proxyGrantingTicketStorage);
            }
            this.timer.schedule(this.timerTask, this.millisBetweenCleanUps, (long)this.millisBetweenCleanUps);
        }
    }

    protected CasCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        String proxyGrantingTicketIou = context.getRequestParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
        logger.debug("proxyGrantingTicketIou : {}", (Object)proxyGrantingTicketIou);
        String proxyGrantingTicket = context.getRequestParameter(PARAM_PROXY_GRANTING_TICKET);
        logger.debug("proxyGrantingTicket : {}", (Object)proxyGrantingTicket);
        if (CommonUtils.isBlank((String)proxyGrantingTicket) || CommonUtils.isBlank((String)proxyGrantingTicketIou)) {
            context.writeResponseContent("");
            String message = "Missing proxyGrantingTicket or proxyGrantingTicketIou";
            throw RequiresHttpAction.ok((String)"Missing proxyGrantingTicket or proxyGrantingTicketIou", (WebContext)context);
        }
        this.proxyGrantingTicketStorage.save(proxyGrantingTicketIou, proxyGrantingTicket);
        context.writeResponseContent("<?xml version=\"1.0\"?>");
        context.writeResponseContent("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
        String message = "No credential for CAS proxy receptor -> returns ok";
        logger.debug("No credential for CAS proxy receptor -> returns ok");
        throw RequiresHttpAction.ok((String)"No credential for CAS proxy receptor -> returns ok", (WebContext)context);
    }

    public ProxyGrantingTicketStorage getProxyGrantingTicketStorage() {
        return this.proxyGrantingTicketStorage;
    }

    public void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage proxyGrantingTicketStorage) {
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
    }

    public int getMillisBetweenCleanUps() {
        return this.millisBetweenCleanUps;
    }

    public void setMillisBetweenCleanUps(int millisBetweenCleanUps) {
        this.millisBetweenCleanUps = millisBetweenCleanUps;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "proxyGrantingTicketStorage", this.proxyGrantingTicketStorage, "millisBetweenCleanUps", this.millisBetweenCleanUps});
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        throw new TechnicalException("Not supported by the CAS proxy receptor");
    }

    protected CasProfile retrieveUserProfile(CasCredentials credentials, WebContext context) {
        throw new TechnicalException("Not supported by the CAS proxy receptor");
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    public ClientType getClientType() {
        return ClientType.CAS_PROTOCOL;
    }
}

