/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas10TicketValidator;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.credentials.CasCredentials;
import org.pac4j.cas.logout.CasSingleSignOutHandler;
import org.pac4j.cas.logout.LogoutHandler;
import org.pac4j.cas.logout.NoLogoutHandler;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.cas.profile.CasProxyProfile;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasClient
extends IndirectClient<CasCredentials, CasProfile> {
    protected static final Logger logger = LoggerFactory.getLogger(CasClient.class);
    protected static final String SERVICE_PARAMETER = "service";
    public static final String SERVICE_TICKET_PARAMETER = "ticket";
    protected LogoutHandler logoutHandler;
    protected TicketValidator ticketValidator;
    protected String encoding = "UTF-8";
    protected String casLoginUrl;
    protected String casPrefixUrl;
    protected long timeTolerance = 1000L;
    protected CasProtocol casProtocol = CasProtocol.CAS30;
    protected boolean renew = false;
    protected boolean gateway = false;
    protected boolean acceptAnyProxy = false;
    protected ProxyList allowedProxyChains = new ProxyList();
    protected CasProxyReceptor casProxyReceptor;

    public CasClient() {
    }

    public CasClient(String casLoginUrl) {
        this.casLoginUrl = casLoginUrl;
    }

    public CasClient(String casLoginUrl, CasProtocol casProtocol) {
        this.casLoginUrl = casLoginUrl;
        this.casProtocol = casProtocol;
    }

    public CasClient(String casLoginUrl, String casPrefixUrl) {
        this.casLoginUrl = casLoginUrl;
        this.casPrefixUrl = casPrefixUrl;
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        String redirectionUrl = CommonUtils.constructRedirectUrl((String)this.casLoginUrl, (String)SERVICE_PARAMETER, (String)this.computeFinalCallbackUrl(context), (boolean)this.renew, (boolean)this.gateway);
        logger.debug("redirectionUrl : {}", (Object)redirectionUrl);
        return RedirectAction.redirect((String)redirectionUrl);
    }

    protected IndirectClient<CasCredentials, CasProfile> newClient() {
        CasClient casClient = new CasClient();
        casClient.setCallbackUrl(this.callbackUrl);
        casClient.setCasLoginUrl(this.casLoginUrl);
        casClient.setCasPrefixUrl(this.casPrefixUrl);
        casClient.setCasProtocol(this.casProtocol);
        casClient.setRenew(this.renew);
        casClient.setGateway(this.gateway);
        casClient.setAcceptAnyProxy(this.acceptAnyProxy);
        casClient.setAllowedProxyChains(this.allowedProxyChains);
        casClient.setCasProxyReceptor(this.casProxyReceptor);
        return casClient;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        if (CommonHelper.isBlank((String)this.casLoginUrl) && CommonHelper.isBlank((String)this.casPrefixUrl)) {
            throw new TechnicalException("casLoginUrl and casPrefixUrl cannot be both blank");
        }
        this.initializeClientConfiguration(context);
        this.initializeLogoutHandler(context);
        if (this.casProtocol == CasProtocol.CAS10) {
            this.initializeCas10Protocol();
        } else if (this.casProtocol == CasProtocol.CAS20) {
            this.initializeCas20Protocol(context);
        } else if (this.casProtocol == CasProtocol.CAS20_PROXY) {
            this.initializeCas20ProxyProtocol(context);
        } else if (this.casProtocol == CasProtocol.CAS30) {
            this.initializeCas30Protocol(context);
        } else if (this.casProtocol == CasProtocol.CAS30_PROXY) {
            this.initializeCas30ProxyProtocol(context);
        } else if (this.casProtocol == CasProtocol.SAML) {
            this.initializeSAMLProtocol();
        }
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    private void initializeLogoutHandler(WebContext context) {
        if (this.logoutHandler == null) {
            this.logoutHandler = context instanceof J2EContext ? new CasSingleSignOutHandler() : new NoLogoutHandler();
        }
    }

    protected void initializeSAMLProtocol() {
        Saml11TicketValidator saml11TicketValidator = new Saml11TicketValidator(this.casPrefixUrl);
        saml11TicketValidator.setTolerance(this.getTimeTolerance());
        saml11TicketValidator.setEncoding(this.encoding);
        this.ticketValidator = saml11TicketValidator;
    }

    protected void initializeCas30ProxyProtocol(WebContext context) {
        this.ticketValidator = new Cas30ProxyTicketValidator(this.casPrefixUrl);
        Cas30ProxyTicketValidator cas30ProxyTicketValidator = (Cas30ProxyTicketValidator)this.ticketValidator;
        cas30ProxyTicketValidator.setEncoding(this.encoding);
        cas30ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas30ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.casProxyReceptor != null) {
            cas30ProxyTicketValidator.setProxyCallbackUrl(this.casProxyReceptor.computeFinalCallbackUrl(context));
            cas30ProxyTicketValidator.setProxyGrantingTicketStorage(this.casProxyReceptor.getProxyGrantingTicketStorage());
        }
    }

    protected void initializeCas30Protocol(WebContext context) {
        this.ticketValidator = new Cas30ServiceTicketValidator(this.casPrefixUrl);
        Cas30ServiceTicketValidator cas30ServiceTicketValidator = (Cas30ServiceTicketValidator)this.ticketValidator;
        cas30ServiceTicketValidator.setEncoding(this.encoding);
        if (this.casProxyReceptor != null) {
            cas30ServiceTicketValidator.setProxyCallbackUrl(this.casProxyReceptor.computeFinalCallbackUrl(context));
            cas30ServiceTicketValidator.setProxyGrantingTicketStorage(this.casProxyReceptor.getProxyGrantingTicketStorage());
        }
    }

    protected void initializeCas20ProxyProtocol(WebContext context) {
        this.ticketValidator = new Cas20ProxyTicketValidator(this.casPrefixUrl);
        Cas20ProxyTicketValidator cas20ProxyTicketValidator = (Cas20ProxyTicketValidator)this.ticketValidator;
        cas20ProxyTicketValidator.setEncoding(this.encoding);
        cas20ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas20ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.casProxyReceptor != null) {
            cas20ProxyTicketValidator.setProxyCallbackUrl(this.casProxyReceptor.computeFinalCallbackUrl(context));
            cas20ProxyTicketValidator.setProxyGrantingTicketStorage(this.casProxyReceptor.getProxyGrantingTicketStorage());
        }
    }

    protected void initializeCas20Protocol(WebContext context) {
        this.ticketValidator = new Cas20ServiceTicketValidator(this.casPrefixUrl);
        Cas20ServiceTicketValidator cas20ServiceTicketValidator = (Cas20ServiceTicketValidator)this.ticketValidator;
        cas20ServiceTicketValidator.setEncoding(this.encoding);
        if (this.casProxyReceptor != null) {
            cas20ServiceTicketValidator.setProxyCallbackUrl(this.casProxyReceptor.computeFinalCallbackUrl(context));
            cas20ServiceTicketValidator.setProxyGrantingTicketStorage(this.casProxyReceptor.getProxyGrantingTicketStorage());
        }
    }

    protected void initializeCas10Protocol() {
        this.ticketValidator = new Cas10TicketValidator(this.casPrefixUrl);
        Cas10TicketValidator cas10TicketValidator = (Cas10TicketValidator)this.ticketValidator;
        cas10TicketValidator.setEncoding(this.encoding);
    }

    protected void initializeClientConfiguration(WebContext context) {
        if (this.casPrefixUrl != null && !this.casPrefixUrl.endsWith("/")) {
            this.casPrefixUrl = this.casPrefixUrl + "/";
        }
        if (CommonHelper.isBlank((String)this.casPrefixUrl)) {
            this.casPrefixUrl = this.casLoginUrl.replaceFirst("/login$", "/");
        } else if (CommonHelper.isBlank((String)this.casLoginUrl)) {
            this.casLoginUrl = this.casPrefixUrl + "login";
        }
        this.casPrefixUrl = this.callbackUrlResolver.compute(this.casPrefixUrl, context);
        this.casLoginUrl = this.callbackUrlResolver.compute(this.casLoginUrl, context);
    }

    protected CasCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        if (this.logoutHandler.isTokenRequest(context)) {
            String ticket = context.getRequestParameter(SERVICE_TICKET_PARAMETER);
            this.logoutHandler.recordSession(context, ticket);
            CasCredentials casCredentials = new CasCredentials(ticket, this.getName());
            logger.debug("casCredentials : {}", (Object)casCredentials);
            return casCredentials;
        }
        if (this.logoutHandler.isLogoutRequest(context)) {
            this.logoutHandler.destroySession(context);
            String message = "logout request : no credential returned";
            logger.debug("logout request : no credential returned");
            throw RequiresHttpAction.ok((String)"logout request : no credential returned", (WebContext)context);
        }
        if (this.gateway) {
            logger.info("No credential found in this gateway round-trip");
            return null;
        }
        String message = "No ticket or logout request";
        throw new CredentialsException("No ticket or logout request");
    }

    protected CasProfile retrieveUserProfile(CasCredentials credentials, WebContext context) {
        String ticket = credentials.getServiceTicket();
        try {
            Assertion assertion = this.ticketValidator.validate(ticket, this.computeFinalCallbackUrl(context));
            AttributePrincipal principal = assertion.getPrincipal();
            logger.debug("principal : {}", (Object)principal);
            CasProfile casProfile = this.casProxyReceptor != null ? new CasProxyProfile() : new CasProfile();
            casProfile.setId(principal.getName());
            casProfile.addAttributes(principal.getAttributes());
            if (this.casProxyReceptor != null) {
                ((CasProxyProfile)casProfile).setPrincipal(principal);
            }
            logger.debug("casProfile : {}", (Object)casProfile);
            return casProfile;
        }
        catch (TicketValidationException e) {
            String message = "cannot validate CAS ticket : " + ticket;
            throw new TechnicalException(message, (Throwable)e);
        }
    }

    public String getCasLoginUrl() {
        return this.casLoginUrl;
    }

    public void setCasLoginUrl(String casLoginUrl) {
        this.casLoginUrl = casLoginUrl;
    }

    public String getCasPrefixUrl() {
        return this.casPrefixUrl;
    }

    public void setCasPrefixUrl(String casPrefixUrl) {
        this.casPrefixUrl = casPrefixUrl;
    }

    public CasProtocol getCasProtocol() {
        return this.casProtocol;
    }

    public void setCasProtocol(CasProtocol casProtocol) {
        this.casProtocol = casProtocol;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    public boolean isGateway() {
        return this.gateway;
    }

    public void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public LogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public boolean isAcceptAnyProxy() {
        return this.acceptAnyProxy;
    }

    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    public void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    public CasProxyReceptor getCasProxyReceptor() {
        return this.casProxyReceptor;
    }

    public void setCasProxyReceptor(CasProxyReceptor casProxyReceptor) {
        this.casProxyReceptor = casProxyReceptor;
    }

    public long getTimeTolerance() {
        return this.timeTolerance;
    }

    public void setTimeTolerance(long timeTolerance) {
        this.timeTolerance = timeTolerance;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "casLoginUrl", this.casLoginUrl, "casPrefixUrl", this.casPrefixUrl, "casProtocol", this.casProtocol, "renew", this.renew, "gateway", this.gateway, "encoding", this.encoding, "logoutHandler", this.logoutHandler, "acceptAnyProxy", this.acceptAnyProxy, "allowedProxyChains", this.allowedProxyChains, "casProxyReceptor", this.casProxyReceptor});
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    public ClientType getClientType() {
        return ClientType.CAS_PROTOCOL;
    }

    public static enum CasProtocol {
        CAS10,
        CAS20,
        CAS20_PROXY,
        CAS30,
        CAS30_PROXY,
        SAML;

    }
}

