/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.indent;

import org.jetbrains.annotations.NotNull;

public class IndentUtils {
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    ", "                     ", "                      ", "                       ", "                        ", "                         ", "                          ", "                           ", "                            ", "                             ", "                              ", "                               ", "                                ", "                                 ", "                                  ", "                                   ", "                                    ", "                                     ", "                                      ", "                                       ", "                                        ", "                                         ", "                                          ", "                                           ", "                                            ", "                                             ", "                                              ", "                                               ", "                                                "};
    private static final int SPACES_LENGTH_MINUS_ONE = SPACES.length - 1;

    private IndentUtils() {
        throw new UnsupportedOperationException("No instantiation");
    }

    @NotNull
    public static StringBuilder indentSpace(int len) {
        StringBuilder sB = new StringBuilder();
        if (len < 1) {
            return sB;
        }
        while (len > SPACES_LENGTH_MINUS_ONE) {
            sB.append(SPACES[SPACES_LENGTH_MINUS_ONE]);
            len -= SPACES_LENGTH_MINUS_ONE;
        }
        return sB.append(SPACES[len]);
    }

    @NotNull
    public static <T> String arrayString(T @NotNull [] items) {
        StringBuilder sB = new StringBuilder("A[");
        boolean isFirst = true;
        for (T item : items) {
            if (isFirst) {
                isFirst = false;
            } else {
                sB.append(" ");
            }
            if (item instanceof String) {
                sB.append("\"").append(item).append("\"");
                continue;
            }
            sB.append(item);
        }
        return sB.append("]").toString();
    }

    @NotNull
    public static String arrayString(int @NotNull [] items) {
        StringBuilder sB = new StringBuilder("i[");
        boolean isFirst = true;
        for (int item : items) {
            if (isFirst) {
                isFirst = false;
            } else {
                sB.append(" ");
            }
            sB.append(item);
        }
        return sB.append("]").toString();
    }
}

