/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.function;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.tuple.Tuple2;

@FunctionalInterface
public interface Fn2<A, B, R>
extends BiFunction<A, B, R> {
    public R applyEx(A var1, B var2) throws Exception;

    @Override
    default public R apply(A a, B b) {
        try {
            return this.applyEx(a, b);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <A, B, Z> Fn2<A, B, Z> memoize(final @NotNull Fn2<A, B, Z> f) {
        return new Fn2<A, B, Z>(){
            private final Map<Tuple2<A, B>, Option<Z>> map = new HashMap();

            @Override
            public synchronized Z applyEx(A a, B b) throws Exception {
                Tuple2 t = Tuple2.of(a, b);
                Option val = this.map.get(t);
                if (val != null) {
                    return val.get();
                }
                Object ret = f.applyEx(a, b);
                this.map.put(t, Option.some(ret));
                return ret;
            }
        };
    }

    @NotNull
    public static <A1, B1> Fn2<A1, ? super B1, A1> first() {
        return Singletons.FIRST;
    }

    @NotNull
    public static <A1, B1> Fn2<A1, ? super B1, B1> second() {
        return Singletons.SECOND;
    }

    public static enum Singletons implements Fn2
    {
        FIRST{

            public Object applyEx(Object a, Object b) throws Exception {
                return a;
            }
        }
        ,
        SECOND{

            public Object applyEx(Object a, Object b) throws Exception {
                return b;
            }
        };

    }
}

