/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.fp.FunctionUtils;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.function.Fn2;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.oneOf.Or;
import org.organicdesign.fp.xform.Transformable;
import org.organicdesign.fp.xform.Xform;

public interface UnmodIterable<T>
extends Iterable<T>,
Transformable<T> {
    @NotNull
    public static <T> UnmodIterable<T> emptyUnmodIterable() {
        return UnIterable.EMPTY;
    }

    public static int hash(@NotNull Iterable<?> is) {
        int ret = 0;
        for (Object t : is) {
            if (t == null) continue;
            ret += t.hashCode();
        }
        return ret;
    }

    @NotNull
    public static String toString(@NotNull String name, @NotNull Iterable<?> iterable) {
        StringBuilder sB = new StringBuilder();
        sB.append(name).append("(");
        int i = 0;
        Iterator<?> iter = iterable.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                sB.append(",");
            }
            Object item = iter.next();
            sB.append(FunctionUtils.stringify(item));
            ++i;
        }
        return sB.append(")").toString();
    }

    @Override
    @NotNull
    public UnmodIterator<T> iterator();

    @Override
    @NotNull
    default public UnmodIterable<T> concat(@Nullable Iterable<? extends T> list) {
        return Xform.of(this).concat((Iterable)list);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> precat(@Nullable Iterable<? extends T> list) {
        return Xform.of(this).precat((Iterable)list);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> drop(long n) {
        return Xform.of(this).drop(n);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> dropWhile(@NotNull Fn1<? super T, Boolean> predicate) {
        return Xform.of(this).dropWhile((Fn1)predicate);
    }

    @Override
    default public <B> B fold(B ident, @NotNull Fn2<? super B, ? super T, B> reducer) {
        return Xform.of(this).fold(ident, reducer);
    }

    @Override
    @NotNull
    default public <G, B> Or<G, B> foldUntil(G accum, @Nullable Fn2<? super G, ? super T, B> terminator, @NotNull Fn2<? super G, ? super T, G> reducer) {
        return Xform.of(this).foldUntil(accum, terminator, reducer);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> filter(@NotNull Fn1<? super T, Boolean> f) {
        return Xform.of(this).filter((Fn1)f);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> whereNonNull() {
        return Xform.of(this).filter(Objects::nonNull);
    }

    @Override
    @NotNull
    default public <B> UnmodIterable<B> flatMap(@NotNull Fn1<? super T, Iterable<B>> f) {
        return Xform.of(this).flatMap((Fn1)f);
    }

    @Override
    @NotNull
    default public <B> UnmodIterable<B> map(@NotNull Fn1<? super T, ? extends B> f) {
        return Xform.of(this).map((Fn1)f);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> take(long numItems) {
        return Xform.of(this).take(numItems);
    }

    @Override
    @NotNull
    default public UnmodIterable<T> takeWhile(@NotNull Fn1<? super T, Boolean> f) {
        return Xform.of(this).takeWhile((Fn1)f);
    }

    @Override
    @NotNull
    default public Option<T> head() {
        Iterator iter = this.iterator();
        return iter.hasNext() ? Option.some(iter.next()) : Option.none();
    }

    public static enum UnIterable implements UnmodIterable
    {
        EMPTY{

            @Override
            @NotNull
            public UnmodIterator iterator() {
                return UnmodIterator.emptyUnmodIterator();
            }
        };

    }
}

