/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.fp.collections.AbstractUnmodMap;
import org.organicdesign.fp.collections.Equator;
import org.organicdesign.fp.collections.ImMap;
import org.organicdesign.fp.collections.MutMap;
import org.organicdesign.fp.collections.PersistentTreeMap;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.collections.UnmodMap;
import org.organicdesign.fp.function.Fn2;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.tuple.Tuple2;

public class PersistentHashMap<K, V>
extends AbstractUnmodMap<K, V>
implements ImMap<K, V>,
Serializable {
    @NotNull
    public static final PersistentHashMap<Object, Object> EMPTY = new PersistentHashMap(null, 0, null, false, null);
    @NotNull
    private final Equator<K> equator;
    private final int size;
    @Nullable
    private final transient INode<K, V> root;
    private final boolean hasNull;
    private final V nullValue;
    private static final long serialVersionUID = 20160903192900L;

    private static int mask(int hash, int shift) {
        return hash >>> shift & 0x1F;
    }

    private static <K> K k(Object @NotNull [] array, int i) {
        return (K)array[i];
    }

    private static <V> V v(Object @NotNull [] array, int i) {
        return (V)array[i];
    }

    private static <K, V> INode<K, V> iNode(Object @NotNull [] array, int i) {
        return (INode)array[i];
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> empty() {
        return EMPTY;
    }

    @NotNull
    public static <K, V> MutHashMap<K, V> emptyMutable() {
        return PersistentHashMap.empty().mutable();
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> empty(@Nullable Equator<K> e) {
        return new PersistentHashMap<K, Object>(e, 0, null, false, null);
    }

    @NotNull
    public static <K, V> MutHashMap<K, V> emptyMutable(Equator<K> e) {
        return PersistentHashMap.empty(e).mutable();
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> ofEq(Equator<K> eq, @Nullable Iterable<Map.Entry<K, V>> es) {
        if (es == null) {
            return PersistentHashMap.empty(eq);
        }
        MutHashMap<K, V> map = PersistentHashMap.emptyMutable(eq);
        for (Map.Entry<K, V> entry : es) {
            if (entry == null) continue;
            map.assoc((Object)entry.getKey(), (Object)entry.getValue());
        }
        return map.immutable();
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> of(@Nullable Iterable<Map.Entry<K, V>> kvPairs) {
        if (kvPairs == null) {
            return PersistentHashMap.empty();
        }
        PersistentHashMap<K, V> m = PersistentHashMap.empty();
        MutMap map = m.mutable();
        for (Map.Entry<K, V> entry : kvPairs) {
            if (entry == null) continue;
            ((MutHashMap)map).assoc((Object)entry.getKey(), (Object)entry.getValue());
        }
        return ((MutHashMap)map).immutable();
    }

    private PersistentHashMap(@Nullable Equator<K> eq, int sz, @Nullable INode<K, V> root, boolean hasNull, V nullValue) {
        this.equator = eq == null ? Equator.defaultEquator() : eq;
        this.size = sz;
        this.root = root;
        this.hasNull = hasNull;
        this.nullValue = nullValue;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    @NotNull
    public Equator<K> equator() {
        return this.equator;
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> assoc(K key, V val) {
        if (key == null) {
            if (this.hasNull && val == this.nullValue) {
                return this;
            }
            return new PersistentHashMap<K, V>(this.equator, this.hasNull ? this.size : this.size + 1, this.root, true, val);
        }
        PersistentTreeMap.Box<Object> addedLeaf = new PersistentTreeMap.Box<Object>(null);
        INode<K, V> newroot = this.root == null ? BitmapIndexedNode.empty(this.equator) : this.root;
        if ((newroot = newroot.assoc(0, this.equator.hash(key), key, val, addedLeaf)) == this.root) {
            return this;
        }
        return new PersistentHashMap<K, V>(this.equator, addedLeaf.val == null ? this.size : this.size + 1, newroot, this.hasNull, this.nullValue);
    }

    @Override
    @NotNull
    public MutHashMap<K, V> mutable() {
        return new MutHashMap(this);
    }

    @Override
    @NotNull
    public Option<UnmodMap.UnEntry<K, V>> entry(K key) {
        if (key == null) {
            return this.hasNull ? Option.some(Tuple2.of(null, this.nullValue)) : Option.none();
        }
        if (this.root == null) {
            return Option.none();
        }
        UnmodMap.UnEntry<K, V> entry = this.root.find(0, this.equator.hash(key), key);
        return Option.someOrNullNoneOf(entry);
    }

    @Override
    @NotNull
    public UnmodIterator<UnmodMap.UnEntry<K, V>> iterator() {
        return this.iterator(Tuple2::of);
    }

    @Override
    @NotNull
    public UnmodIterator<K> keyIterator() {
        return this.iterator(Fn2.Singletons.FIRST);
    }

    @Override
    @NotNull
    public UnmodIterator<V> valIterator() {
        return this.iterator(Fn2.Singletons.SECOND);
    }

    @NotNull
    private <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
        Iter<K, V, R> rootIter = this.root == null ? UnmodIterator.emptyUnmodIterator() : this.root.iterator(aFn);
        return this.hasNull ? new Iter<K, V, R>(rootIter, aFn, this.nullValue) : rootIter;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> without(K key) {
        if (key == null) {
            return this.hasNull ? new PersistentHashMap<K, Object>(this.equator, this.size - 1, this.root, false, null) : this;
        }
        if (this.root == null) {
            return this;
        }
        INode<K, V> newroot = this.root.without(0, this.equator.hash(key), key);
        if (newroot == this.root) {
            return this;
        }
        return new PersistentHashMap<K, V>(this.equator, this.size - 1, newroot, this.hasNull, this.nullValue);
    }

    private static <K, V> INode<K, V> @NotNull [] cloneAndSet(INode<K, V> @NotNull [] array, int i, INode<K, V> a) {
        INode[] clone = (INode[])array.clone();
        clone[i] = a;
        return clone;
    }

    private static Object @NotNull [] cloneAndSet(Object @NotNull [] array, int i, Object a) {
        Object[] clone = (Object[])array.clone();
        clone[i] = a;
        return clone;
    }

    private static Object @NotNull [] cloneAndSet(Object @NotNull [] array, int i, int j, Object b) {
        Object[] clone = (Object[])array.clone();
        clone[i] = null;
        clone[j] = b;
        return clone;
    }

    private static Object @NotNull [] removePair(Object @NotNull [] array, int i) {
        Object[] newArray = new Object[array.length - 2];
        System.arraycopy(array, 0, newArray, 0, 2 * i);
        System.arraycopy(array, 2 * (i + 1), newArray, 2 * i, newArray.length - 2 * i);
        return newArray;
    }

    private static <K, V> INode<K, V> createNode(@NotNull Equator<K> equator, int shift, K key1, V val1, int key2hash, K key2, V val2) {
        int key1hash = equator.hash(key1);
        if (key1hash == key2hash) {
            return new HashCollisionNode(equator, null, key1hash, 2, key1, val1, key2, val2);
        }
        PersistentTreeMap.Box<Object> addedLeaf = new PersistentTreeMap.Box<Object>(null);
        AtomicReference<Thread> edit = new AtomicReference<Thread>();
        return BitmapIndexedNode.empty(equator).assoc(edit, shift, key1hash, key1, val1, addedLeaf).assoc(edit, shift, key2hash, key2, val2, addedLeaf);
    }

    private static <K, V> INode<K, V> createNode(@NotNull Equator<K> equator, AtomicReference<Thread> edit, int shift, K key1, V val1, int key2hash, K key2, V val2) {
        int key1hash = equator.hash(key1);
        if (key1hash == key2hash) {
            return new HashCollisionNode(equator, null, key1hash, 2, key1, val1, key2, val2);
        }
        PersistentTreeMap.Box<Object> addedLeaf = new PersistentTreeMap.Box<Object>(null);
        return BitmapIndexedNode.empty(equator).assoc(edit, shift, key1hash, key1, val1, addedLeaf).assoc(edit, shift, key2hash, key2, val2, addedLeaf);
    }

    private static int bitpos(int hash, int shift) {
        return 1 << PersistentHashMap.mask(hash, shift);
    }

    private static final class NodeIter<K, V, R>
    implements UnmodIterator<R> {
        final Object[] array;
        private final Fn2<K, V, R> aFn;
        private int mutableIndex = 0;
        private R nextEntry = null;
        private boolean absent = true;
        private UnmodIterator<R> nextIter;

        NodeIter(Object[] array, Fn2<K, V, R> aFn) {
            this.array = array;
            this.aFn = aFn;
        }

        private boolean advance() {
            while (this.mutableIndex < this.array.length) {
                UnmodIterator<R> iter;
                int i = this.mutableIndex;
                this.mutableIndex = i + 2;
                if (this.array[i] != null) {
                    this.nextEntry = this.aFn.apply((K)PersistentHashMap.k(this.array, i), (V)PersistentHashMap.v(this.array, i + 1));
                    this.absent = false;
                    return true;
                }
                INode<K, V> node = PersistentHashMap.iNode(this.array, i + 1);
                if (node == null || (iter = node.iterator(this.aFn)) == null || !iter.hasNext()) continue;
                this.nextIter = iter;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (!this.absent || this.nextIter != null) {
                return true;
            }
            return this.advance();
        }

        @Override
        public R next() {
            Object ret = this.nextEntry;
            if (!this.absent) {
                this.nextEntry = null;
                this.absent = true;
                return ret;
            }
            if (this.nextIter != null) {
                ret = this.nextIter.next();
                if (!this.nextIter.hasNext()) {
                    this.nextIter = null;
                }
                return ret;
            }
            if (this.advance()) {
                return this.next();
            }
            throw new NoSuchElementException();
        }
    }

    private static final class HashCollisionNode<K, V>
    implements INode<K, V> {
        private final Equator<K> equator;
        final int hash;
        int count;
        Object[] array;
        final AtomicReference<Thread> edit;

        HashCollisionNode(Equator<K> eq, AtomicReference<Thread> edit, int hash, int count, Object ... array) {
            this.equator = eq;
            this.edit = edit;
            this.hash = hash;
            this.count = count;
            this.array = array;
        }

        @Override
        public INode<K, V> assoc(int shift, int hash, K key, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            if (hash == this.hash) {
                int idx = this.findIndex(key);
                if (idx != -1) {
                    if (this.array[idx + 1] == val) {
                        return this;
                    }
                    return new HashCollisionNode<K, V>(this.equator, null, hash, this.count, PersistentHashMap.cloneAndSet(this.array, idx + 1, val));
                }
                Object[] newArray = new Object[2 * (this.count + 1)];
                System.arraycopy(this.array, 0, newArray, 0, 2 * this.count);
                newArray[2 * this.count] = key;
                newArray[2 * this.count + 1] = val;
                addedLeaf.val = addedLeaf;
                return new HashCollisionNode<K, V>(this.equator, this.edit, hash, this.count + 1, newArray);
            }
            return new BitmapIndexedNode<K, V>(this.equator, null, PersistentHashMap.bitpos(this.hash, shift), new Object[]{null, this}).assoc(shift, hash, key, val, addedLeaf);
        }

        @Override
        public INode<K, V> without(int shift, int hash, K key) {
            int idx = this.findIndex(key);
            if (idx == -1) {
                return this;
            }
            if (this.count == 1) {
                return null;
            }
            return new HashCollisionNode<K, V>(this.equator, null, hash, this.count - 1, PersistentHashMap.removePair(this.array, idx / 2));
        }

        @Override
        public UnmodMap.UnEntry<K, V> find(int shift, int hash, K key) {
            int idx = this.findIndex(key);
            if (idx < 0) {
                return null;
            }
            if (this.equator.eq(key, PersistentHashMap.k(this.array, idx))) {
                return Tuple2.of(PersistentHashMap.k(this.array, idx), PersistentHashMap.v(this.array, idx + 1));
            }
            return null;
        }

        @Override
        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            return new NodeIter<K, V, R>(this.array, aFn);
        }

        private int findIndex(K key) {
            for (int i = 0; i < 2 * this.count; i += 2) {
                if (!this.equator.eq(key, PersistentHashMap.k(this.array, i))) continue;
                return i;
            }
            return -1;
        }

        private HashCollisionNode<K, V> ensureEditable(AtomicReference<Thread> edit) {
            if (this.edit == edit) {
                return this;
            }
            Object[] newArray = new Object[2 * (this.count + 1)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * this.count);
            return new HashCollisionNode<K, V>(this.equator, edit, this.hash, this.count, newArray);
        }

        private HashCollisionNode<K, V> ensureEditable(AtomicReference<Thread> edit, int count, Object[] array) {
            if (this.edit == edit) {
                this.array = array;
                this.count = count;
                return this;
            }
            return new HashCollisionNode<K, V>(this.equator, edit, this.hash, count, array);
        }

        private HashCollisionNode<K, V> editAndSet(AtomicReference<Thread> edit, int i, Object a) {
            HashCollisionNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i] = a;
            return editable;
        }

        private HashCollisionNode<K, V> editAndSet(AtomicReference<Thread> edit, int i, Object a, int j, Object b) {
            HashCollisionNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i] = a;
            editable.array[j] = b;
            return editable;
        }

        @Override
        public INode<K, V> assoc(AtomicReference<Thread> edit, int shift, int hash, K key, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            if (hash == this.hash) {
                int idx = this.findIndex(key);
                if (idx != -1) {
                    if (this.array[idx + 1] == val) {
                        return this;
                    }
                    return this.editAndSet(edit, idx + 1, val);
                }
                if (this.array.length > 2 * this.count) {
                    addedLeaf.val = addedLeaf;
                    HashCollisionNode<K, V> editable = this.editAndSet(edit, 2 * this.count, key, 2 * this.count + 1, val);
                    ++editable.count;
                    return editable;
                }
                Object[] newArray = new Object[this.array.length + 2];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                newArray[this.array.length] = key;
                newArray[this.array.length + 1] = val;
                addedLeaf.val = addedLeaf;
                return this.ensureEditable(edit, this.count + 1, newArray);
            }
            return new BitmapIndexedNode<K, V>(this.equator, edit, PersistentHashMap.bitpos(this.hash, shift), new Object[]{null, this, null, null}).assoc(edit, shift, hash, key, val, addedLeaf);
        }

        @Override
        public INode<K, V> without(AtomicReference<Thread> edit, int shift, int hash, K key, PersistentTreeMap.Box<PersistentTreeMap.Box> removedLeaf) {
            int idx = this.findIndex(key);
            if (idx == -1) {
                return this;
            }
            removedLeaf.val = removedLeaf;
            if (this.count == 1) {
                return null;
            }
            HashCollisionNode<K, V> editable = this.ensureEditable(edit);
            editable.array[idx] = editable.array[2 * this.count - 2];
            editable.array[idx + 1] = editable.array[2 * this.count - 1];
            editable.array[2 * this.count - 1] = null;
            editable.array[2 * this.count - 2] = null;
            --editable.count;
            return editable;
        }
    }

    private static final class BitmapIndexedNode<K, V>
    implements INode<K, V> {
        private final Equator<K> equator;
        int bitmap;
        Object[] array;
        final AtomicReference<Thread> edit;

        static <K, V> BitmapIndexedNode<K, V> empty(Equator<K> e) {
            return new BitmapIndexedNode<K, V>(e, null, 0, new Object[0]);
        }

        public String toString() {
            return "BitmapIndexedNode(" + this.bitmap + "," + Arrays.toString(this.array) + "," + this.edit + ")";
        }

        int index(int bit) {
            return Integer.bitCount(this.bitmap & bit - 1);
        }

        BitmapIndexedNode(Equator<K> equator, AtomicReference<Thread> edit, int bitmap, Object[] array) {
            this.equator = equator;
            this.bitmap = bitmap;
            this.array = array;
            this.edit = edit;
        }

        @Override
        public INode<K, V> assoc(int shift, int hash, K key, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
                Object valOrNode = this.array[2 * idx + 1];
                if (keyOrNull == null) {
                    INode<K, V> n = ((INode)valOrNode).assoc(shift + 5, hash, key, val, addedLeaf);
                    if (n == valOrNode) {
                        return this;
                    }
                    return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, n));
                }
                if (this.equator.eq(key, keyOrNull)) {
                    if (val == valOrNode) {
                        return this;
                    }
                    return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, val));
                }
                addedLeaf.val = addedLeaf;
                return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx, 2 * idx + 1, PersistentHashMap.createNode(this.equator, shift + 5, keyOrNull, valOrNode, hash, key, val)));
            }
            int n = Integer.bitCount(this.bitmap);
            if (n >= 16) {
                INode[] nodes = new INode[32];
                int jdx = PersistentHashMap.mask(hash, shift);
                nodes[jdx] = BitmapIndexedNode.empty(this.equator).assoc(shift + 5, hash, key, val, addedLeaf);
                int j = 0;
                for (int i = 0; i < 32; ++i) {
                    if ((this.bitmap >>> i & 1) == 0) continue;
                    nodes[i] = this.array[j] == null ? (INode)this.array[j + 1] : BitmapIndexedNode.empty(this.equator).assoc(shift + 5, this.equator.hash(PersistentHashMap.k(this.array, j)), PersistentHashMap.k(this.array, j), this.array[j + 1], addedLeaf);
                    j += 2;
                }
                return new ArrayNode(this.equator, null, n + 1, nodes);
            }
            Object[] newArray = new Object[2 * (n + 1)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * idx);
            newArray[2 * idx] = key;
            addedLeaf.val = addedLeaf;
            newArray[2 * idx + 1] = val;
            System.arraycopy(this.array, 2 * idx, newArray, 2 * (idx + 1), 2 * (n - idx));
            return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap | bit, newArray);
        }

        @Override
        public INode<K, V> without(int shift, int hash, K key) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int idx = this.index(bit);
            Object keyOrNull = this.array[2 * idx];
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                INode n = ((INode)valOrNode).without(shift + 5, hash, key);
                if (n == valOrNode) {
                    return this;
                }
                if (n != null) {
                    return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, n));
                }
                if (this.bitmap == bit) {
                    return null;
                }
                return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap ^ bit, PersistentHashMap.removePair(this.array, idx));
            }
            if (this.equator.eq(key, keyOrNull)) {
                return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap ^ bit, PersistentHashMap.removePair(this.array, idx));
            }
            return this;
        }

        @Override
        public UnmodMap.UnEntry<K, V> find(int shift, int hash, K key) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return null;
            }
            int idx = this.index(bit);
            Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                return ((INode)valOrNode).find(shift + 5, hash, key);
            }
            if (this.equator.eq(key, keyOrNull)) {
                return Tuple2.of(keyOrNull, valOrNode);
            }
            return null;
        }

        @Override
        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            return new NodeIter<K, V, R>(this.array, aFn);
        }

        private BitmapIndexedNode<K, V> ensureEditable(AtomicReference<Thread> edit) {
            if (this.edit == edit) {
                return this;
            }
            int n = Integer.bitCount(this.bitmap);
            Object[] newArray = new Object[n >= 0 ? 2 * (n + 1) : 4];
            System.arraycopy(this.array, 0, newArray, 0, 2 * n);
            return new BitmapIndexedNode<K, V>(this.equator, edit, this.bitmap, newArray);
        }

        private BitmapIndexedNode<K, V> editAndSet(AtomicReference<Thread> edit, int i, Object a) {
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i] = a;
            return editable;
        }

        private BitmapIndexedNode<K, V> editAndSet(AtomicReference<Thread> edit, int i, int j, Object b) {
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i] = null;
            editable.array[j] = b;
            return editable;
        }

        private BitmapIndexedNode<K, V> editAndRemovePair(AtomicReference<Thread> edit, int bit, int i) {
            if (this.bitmap == bit) {
                return null;
            }
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.bitmap ^= bit;
            System.arraycopy(editable.array, 2 * (i + 1), editable.array, 2 * i, editable.array.length - 2 * (i + 1));
            editable.array[editable.array.length - 2] = null;
            editable.array[editable.array.length - 1] = null;
            return editable;
        }

        @Override
        public INode<K, V> assoc(AtomicReference<Thread> edit, int shift, int hash, K key, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
                Object valOrNode = this.array[2 * idx + 1];
                if (keyOrNull == null) {
                    INode<K, V> n = ((INode)valOrNode).assoc(edit, shift + 5, hash, key, val, addedLeaf);
                    if (n == valOrNode) {
                        return this;
                    }
                    return this.editAndSet(edit, 2 * idx + 1, n);
                }
                if (this.equator.eq(key, keyOrNull)) {
                    if (val == valOrNode) {
                        return this;
                    }
                    return this.editAndSet(edit, 2 * idx + 1, val);
                }
                addedLeaf.val = addedLeaf;
                return this.editAndSet(edit, 2 * idx, 2 * idx + 1, PersistentHashMap.createNode(this.equator, edit, shift + 5, keyOrNull, valOrNode, hash, key, val));
            }
            int n = Integer.bitCount(this.bitmap);
            if (n * 2 < this.array.length) {
                addedLeaf.val = addedLeaf;
                BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
                System.arraycopy(editable.array, 2 * idx, editable.array, 2 * (idx + 1), 2 * (n - idx));
                editable.array[2 * idx] = key;
                editable.array[2 * idx + 1] = val;
                editable.bitmap |= bit;
                return editable;
            }
            if (n >= 16) {
                INode[] nodes = new INode[32];
                int jdx = PersistentHashMap.mask(hash, shift);
                nodes[jdx] = BitmapIndexedNode.empty(this.equator).assoc(edit, shift + 5, hash, key, val, addedLeaf);
                int j = 0;
                for (int i = 0; i < 32; ++i) {
                    if ((this.bitmap >>> i & 1) == 0) continue;
                    nodes[i] = this.array[j] == null ? (INode)this.array[j + 1] : BitmapIndexedNode.empty(this.equator).assoc(edit, shift + 5, this.equator.hash(PersistentHashMap.k(this.array, j)), PersistentHashMap.k(this.array, j), this.array[j + 1], addedLeaf);
                    j += 2;
                }
                return new ArrayNode(this.equator, edit, n + 1, nodes);
            }
            Object[] newArray = new Object[2 * (n + 4)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * idx);
            newArray[2 * idx] = key;
            addedLeaf.val = addedLeaf;
            newArray[2 * idx + 1] = val;
            System.arraycopy(this.array, 2 * idx, newArray, 2 * (idx + 1), 2 * (n - idx));
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.array = newArray;
            editable.bitmap |= bit;
            return editable;
        }

        @Override
        public INode<K, V> without(AtomicReference<Thread> edit, int shift, int hash, K key, PersistentTreeMap.Box<PersistentTreeMap.Box> removedLeaf) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int idx = this.index(bit);
            Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                INode n = ((INode)valOrNode).without(edit, shift + 5, hash, key, removedLeaf);
                if (n == valOrNode) {
                    return this;
                }
                if (n != null) {
                    return this.editAndSet(edit, 2 * idx + 1, n);
                }
                if (this.bitmap == bit) {
                    return null;
                }
                return this.editAndRemovePair(edit, bit, idx);
            }
            if (this.equator.eq(key, keyOrNull)) {
                removedLeaf.val = removedLeaf;
                return this.editAndRemovePair(edit, bit, idx);
            }
            return this;
        }
    }

    private static final class ArrayNode<K, V>
    implements INode<K, V>,
    UnmodIterable<UnmodMap.UnEntry<K, V>> {
        private final Equator<K> equator;
        int count;
        final INode<K, V> @NotNull [] array;
        final AtomicReference<Thread> edit;

        ArrayNode(Equator<K> eq, AtomicReference<Thread> edit, int count, INode<K, V> @NotNull [] array) {
            this.equator = eq;
            this.array = array;
            this.edit = edit;
            this.count = count;
        }

        @Override
        public INode<K, V> assoc(int shift, int hash, K key, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                BitmapIndexedNode<K, V> e = BitmapIndexedNode.empty(this.equator);
                INode n = e.assoc(shift + 5, hash, key, val, addedLeaf);
                return new ArrayNode<K, V>(this.equator, null, this.count + 1, PersistentHashMap.cloneAndSet(this.array, idx, n));
            }
            INode<K, V> n = node.assoc(shift + 5, hash, key, val, addedLeaf);
            if (n == node) {
                return this;
            }
            return new ArrayNode<K, V>(this.equator, null, this.count, PersistentHashMap.cloneAndSet(this.array, idx, n));
        }

        @Override
        public INode<K, V> without(int shift, int hash, K key) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                return this;
            }
            INode<K, V> n = node.without(shift + 5, hash, key);
            if (n == node) {
                return this;
            }
            if (n == null) {
                if (this.count <= 8) {
                    return this.pack(null, idx);
                }
                return new ArrayNode<K, V>(this.equator, null, this.count - 1, PersistentHashMap.cloneAndSet(this.array, idx, null));
            }
            return new ArrayNode<K, V>(this.equator, null, this.count, PersistentHashMap.cloneAndSet(this.array, idx, n));
        }

        @Override
        public UnmodMap.UnEntry<K, V> find(int shift, int hash, K key) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                return null;
            }
            return node.find(shift + 5, hash, key);
        }

        @Override
        @NotNull
        public UnmodIterator<UnmodMap.UnEntry<K, V>> iterator() {
            return this.iterator(Tuple2::of);
        }

        @Override
        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            return new Iter<K, V, R>(this.array, aFn);
        }

        private ArrayNode<K, V> ensureEditable(AtomicReference<Thread> edit) {
            if (this.edit == edit) {
                return this;
            }
            return new ArrayNode<K, V>(this.equator, edit, this.count, (INode[])this.array.clone());
        }

        private ArrayNode<K, V> editAndSet(AtomicReference<Thread> edit, int i, INode<K, V> n) {
            ArrayNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i] = n;
            return editable;
        }

        private INode<K, V> pack(AtomicReference<Thread> edit, int idx) {
            int i;
            Object[] newArray = new Object[2 * (this.count - 1)];
            int j = 1;
            int bitmap = 0;
            for (i = 0; i < idx; ++i) {
                if (this.array[i] == null) continue;
                newArray[j] = this.array[i];
                bitmap |= 1 << i;
                j += 2;
            }
            for (i = idx + 1; i < this.array.length; ++i) {
                if (this.array[i] == null) continue;
                newArray[j] = this.array[i];
                bitmap |= 1 << i;
                j += 2;
            }
            return new BitmapIndexedNode(this.equator, edit, bitmap, newArray);
        }

        @Override
        public INode<K, V> assoc(AtomicReference<Thread> edit, int shift, int hash, K key, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                BitmapIndexedNode<K, V> en = BitmapIndexedNode.empty(this.equator);
                ArrayNode editable = this.editAndSet(edit, idx, en.assoc(edit, shift + 5, hash, key, val, addedLeaf));
                ++editable.count;
                return editable;
            }
            INode<K, V> n = node.assoc(edit, shift + 5, hash, key, val, addedLeaf);
            if (n == node) {
                return this;
            }
            return this.editAndSet(edit, idx, n);
        }

        @Override
        public INode<K, V> without(AtomicReference<Thread> edit, int shift, int hash, K key, PersistentTreeMap.Box<PersistentTreeMap.Box> removedLeaf) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                return this;
            }
            INode<K, V> n = node.without(edit, shift + 5, hash, key, removedLeaf);
            if (n == node) {
                return this;
            }
            if (n == null) {
                if (this.count <= 8) {
                    return this.pack(edit, idx);
                }
                ArrayNode<K, V> editable = this.editAndSet(edit, idx, null);
                --editable.count;
                return editable;
            }
            return this.editAndSet(edit, idx, n);
        }

        public String toString() {
            return UnmodIterable.toString("ArrayNode", this);
        }

        private static class Iter<K, V, R>
        implements UnmodIterator<R> {
            private final INode<K, V> @NotNull [] array;
            private final Fn2<K, V, R> aFn;
            private int i = 0;
            private UnmodIterator<R> nestedIter;

            private Iter(INode<K, V> @NotNull [] array, Fn2<K, V, R> aFn) {
                this.array = array;
                this.aFn = aFn;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    INode<K, V> node;
                    if (this.nestedIter != null) {
                        if (this.nestedIter.hasNext()) {
                            return true;
                        }
                        this.nestedIter = null;
                    }
                    if (this.i >= this.array.length) break;
                    if ((node = this.array[this.i++]) == null) continue;
                    this.nestedIter = node.iterator(this.aFn);
                }
                return false;
            }

            @Override
            public R next() {
                if (this.hasNext()) {
                    return (R)this.nestedIter.next();
                }
                throw new NoSuchElementException();
            }
        }
    }

    private static interface INode<K, V> {
        public INode<K, V> assoc(int var1, int var2, K var3, V var4, PersistentTreeMap.Box<PersistentTreeMap.Box> var5);

        public INode<K, V> without(int var1, int var2, K var3);

        public UnmodMap.UnEntry<K, V> find(int var1, int var2, K var3);

        public INode<K, V> assoc(AtomicReference<Thread> var1, int var2, int var3, K var4, V var5, PersistentTreeMap.Box<PersistentTreeMap.Box> var6);

        public INode<K, V> without(AtomicReference<Thread> var1, int var2, int var3, K var4, PersistentTreeMap.Box<PersistentTreeMap.Box> var5);

        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> var1);
    }

    public static final class MutHashMap<K, V>
    extends AbstractUnmodMap<K, V>
    implements MutMap<K, V> {
        private final AtomicReference<Thread> edit;
        private final Equator<K> equator;
        private INode<K, V> root;
        private int count;
        private boolean hasNull;
        private V nullValue;
        private final PersistentTreeMap.Box<PersistentTreeMap.Box> leafFlag = new PersistentTreeMap.Box<Object>(null);

        private MutHashMap(PersistentHashMap<K, V> m) {
            this(m.equator(), new AtomicReference<Thread>(Thread.currentThread()), m.root, m.size, m.hasNull, m.nullValue);
        }

        private MutHashMap(Equator<K> e, AtomicReference<Thread> edit, INode<K, V> root, int count, boolean hasNull, V nullValue) {
            this.equator = e == null ? Equator.defaultEquator() : e;
            this.edit = edit;
            this.root = root;
            this.count = count;
            this.hasNull = hasNull;
            this.nullValue = nullValue;
        }

        @Override
        public Equator<K> equator() {
            return this.equator;
        }

        @Override
        @NotNull
        public MutHashMap<K, V> assoc(K key, V val) {
            this.ensureEditable();
            if (key == null) {
                if (this.nullValue != val) {
                    this.nullValue = val;
                }
                if (!this.hasNull) {
                    ++this.count;
                    this.hasNull = true;
                }
                return this;
            }
            this.leafFlag.val = null;
            INode<K, V> n = this.root == null ? BitmapIndexedNode.empty(this.equator) : this.root;
            if ((n = n.assoc(this.edit, 0, this.equator.hash(key), key, val, this.leafFlag)) != this.root) {
                this.root = n;
            }
            if (this.leafFlag.val != null) {
                ++this.count;
            }
            return this;
        }

        @Override
        @NotNull
        public Option<UnmodMap.UnEntry<K, V>> entry(K key) {
            this.ensureEditable();
            if (key == null) {
                return this.hasNull ? Option.some(Tuple2.of(null, this.nullValue)) : Option.none();
            }
            if (this.root == null) {
                return Option.none();
            }
            UnmodMap.UnEntry<K, V> entry = this.root.find(0, this.equator.hash(key), key);
            return Option.someOrNullNoneOf(entry);
        }

        @Override
        @NotNull
        public UnmodIterator<UnmodMap.UnEntry<K, V>> iterator() {
            return this.iterator(Tuple2::of);
        }

        @Override
        @NotNull
        public UnmodIterator<K> keyIterator() {
            return this.iterator(Fn2.Singletons.FIRST);
        }

        @Override
        @NotNull
        public UnmodIterator<V> valIterator() {
            return this.iterator(Fn2.Singletons.SECOND);
        }

        private <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            Iter<K, V, R> rootIter = this.root == null ? UnmodIterator.emptyUnmodIterator() : this.root.iterator(aFn);
            return this.hasNull ? new Iter<K, V, R>(rootIter, aFn, this.nullValue) : rootIter;
        }

        @Override
        @NotNull
        public MutHashMap<K, V> without(K key) {
            this.ensureEditable();
            if (key == null) {
                if (!this.hasNull) {
                    return this;
                }
                this.hasNull = false;
                this.nullValue = null;
                --this.count;
                return this;
            }
            if (this.root == null) {
                return this;
            }
            this.leafFlag.val = null;
            INode<K, V> n = this.root.without(this.edit, 0, this.equator.hash(key), key, this.leafFlag);
            if (n != this.root) {
                this.root = n;
            }
            if (this.leafFlag.val != null) {
                --this.count;
            }
            return this;
        }

        @Override
        @NotNull
        public PersistentHashMap<K, V> immutable() {
            this.ensureEditable();
            this.edit.set(null);
            return new PersistentHashMap<K, V>(this.equator, this.count, this.root, this.hasNull, this.nullValue);
        }

        @Override
        public int size() {
            this.ensureEditable();
            return this.count;
        }

        private void ensureEditable() {
            if (this.edit.get() == null) {
                throw new IllegalStateException("Mutable used after immutable! call");
            }
        }
    }

    private static class SerializationProxy<K, V>
    implements Serializable {
        private final Equator<K> equator;
        private final int size;
        private transient ImMap<K, V> theMap;
        private static final long serialVersionUID = 20160827174100L;

        SerializationProxy(PersistentHashMap<K, V> phm) {
            this.equator = phm.equator;
            this.size = phm.size;
            this.theMap = phm;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            for (UnmodMap.UnEntry unEntry : this.theMap) {
                s.writeObject(unEntry.getKey());
                s.writeObject(unEntry.getValue());
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            MutMap tempMap = new PersistentHashMap<K, Object>(this.equator, 0, null, false, null).mutable();
            for (int i = 0; i < this.size; ++i) {
                tempMap.assoc(s.readObject(), s.readObject());
            }
            this.theMap = tempMap.immutable();
        }

        private Object readResolve() {
            return this.theMap;
        }
    }

    private static class Iter<K, V, R>
    implements UnmodIterator<R> {
        private boolean seen = false;
        private final UnmodIterator<R> rootIter;
        private final Fn2<K, V, R> aFn;
        private final V nullValue;

        private Iter(UnmodIterator<R> ri, Fn2<K, V, R> aFn, V nv) {
            this.rootIter = ri;
            this.aFn = aFn;
            this.nullValue = nv;
        }

        @Override
        public boolean hasNext() {
            if (!this.seen) {
                return true;
            }
            return this.rootIter.hasNext();
        }

        @Override
        public R next() {
            if (!this.seen) {
                this.seen = true;
                return this.aFn.apply((K)null, this.nullValue);
            }
            return (R)this.rootIter.next();
        }
    }
}

