/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.fp.collections.Equator;

public interface ComparisonContext<T>
extends Equator<T>,
Comparator<T> {
    default public boolean lt(T o1, T o2) {
        return this.compare(o1, o2) < 0;
    }

    default public boolean lte(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return this.compare(o1, o2) <= 0;
    }

    default public boolean gt(T o1, T o2) {
        return this.compare(o1, o2) > 0;
    }

    default public boolean gte(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return this.compare(o1, o2) >= 0;
    }

    @Override
    default public boolean eq(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return this.compare(o1, o2) == 0;
    }

    default public T min(@NotNull Iterable<T> items) {
        Iterator<T> iter = items.iterator();
        T ret = null;
        while (ret == null && iter.hasNext()) {
            ret = iter.next();
        }
        while (iter.hasNext()) {
            T next = iter.next();
            if (next == null || !this.lt(next, ret)) continue;
            ret = next;
        }
        return ret;
    }

    default public T max(@NotNull Iterable<T> items) {
        Iterator<T> iter = items.iterator();
        T ret = null;
        while (ret == null && iter.hasNext()) {
            ret = iter.next();
        }
        while (iter.hasNext()) {
            T next = iter.next();
            if (next == null || !this.gt(next, ret)) continue;
            ret = next;
        }
        return ret;
    }

    public static <T> ComparisonContext<T> defCompCtx() {
        return CompCtx.DEFAULT;
    }

    public static enum CompCtx implements ComparisonContext<Comparable<Object>>
    {
        DEFAULT{

            @Override
            public int hash(@Nullable Comparable<Object> o) {
                return o == null ? 0 : o.hashCode();
            }

            @Override
            public int compare(Comparable<Object> o1, Comparable<Object> o2) {
                return Equator.doCompare(o1, o2);
            }
        };

    }
}

