/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.collections.ImMap;
import org.organicdesign.fp.collections.ImSet;
import org.organicdesign.fp.collections.ImSortedMap;
import org.organicdesign.fp.collections.ImSortedSet;
import org.organicdesign.fp.collections.MutList;
import org.organicdesign.fp.collections.MutMap;
import org.organicdesign.fp.collections.MutSet;
import org.organicdesign.fp.collections.PersistentHashMap;
import org.organicdesign.fp.collections.PersistentHashSet;
import org.organicdesign.fp.collections.PersistentTreeMap;
import org.organicdesign.fp.collections.PersistentTreeSet;
import org.organicdesign.fp.collections.PersistentVector;
import org.organicdesign.fp.collections.RrbTree;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.tuple.Tuple2;
import org.organicdesign.fp.tuple.Tuple3;
import org.organicdesign.fp.xform.Xform;

public final class StaticImports {
    private StaticImports() {
        throw new UnsupportedOperationException("No instantiation");
    }

    @SafeVarargs
    @NotNull
    public static <K, V> ImMap<K, V> map(Map.Entry<K, V> ... kvPairs) {
        if (kvPairs == null || kvPairs.length < 1) {
            return PersistentHashMap.empty();
        }
        return PersistentHashMap.of(Arrays.asList(kvPairs));
    }

    @SafeVarargs
    @NotNull
    public static <K, V> MutMap<K, V> mutableMap(Map.Entry<K, V> ... kvPairs) {
        PersistentHashMap.MutHashMap ret = PersistentHashMap.emptyMutable();
        if (kvPairs == null) {
            return ret;
        }
        for (Map.Entry<K, V> me : kvPairs) {
            if (me == null) continue;
            ret.assoc((Map.Entry)me);
        }
        return ret;
    }

    @SafeVarargs
    @NotNull
    public static <T> RrbTree.MutRrbt<T> mutableRrb(T ... items) {
        if (items == null || items.length < 1) {
            return RrbTree.emptyMutable();
        }
        return RrbTree.emptyMutable().concat(Arrays.asList(items));
    }

    @SafeVarargs
    @NotNull
    public static <T> MutSet<T> mutableSet(T ... items) {
        PersistentHashSet.MutHashSet ret = PersistentHashSet.emptyMutable();
        if (items == null) {
            return ret;
        }
        for (T t : items) {
            ret.put(t);
        }
        return ret;
    }

    @SafeVarargs
    @NotNull
    public static <T> MutList<T> mutableVec(T ... items) {
        PersistentVector.MutVector ret = PersistentVector.emptyMutable();
        if (items == null) {
            return ret;
        }
        for (T t : items) {
            ret.append(t);
        }
        return ret;
    }

    @SafeVarargs
    @NotNull
    public static <T> RrbTree.ImRrbt<T> rrb(T ... items) {
        if (items == null || items.length < 1) {
            return RrbTree.empty();
        }
        return StaticImports.mutableRrb(items).immutable();
    }

    @SafeVarargs
    @NotNull
    public static <T> ImSet<T> set(T ... items) {
        if (items == null || items.length < 1) {
            return PersistentHashSet.empty();
        }
        return PersistentHashSet.of(Arrays.asList(items));
    }

    @NotNull
    public static <K, V> ImSortedMap<K, V> sortedMap(Comparator<? super K> comp, Iterable<Map.Entry<K, V>> kvPairs) {
        return PersistentTreeMap.ofComp(comp, kvPairs);
    }

    @NotNull
    public static <K extends Comparable<K>, V> ImSortedMap<K, V> sortedMap(Iterable<Map.Entry<K, V>> kvPairs) {
        return PersistentTreeMap.of(kvPairs);
    }

    @NotNull
    public static <T> ImSortedSet<T> sortedSet(Comparator<? super T> comp, Iterable<T> elements) {
        return Xform.of(elements).toImSortedSet(comp);
    }

    @NotNull
    public static <T extends Comparable<T>> ImSortedSet<T> sortedSet(Iterable<T> items) {
        return PersistentTreeSet.of(items);
    }

    @NotNull
    public static <T, U> Tuple2<T, U> tup(T t, U u) {
        return Tuple2.of(t, u);
    }

    @NotNull
    public static <T, U, V> Tuple3<T, U, V> tup(T t, U u, V v) {
        return Tuple3.of(t, u, v);
    }

    @SafeVarargs
    @NotNull
    public static <T> ImList<T> vec(T ... items) {
        if (items == null || items.length < 1) {
            return PersistentVector.empty();
        }
        return StaticImports.mutableVec(items).immutable();
    }

    @NotNull
    public static <T> UnmodIterable<T> xform(@Nullable Iterable<T> iterable) {
        return Xform.of(iterable);
    }

    @SafeVarargs
    @NotNull
    public static <T> UnmodIterable<T> xformArray(T ... items) {
        return Xform.of(Arrays.asList(items));
    }

    @NotNull
    public static UnmodIterable<Character> xformChars(final @Nullable CharSequence seq) {
        return seq == null ? UnmodIterable.emptyUnmodIterable() : new UnmodIterable<Character>(){

            @Override
            @NotNull
            public UnmodIterator<Character> iterator() {
                return new UnmodIterator<Character>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < seq.length();
                    }

                    @Override
                    public Character next() {
                        int nextIdx = this.idx + 1;
                        Character c = Character.valueOf(seq.charAt(this.idx));
                        this.idx = nextIdx;
                        return c;
                    }
                };
            }
        };
    }
}

