# ORCID API v3.0 Guide

## Endpoints

- activities (read only)
- address
- biography (read only)
- distinction/distinctions
- education/educations
- email (read only)
- employment/employments
- external-identifiers
- funding/fundings
- invited-position/invited-positions
- keywords
- membership/memberships
- other-names
- peer-review/peer-reviews
- person (read only)
- personal-details (read only)
- qualification/qualifications
- record (read only)
- research-resource/research-resources
- researcher-urls
- service/services
- work/works

## XSDs and current state (all stable)
- [activities-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/activities-3.0.xsd)
**stable**
- [address-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/address-3.0.xsd)
**stable**
- [bulk-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/bulk-3.0.xsd)
**stable**
- [common-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/common_3.0/common-3.0.xsd)
**stable**
- [distinction-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/distinction-3.0.xsd)
**stable**
- [education-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/education-3.0.xsd)
**stable**
- [email-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/email-3.0.xsd)
**stable**
- [employment-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/employment-3.0.xsd)
**stable**
- [error-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/error-3.0.xsd)
**stable**
- [funding-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/funding-3.0.xsd)
**stable**
- [invited-position-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/invited-position-3.0.xsd)
**stable**
- [keyword-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/keyword-3.0.xsd)
**stable**
- [membership-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/membership-3.0.xsd)
**stable**
- [other-names-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/other-name-3.0.xsd)
**stable**
- [peer-review-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/peer-review-3.0.xsd)
**stable**
- [person-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/person-3.0.xsd)
**stable**
- [person-external-identifier-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/person-external-identifier-3.0.xsd)
**stable**
- [personal-details-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/personal-details-3.0.xsd)
**stable**
- [qualification-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/qualification-3.0.xsd)
**stable**
- [research-resource-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/research-resource-3.0.xsd)
**stable**
- [researcher-url-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/researcher-url-3.0.xsd)
**stable**
- [search-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/search-3.0.xsd)
**stable**
- [service-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/service-3.0.xsd)
**stable**
- [work-3.0.xsd](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/work-3.0.xsd)
**stable**

## Tutorials

- [General guide to the ORCID API](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web)
- [Tutorials for reading and writing to ORCID records](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web/tutorial)


## Changes from Version 2.1:

### JSON
- JSON enumerated types are now expressed in lowercase with dashes instead of underscores, matching the existing XML enums (ie *JOURNAL_ARTICLE* is now expressed as *journal-article*). This affects enums for visibility, locale, work types, contributor roles, citation types, external identifier relationship, funding types, peer review types, and peer review role

### Assertion Origin Source information
- Member clients can now generating tokens that allow another client to update an ORCID record on behalf of the original client. This process is described in the [Token Delegation tutorial](https://github.com/ORCID/ORCID-Source/blob/master/orcid-api-web/tutorial/token_delegation.md).
- Items added using token delegation have additional source fields *common:assertion-origin-client-id* and *common:assertion-origin-name*.
- Items added by clients associated with a Search and Link Wizard have the client listed as the source of the item and the user as the source of the assertion with the fields *common:assertion-origin-orcid* and *common:assertion-origin-orcid*

### Identifiers
- Addition of new identifier relationship *version-of*, which is intended to map works to identifiers of different versions and instances of the same work. Works with the same *version-of* identifier are grouped together.

### Activities external identifiers
- Addition of *common:external-id-normalized* for work and peer-review identifiers. The common:external-id-normalized field is a transient, system generated field which expresses the identifier in a standard format that is used for grouping. In general, normalized identifiers trim extraneous text such as the identifier type or the expression of the identifier as a url. Additional normalization is done based on the rules of the identifier type and may include setting all alpha characters to lower case,  or transforming spaces, dashes, periods and other characters that can be treated as equivalent. [See the full normalization rules](https://github.com/ORCID/ORCID-Source/tree/master/orcid-core/src/main/java/org/orcid/core/utils/v3/identifiers). Identifiers which can not be normalized will return a error message when reading them.

### Affiliations
- Addition of new affiliation sections: Distinction, Invited-position, Membership, Qualification, and Service in addition to the existing Education and Employment sections. For more information see [Affiliations tutorial](https://github.com/ORCID/ORCID-Source/blob/master/orcid-api-web/tutorial/affiliations.md)
- Summary information now available for each section including affiliation source, role-title, department-name, dates, organization and external-ids
- Addition of optional element *common:external-ids* for identifiers that apply to the affiliation itself (*common:disambiguated-organization-identifier* should continue to be be used for organizational identifiers)
- Grouping of affiliations using external-ids, including returning affiliations in the *activities:affiliation-group* tag when reading an entire section.
- *common:start-date* is required if *common:end-date* is provided
- Addition of optional element *common:url* for recording links about the affiliation
- Addition of optional element *common:external-ids* for recording identifiers for the affiliation
- Disambiguated organization identifier is now required and must be a valid Ringgold, FundRef, or GRID identifier
- Use of common namespace for *common:department-name*, *common:role-title* and *common:organization*

### Research-resources
- This new section of the ORCID record captures information about things that researchers use for their research which require a specific proposal process or credential to access, such as collections, equipment, infrastructure, and services. For more information see the [Research-resource tutorial](https://github.com/ORCID/ORCID-Source/blob/master/orcid-api-web/tutorial/research-resources.md).

### Works
- an external-id with a *self* relationship is now required when posting works
- *work:journal-title* field is returned with the work summary
- Addition of *common:external-id-normalized* when reading works for normalized work identifiers
- Use of common namespace for *common:url* replacing *work:url* and this field is now returned in the work summary
- Addition of *annotation*, *software* and *physical object* to the list of [supported work types](https://members.orcid.org/api/resources/work-types)
- work type *dissertation* has been migrated to *dissertation-thesis*

### Fundings
- Disambiguated organization identifier is now required and must be a valid Ringgold, FundRef, or GRID identifier
- Use of common namespace for *common:organization*, replacing *funding:organization*
- Use of common namespace for *common:url* replacing *funding:url* and this field is now returned in the funding summary
- *common:start-date* is required if *common:end-date* is provided

### Peer-review
- *reviewer-role* and *review-type* are returned with the peer-review summary
- Disambiguated organization identifier is now required and must be a valid Ringgold, FundRef, or GRID identifier
- Addition of *common:external-id-normalized* when reading peer-reviews for normalized peer-review identifiers
- Addition of *grant*, *contract*, *award*, *salary-award*, and *research-resource-proposal* to supported subject types

## Sample files:

- [read activities-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/activities-3.0.xml)
- [read address-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/address-3.0.xml)
- [write address-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/address-3.0.xml)
- [write bulk-work xml-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/bulk-work-3.0.xml)
- [write bulk-work-3.0.json](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/bulk-work-3.0.json)
- [read biography-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/biography-3.0.xml)
- [distinction-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/distinction-3.0.xml)
- [write distinction-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/distinction-3.0.xml)
- [read distinctions-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/distinctions-3.0.xml)
- [read education-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/education-3.0.xml)
- [write education-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/education-3.0.xml)
- [read educations-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/educations-3.0.xml)
- [read email-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/email-3.0.xml)
- [read emails-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/emails-3.0.xml)
- [read employment-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/employment-3.0.xml)
- [write employment-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/employment-3.0.xml)
- [read employments-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/employments-3.0.xml)
- [error-message-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/error-3.0.xml)
- [read external-identifier-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/external-identifier-3.0.xml)
- [write external-identifier-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/external-identifier-3.0.xml)
- [read external-identifiers-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/external-identifiers-3.0.xml)
- [read funding-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/funding-3.0.xml)
- [write funding-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/funding-3.0.xml)
- [read fundings-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/fundings-3.0.xml)
- [read invited-position-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/invited-position-3.0.xml)
- [write invited-position-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/invited-position-3.0.xml)
- [read invited-positions-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/invited-positions-3.0.xml)
- [read keyword-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/keyword-3.0.xml)
- [write keyword-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/keyword-3.0.xml)
- [read keywords-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/keywords-3.0.xml)
- [read membership-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/membership-3.0.xml)
- [write membership-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/membership-3.0.xml)
- [read memberships-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/memberships-3.0.xml)
- [read other-name-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/other-name-3.0.xml)
- [write other-name-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/other-name-3.0.xml)
- [read other-names-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/other-names-3.0.xml)
- [read peer-review-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/peer-review-3.0.xml)
- [write full peer-review-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/peer-review-full-3.0.xml)
- [write simple peer-review-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/peer-review-simple-3.0.xml)
- [read peer-reviews-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/peer-reviews-3.0.xml)
- [read person-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/person-3.0.xml)
- [read personal-details-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/personal-details-3.0.xml)
- [read qualification-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/qualification-3.0.xml)
- [write qualification-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/qualification-3.0.xml)
- [read qualifications-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/qualification-3.0.xml)
- [read research-resource-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/research-resource-3.0.xml)
- [write research-resource-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/research-resource-3.0.xml)
- [read research-resources-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/research-resource-3.0.xml)
- [read researcher-url-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/researcher-url-3.0.xml)
- [write researcher-url-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/researcher-url-3.0.xml)
- [read researcher-urls-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/researcher-urls-3.0.xml)
- [search-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/search-3.0.xml)
- [read service-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/service-3.0.xml)
- [write service-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/service-3.0.xml)
- [read services-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/services-3.0.xml)
- [read work-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/work-3.0.xml)
- [write full work-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/work-full-3.0.xml)
- [write simple work-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/write_samples/work-simple-3.0.xml)
- [read works-3.0.xml](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/works-3.0.xml)

For working with json see [ORCID conversion util](https://github.com/ORCID/orcid-conversion-lib)

## REST API Reference

### API Tutorials
- [General guide to the ORCID API](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web)
- [Tutorials for reading and writing to ORCID records](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web/tutorial)

### Swagger

The swagger interfaces to the API available at:
- [member](https://api.orcid.org/v3.0/)
- [public](https://pub.orcid.org/v3.0/)

### Scopes
| Scope           | Request method | Obtain Access Token Through	| Expires In | API  |
|-----------------|-------------|--------------------------|----------------------------------|-------------|
| /authenticate     | GET| [3-legged OAuth](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web#authenticating-users-and-using-oauth--openid-connect)| When expired or revoked by user | Public API and Member API   |
| /activities/update     |POST, PUT, DELETE| [3-legged OAuth](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web#authenticating-users-and-using-oauth--openid-connect)| When expired or revoked by user | Member API   |
| /person/update     |POST, PUT, DELETE| [3-legged OAuth](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web#authenticating-users-and-using-oauth--openid-connect)| When expired or revoked by user | Member API   |
| /read-limited     |GET| [3-legged OAuth](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web#authenticating-users-and-using-oauth--openid-connect)| When expired or revoked by user | Member API   |
| /read-public     |GET| [Client credentials](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web#generate-a-two-step-read-public-access-token) | When revoked by ORCID | Public API and Member API  |
| /webhook     |PUT, DELETE| [Client credentials](https://github.com/ORCID/ORCID-Source/tree/master/orcid-api-web#generate-a-two-step-read-public-access-token) | When revoked by ORCID | Premium Member API  |
| openid  | GET | [OpenID Connect 1.0](https://github.com/ORCID/ORCID-Source/blob/master/orcid-web/ORCID_AUTH_WITH_OPENID_CONNECT.md) | When expired or revoked by user | Public API and Member API  |

Multiple scopes can be requested with a single access token by listing the requested scopes with a space between each in the authorization URL.


### Calls
| Action                   | HTTP method | Scope                    | URL                                                      |
|-------------------------|-------------|--------------------------|----------------------------------------------------------|
| Read the entire record | GET       | /read-limited or /read-public | https://[HOST]/v3.0/[ORCID]/record |
| Read an activities section | GET | /read-limited or /read-public | https://[HOST]/v3.0/[ORCID]/[SECTION]s |
| Read a person section | GET | /read-limited or /read-public | https://[HOST]/v3.0/[ORCID]/[SECTION] |
| Read a single item   | GET         | /read-limited or /read-public | https://[HOST]/v3.0/[ORCID]/[SECTION]/[PUT-CODE] |
| Add a person item    | POST        | /person/update       		 | https://[HOST]/v3.0/[ORCID]/[SECTION]            |
| Update a person item | PUT         | /person/update  				 | https://[HOST]/v3.0/[ORCID]/[SECTION]/[PUT-CODE] |
| Delete a person item | DELETE      | /person/update				 | https://[HOST]/v3.0/[ORCID]/[SECTION]/[PUT-CODE] |
| Add an activity    | POST          | /activities/update       | https://[HOST]/[ORCID]/[SECTION]            |
| Update an activity | PUT           | /activities/update       | https://[HOST]/v3.0/[ORCID]/[SECTION]/[PUT-CODE] |
| Delete an activity | DELETE        | /activities/update       | https://[HOST]/v3.0/[ORCID]/[SECTION]/[PUT-CODE] |
| Add multiple works| POST           | /read-limited or /read-public | https://[HOST]/v3.0/[ORCID]/works		             |
| Read multiple works| GET          | /activities/update       | https://[HOST]/v3.0/[ORCID]/works/[PUT-CODE1],[PUT-CODE2]  |
| Search records     | GET         | /read-public      	      | https://[HOST]/v3.0/search?q=[SOLR-QUERY]*          	 |

[HOST] is the ORCID environment you are using
- api.sandbox.orcid.org for the Member API on the ORCID Sandbox
- pub.sandbox.orcid.org for the Public API on the ORCID Sandbox (/read-public scope only)
- api.orcid.org for the Member API on the production ORCID Registry
- pub.orcid.org for the Public API on the production ORCID Registry (/read-public scope only)

[ORCID] is the ORCID iD for the record.

[SECTION] can be one of the following:
- activities
- address
- biography *
- distinction
- education
- email *
- employment
- external-identifiers
- funding
- invited-position
- keywords
- membership
- other-names
- peer-review
- person *
- personal-details *
- qualification
- research-resource
- researcher-urls
- service
- work

**Notes:**
- biography, email, person and personal-details sections are read only
- when reading and posting multiple works a maximum of 100 works can be accessed with a single call.
- When searching by default a maximum of 100 results will be returned. The `rows` parameter can be used to increase the number or results, but only up to 200. The `start` parameter (integer pointing to the zero-based position of the first result to be returned) can be used to page through larger results sets. See [Searching the API tutorial](https://github.com/ORCID/ORCID-Source/blob/master/orcid-api-web/tutorial/search.md)

## OpenID Connect
In addition to the REST API, ORCID Supports [OpenID Connect](https://github.com/ORCID/ORCID-Source/blob/master/orcid-web/ORCID_AUTH_WITH_OPENID_CONNECT.md) and an [Implicit workflow](https://github.com/ORCID/ORCID-Source/blob/master/orcid-web/ORCID_AUTH_WITH_OPENID_CONNECT.md#implicit-flow).

## Examples

### Read sections

| Item               |Scope               | Example cURL Statement                                         |
|--------------------|--------------------------|----------------------------------------------------------------|
| Entire record | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/record'```|
| Activities summary | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/activities'```|
| Addresses			 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/address'```|
| Distinction summary    | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/distinctions'```|
| Education summary    | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/educations'```|
| Emails     		 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/email'```|
| Employment summary   | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/employments'```|
| External identifiers	| /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/external-identifiers'```|
| Funding summary    | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/fundings'```|
| Invited position summary    | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/invited-position'```|
| Keywords     		 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/keywords'```|
| Membership summary    		 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/memberships'```|
| Other names     	 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/other-names'```|
| Peer review summary| /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/peer-reviews'```|
| Personal details	 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/personal-details'```|
| Person			 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/person'```|
| Qualification summary			 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/qualifications'```|
| Research-resource summary			 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/research-resources'```|
| Researcher URLs    | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/researcher-urls'```|
| Service summary             | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/services'```|
| Works summary             | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/works'```|


### Read Record Items
| Item               |Scope               | Example cURL Statement                                         |
|--------------------|--------------------------|----------------------------------------------------------------|
| Address			 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/address/4556'```|
| Biography			 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/biography'```|
| Distinction          | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/distinction/29770'```|
| Education          | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/education/22423'```|
| Employment         | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/employment/22411'```|
| External identifier| /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/external-identifiers/3193'```|
| Funding            | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/funding/4413'```|
| Invited position            | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/invited-position/29778'```|
| Keyword     		 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/keywords/4504'```|
| Membership     		 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/membership/29779'```|
| Other names     	 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/other-names/15812'```|
| Peer review        | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/peer-review/1374'```|
| Qualification        | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/peer-review/29769'```|
| Research-resource        | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/research-resource/1000'```|
| Researcher URL     | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/researcher-urls/41387'```|
| Service     		 | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/service/29773'```|
| Work               | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/work/733536'```|
| Multiple Works     | /read-limited or /read-public|```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/works/733535,733536'```|

When reading multiple works the contents of each work is returned or an error code is returned if there is an issue with a single work.


### Add Record Items
|Item    |Scope       | Example cURL Statement  |
|---------|----------------|-------------------------|
| Address	|/person/update           |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/address.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/address```|
| Distinction  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/distinction-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/distinction' ```|
| Education  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/education-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/education' ```|
| Employment |  /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/employment-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/employment' ```|
| External identifiers	| /person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/external_identifier.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/external-identifiers```|
| Funding  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/funding-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/funding'```|
| Invited position  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/invited-position-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/invited-position'```|
| Keywords     	|/person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/keyword.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/keywords```|
| Membership     	|/person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/membership-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/membership ```|
| Other names  |/person/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/other-name.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/other-names'```|
| Peer review  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/peer-review-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/peer-review'```|
| Qualification  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/qualification-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/qualification'```|
| Research-resource  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/qualification-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/research-resource'```|
| Researcher URL  |/person/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/researcher-url.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/researcher-urls'```|
| Service  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/service-item.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/service'```|
| Work  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/work.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/work'```|
| Multiple works |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/works.xml' -X POST 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/works'```|

When posting multiple works the contents of each work is returned or an error code is returned if there is an issue with a single work, see [bulk work error sample](https://github.com/ORCID/orcid-model/blob/master/src/main/resources/record_3.0/samples/read_samples/bulk-work-error.xml).

### Update Record Items
|Item  |Scope  | Example cURL Statement  |
|------|----------------|---------------------|
| Address	|/person/update       |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/address.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/address/[PUT-CODE]```|
| Distinction |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/distinction-item-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/distinction/[PUT-CODE]' ```|
| Education  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/education-item-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/education/[PUT-CODE]' ```|
| Employment |  /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/employment-item-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/employment/[PUT-CODE]' ```|
| External identifiers	|/person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/external_identifier.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/external-identifiers/[PUT-CODE]```|
| Funding  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/funding-item-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/funding/[PUT-CODE]'```|
| Invited position  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/invited-position-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/invited-position/[PUT-CODE]'```|
| Keywords     	|/person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/keyword.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/keywords/[PUT-CODE]```|
| Membership  |/activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/membership-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/membership/[PUT-CODE]'```|
| Other names  |/person/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/other-name.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/other-names/[PUT-CODE]'```|
| Peer review  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/peer-review-item-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/peer-review/[PUT-CODE]'```|
| Qualification  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/qualification-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/qualification/[PUT-CODE]'```|
| Research-resource  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/qualification-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/research-resource/[PUT-CODE]'```|
| Researcher URL  |/person/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/researcher-url.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/researcher-urls/[PUT-CODE]'```|
| Service  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/service-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/service/[PUT-CODE]'```|
| Work  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -d '@[FILE-PATH]/work-updated.xml' -X PUT 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/work/[PUT-CODE]'```|

When updating a record item, include the put code as an attribute in the root element, ex: ```<education:education put-code="14775" xmlns:common="http://www.orcid.org/ns/common" xmlns:education="http://www.orcid.org/ns/education" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.orcid.org/ns/education ../education-3.0.xsd ">```

### Delete Record Items
|Item  | Scope      | Example cURL Statement  |
|------|----------------|-------------------------|
| Address	| /person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/address/[PUT-CODE]```|
| Distinction  | /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/distinction/[PUT-CODE]'  ```|
| Education  | /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/education/[PUT-CODE]'  ```|
| Employment |  /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/employment/[PUT-CODE]' ```|
| External identifiers	| /person/update    |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/external-identifiers/[PUT-CODE]```|
| Funding  | /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/funding/[PUT-CODE]'```|
| Invited Position  | /activities/update  |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/invited-position/[PUT-CODE]'```|
| Keywords     	| /person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/keywords/[PUT-CODE]```|
| Membership     	| /person/update            |```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/membership/[PUT-CODE]```|
| Other names  | /person/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/researcher-urls/[PUT-CODE]'```|
| Peer review  | /activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/peer-review/[PUT-CODE]'```|
| Qualifiation  | /activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/qualification/[PUT-CODE]'```|
| Research-resource  | /activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/research-resource/[PUT-CODE]'```|
| Researcher URL  | /person/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/researcher-urls/[PUT-CODE]'```|
| Service  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/service/[PUT-CODE]'```|
| Work  |/activities/update|```curl -i -H 'Content-type: application/vnd.orcid+xml' -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'https://api.sandbox.orcid.org/v3.0/0000-0002-9227-8514/work/[PUT-CODE]'```|

### Webhooks
|Item  | Scope      | Example cURL Statement  |
|------|----------------|-------------------------|
| Register a webhook	| /webhook|```curl -v -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X PUT 'http://api.sandbox.orcid.org/0000-0002-9227-8514/webhook/http%3A%2F%2Fencoded.url%2F0000-0002-9227-8514'```|
| Delete a webhook  	| /webhook |```curl -v -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' -X DELETE 'http://api.sandbox.orcid.org/0000-0002-9227-8514/webhook/http%3A%2F%2Fencoded.url%2F0000-0002-9227-8514'  ```|

### Search
| Item               | Scope               |  Example cURL Statement                                         |
|--------------------|--------------------------|-------------------------------------------------------|
| Search records     | /read-public             | ```curl -i -H "Accept: application/vnd.orcid+xml" -H 'Authorization: Bearer dd91868d-d29a-475e-9acb-bd3fdf2f43f4' 'https://api.sandbox.orcid.org/v3.0/search?q=Simpson'```|
