/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.model.utils;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d+)(?:-(\\d+))?(?:-(\\d+))?(T\\d\\d:\\d\\d:\\d\\d)?");
    private static DatatypeFactory dataTypeFactory;
    private static Map<String, String> seasonsAndQuartersToMonth;

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(String dateString) {
        return DateUtils.convertToXMLGregorianCalendar(dateString, true);
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(String dateString, boolean tidy) {
        String tidyDateString = dateString;
        if (tidy) {
            tidyDateString = DateUtils.tidy(dateString);
        }
        if (tidyDateString == null) {
            return null;
        }
        DatatypeFactory dataTypeFactory = DateUtils.createDataTypeFactory();
        try {
            return dataTypeFactory.newXMLGregorianCalendar(tidyDateString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(long time) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(time);
        return DateUtils.convertToXMLGregorianCalendar(gregorianCalendar);
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(GregorianCalendar gregorianCalendar) {
        return DateUtils.createDataTypeFactory().newXMLGregorianCalendar(gregorianCalendar);
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.convertToXMLGregorianCalendar(date.getTime());
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendarNoTimeZoneNoMillis(Date date) {
        XMLGregorianCalendar basicCalender = DateUtils.convertToXMLGregorianCalendar(date);
        basicCalender.setTimezone(Integer.MIN_VALUE);
        basicCalender.setMillisecond(Integer.MIN_VALUE);
        return basicCalender;
    }

    public static Date convertToDate(String dateString) {
        String tidyDateString = DateUtils.tidy(dateString);
        if (tidyDateString == null) {
            return null;
        }
        return DateUtils.convertToXMLGregorianCalendar(tidyDateString).toGregorianCalendar().getTime();
    }

    public static Date convertToDate(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        return xmlGregorianCalendar.toGregorianCalendar().getTime();
    }

    private static String tidy(String dateString) {
        if (dateString == null) {
            return null;
        }
        Matcher matcher = DATE_PATTERN.matcher(dateString);
        if (!matcher.matches()) {
            return null;
        }
        String year = matcher.group(1);
        String month = matcher.group(2);
        String day = matcher.group(3);
        String time = matcher.group(4);
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.leftPad((String)year, (int)4, (char)'0'));
        if (month != null) {
            builder.append('-');
            month = DateUtils.mapSeasonsAndQuartersToMonth(month);
            builder.append(StringUtils.leftPad((String)month, (int)2, (char)'0'));
        }
        if (day != null) {
            builder.append('-');
            builder.append(StringUtils.leftPad((String)day, (int)2, (char)'0'));
        }
        if (time != null) {
            builder.append(time);
        }
        return builder.toString();
    }

    public static boolean olderThan(Date date, int days) {
        return date.getTime() < new Date().getTime() - (long)(days * 24 * 60 * 60 * 1000);
    }

    private static String mapSeasonsAndQuartersToMonth(String month) {
        if (seasonsAndQuartersToMonth.containsKey(month)) {
            return seasonsAndQuartersToMonth.get(month);
        }
        return month;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DatatypeFactory createDataTypeFactory() {
        if (dataTypeFactory != null) return dataTypeFactory;
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            if (dataTypeFactory != null) return dataTypeFactory;
            try {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException("Couldn't create org.orcid.test.data type factory", e);
            }
            return dataTypeFactory;
        }
    }

    static {
        seasonsAndQuartersToMonth = new HashMap<String, String>();
        seasonsAndQuartersToMonth.put("21", "03");
        seasonsAndQuartersToMonth.put("22", "06");
        seasonsAndQuartersToMonth.put("23", "09");
        seasonsAndQuartersToMonth.put("24", "12");
        seasonsAndQuartersToMonth.put("31", "01");
        seasonsAndQuartersToMonth.put("32", "04");
        seasonsAndQuartersToMonth.put("33", "07");
        seasonsAndQuartersToMonth.put("34", "10");
    }
}

