/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.v3.release.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.common.adapters.RelationshipAdapter;
import org.orcid.jaxb.model.message.WorkExternalIdentifier;
import org.orcid.jaxb.model.v3.release.common.TransientError;
import org.orcid.jaxb.model.v3.release.common.TransientNonEmptyString;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.GroupAble;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"type", "value", "normalized", "normalizedError", "url", "relationship"})
@ApiModel(value="ExternalIDV3_0")
public class ExternalID
implements GroupAble,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="external-id-type", namespace="http://www.orcid.org/ns/common", required=true)
    protected String type;
    @XmlElement(name="external-id-value", namespace="http://www.orcid.org/ns/common", required=true)
    protected String value;
    @XmlElement(name="external-id-normalized", namespace="http://www.orcid.org/ns/common")
    protected TransientNonEmptyString normalized;
    @XmlElement(name="external-id-normalized-error", namespace="http://www.orcid.org/ns/common")
    protected TransientError normalizedError;
    @XmlElement(name="external-id-url", namespace="http://www.orcid.org/ns/common")
    protected Url url;
    @XmlJavaTypeAdapter(value=RelationshipAdapter.class)
    @XmlElement(name="external-id-relationship", namespace="http://www.orcid.org/ns/common")
    @ApiModelProperty(dataType="string", allowableValues="part-of, self, version-of")
    protected Relationship relationship;
    @JsonIgnore
    @XmlTransient
    protected TransientNonEmptyString normalizedUrl;
    @JsonIgnore
    @XmlTransient
    protected TransientError normalizedUrlError;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TransientNonEmptyString getNormalized() {
        return this.normalized;
    }

    public void setNormalized(TransientNonEmptyString normalized) {
        this.normalized = normalized;
    }

    public TransientError getNormalizedError() {
        return this.normalizedError;
    }

    public void setNormalizedError(TransientError normalizeError) {
        this.normalizedError = normalizeError;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public TransientNonEmptyString getNormalizedUrl() {
        return this.normalizedUrl;
    }

    public void setNormalizedUrl(TransientNonEmptyString normalizedUrl) {
        this.normalizedUrl = normalizedUrl;
    }

    public TransientError getNormalizedUrlError() {
        return this.normalizedUrlError;
    }

    public void setNormalizedUrlError(TransientError normalizedUrlError) {
        this.normalizedUrlError = normalizedUrlError;
    }

    @Override
    @JsonIgnore
    public String getGroupId() {
        String workIdVal = null;
        workIdVal = this.getNormalized() != null && !StringUtils.isEmpty((String)this.getNormalized().getValue()) ? this.getNormalized().getValue() : (this.value == null ? null : this.value);
        String typeVal = this.type == null ? null : this.type;
        return workIdVal + typeVal;
    }

    @Override
    @JsonIgnore
    public boolean isGroupAble() {
        if (Relationship.PART_OF.equals(this.relationship) || Relationship.FUNDED_BY.equals(this.relationship)) {
            return false;
        }
        return this.getValue() != null && !this.getValue().isEmpty();
    }

    public static ExternalID fromMessageExtId(WorkExternalIdentifier oldExtId) {
        ExternalID id = new ExternalID();
        id.setType(oldExtId.getWorkExternalIdentifierType().value());
        id.setValue(oldExtId.getWorkExternalIdentifierId().getContent());
        return id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = this.getNormalized() != null && !StringUtils.isEmpty((String)this.getNormalized().getValue()) ? 31 * result + this.getNormalized().hashCode() : 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalID other = (ExternalID)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.getNormalized() != null && !StringUtils.isEmpty((String)this.getNormalized().getValue()) ? !this.getNormalized().equals(other.getNormalized()) : (this.value == null ? other.value != null : !this.value.equals(other.value)));
    }

    public ExternalID clone() {
        ExternalID id = new ExternalID();
        id.type = this.getType();
        id.value = this.getValue();
        if (this.getNormalized() != null) {
            id.setNormalized(this.getNormalized());
        }
        if (this.getNormalizedError() != null) {
            id.setNormalizedError(this.getNormalizedError());
        }
        if (this.getUrl() != null) {
            id.url = new Url(this.getUrl().getValue());
        }
        if (this.getRelationship() != null) {
            id.relationship = this.getRelationship();
        }
        if (this.getNormalizedUrl() != null) {
            id.setNormalizedUrl(this.getNormalizedUrl());
        }
        if (this.getNormalizedUrlError() != null) {
            id.setNormalizedUrlError(this.getNormalizedUrlError());
        }
        return id;
    }

    public String toString() {
        return "ExternalID [type=" + this.type + ", value=" + this.value + ", normalized=" + this.normalized + ", normalizedError=" + this.normalizedError + ", url=" + this.url + ", relationship=" + this.relationship + ", normalizedUrl=" + this.normalizedUrl + ", normalizedUrlError=" + this.normalizedUrlError + "]";
    }
}

