/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.v3.release.common;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.orcid.jaxb.model.v3.release.common.SourceClientId;
import org.orcid.jaxb.model.v3.release.common.SourceName;
import org.orcid.jaxb.model.v3.release.common.SourceOrcid;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"sourceOrcid", "sourceClientId", "sourceName", "assertionOriginOrcid", "assertionOriginClientId", "assertionOriginName"})
@XmlRootElement(name="source", namespace="http://www.orcid.org/ns/common")
@ApiModel(value="SourceV3_0")
public class Source
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="source-orcid", namespace="http://www.orcid.org/ns/common")
    protected SourceOrcid sourceOrcid;
    @XmlElement(name="source-client-id", namespace="http://www.orcid.org/ns/common")
    protected SourceClientId sourceClientId;
    @XmlElement(name="source-name", namespace="http://www.orcid.org/ns/common")
    protected SourceName sourceName;
    @XmlElement(name="assertion-origin-orcid", namespace="http://www.orcid.org/ns/common")
    protected SourceOrcid assertionOriginOrcid;
    @XmlElement(name="assertion-origin-client-id", namespace="http://www.orcid.org/ns/common")
    protected SourceClientId assertionOriginClientId;
    @XmlElement(name="assertion-origin-name", namespace="http://www.orcid.org/ns/common")
    protected SourceName assertionOriginName;

    public Source() {
    }

    public Source(String amenderOrcidPath) {
        SourceOrcid so = new SourceOrcid();
        so.setPath(amenderOrcidPath);
        this.sourceOrcid = so;
    }

    @Deprecated
    public SourceOrcid getSourceOrcid() {
        return this.sourceOrcid;
    }

    public void setSourceOrcid(SourceOrcid value) {
        this.sourceOrcid = value;
    }

    @Deprecated
    public SourceClientId getSourceClientId() {
        return this.sourceClientId;
    }

    public void setSourceClientId(SourceClientId sourceClientId) {
        this.sourceClientId = sourceClientId;
    }

    public SourceName getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(SourceName value) {
        this.sourceName = value;
    }

    public SourceOrcid getAssertionOriginOrcid() {
        return this.assertionOriginOrcid;
    }

    public void setAssertionOriginOrcid(SourceOrcid assertionOriginOrcid) {
        this.assertionOriginOrcid = assertionOriginOrcid;
    }

    public SourceClientId getAssertionOriginClientId() {
        return this.assertionOriginClientId;
    }

    public void setAssertionOriginClientId(SourceClientId assertionOriginClientId) {
        this.assertionOriginClientId = assertionOriginClientId;
    }

    public SourceName getAssertionOriginName() {
        return this.assertionOriginName;
    }

    public void setAssertionOriginName(SourceName assertionOriginName) {
        this.assertionOriginName = assertionOriginName;
    }

    public String retrieveSourcePath() {
        if (this.sourceClientId != null) {
            return this.sourceClientId.getPath();
        }
        if (this.sourceOrcid != null) {
            return this.sourceOrcid.getPath();
        }
        return null;
    }

    public String retrieveAssertionOriginPath() {
        if (this.assertionOriginClientId != null) {
            return this.assertionOriginClientId.getPath();
        }
        if (this.assertionOriginOrcid != null) {
            return this.assertionOriginOrcid.getPath();
        }
        return null;
    }

    public String retriveSourceUri() {
        if (this.sourceClientId != null) {
            return this.sourceClientId.getUri();
        }
        if (this.sourceOrcid != null) {
            return this.sourceOrcid.getUri();
        }
        return null;
    }

    public String retriveAssertionOriginUri() {
        if (this.assertionOriginClientId != null) {
            return this.assertionOriginClientId.getUri();
        }
        if (this.assertionOriginOrcid != null) {
            return this.assertionOriginOrcid.getUri();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertionOriginClientId == null ? 0 : this.assertionOriginClientId.hashCode());
        result = 31 * result + (this.assertionOriginOrcid == null ? 0 : this.assertionOriginOrcid.hashCode());
        result = 31 * result + (this.sourceClientId == null ? 0 : this.sourceClientId.hashCode());
        result = 31 * result + (this.sourceOrcid == null ? 0 : this.sourceOrcid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        if (this.assertionOriginClientId == null ? other.assertionOriginClientId != null : !this.assertionOriginClientId.equals(other.assertionOriginClientId)) {
            return false;
        }
        if (this.assertionOriginOrcid == null ? other.assertionOriginOrcid != null : !this.assertionOriginOrcid.equals(other.assertionOriginOrcid)) {
            return false;
        }
        if (this.sourceClientId == null ? other.sourceClientId != null : !this.sourceClientId.equals(other.sourceClientId)) {
            return false;
        }
        return !(this.sourceOrcid == null ? other.sourceOrcid != null : !this.sourceOrcid.equals(other.sourceOrcid));
    }

    public static Source forClient(String clientId) {
        if (StringUtils.isEmpty((CharSequence)clientId)) {
            throw new IllegalArgumentException("Client ID cannot be null");
        }
        Source s = new Source();
        s.setSourceClientId(new SourceClientId(clientId));
        return s;
    }

    public static Source forClientWithClientOBO(String clientId, String oboId) {
        if (StringUtils.isEmpty((CharSequence)oboId)) {
            throw new IllegalArgumentException("Client OBO ID cannot be null");
        }
        Source s = Source.forClient(clientId);
        s.setAssertionOriginClientId(new SourceClientId(oboId));
        return s;
    }
}

