/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.record.summary_v2;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.orcid.jaxb.model.common_v2.Filterable;
import org.orcid.jaxb.model.common_v2.LastModifiedDate;
import org.orcid.jaxb.model.record.summary_v2.EducationSummary;
import org.orcid.jaxb.model.record.summary_v2.Educations;
import org.orcid.jaxb.model.record.summary_v2.EmploymentSummary;
import org.orcid.jaxb.model.record.summary_v2.Employments;
import org.orcid.jaxb.model.record.summary_v2.FundingGroup;
import org.orcid.jaxb.model.record.summary_v2.FundingSummary;
import org.orcid.jaxb.model.record.summary_v2.Fundings;
import org.orcid.jaxb.model.record.summary_v2.PeerReviewGroup;
import org.orcid.jaxb.model.record.summary_v2.PeerReviewSummary;
import org.orcid.jaxb.model.record.summary_v2.PeerReviews;
import org.orcid.jaxb.model.record.summary_v2.WorkGroup;
import org.orcid.jaxb.model.record.summary_v2.WorkSummary;
import org.orcid.jaxb.model.record.summary_v2.Works;
import org.orcid.jaxb.model.record.util.RecordUtil;
import org.orcid.jaxb.model.record_v2.ActivitiesContainer;
import org.orcid.jaxb.model.record_v2.Activity;
import org.orcid.jaxb.model.record_v2.Group;
import org.orcid.jaxb.model.record_v2.GroupableActivity;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"lastModifiedDate", "educations", "employments", "fundings", "peerReviews", "works"})
@XmlRootElement(name="activities-summary", namespace="http://www.orcid.org/ns/activities")
@ApiModel(value="ActivitiesSummaryV2_0")
public class ActivitiesSummary
implements Serializable,
ActivitiesContainer {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="last-modified-date", namespace="http://www.orcid.org/ns/common")
    protected LastModifiedDate lastModifiedDate;
    @XmlElement(name="educations", namespace="http://www.orcid.org/ns/activities")
    protected Educations educations;
    @XmlElement(name="employments", namespace="http://www.orcid.org/ns/activities")
    protected Employments employments;
    @XmlElement(name="fundings", namespace="http://www.orcid.org/ns/activities")
    protected Fundings fundings;
    @XmlElement(name="peer-reviews", namespace="http://www.orcid.org/ns/activities")
    protected PeerReviews peerReviews;
    @XmlElement(name="works", namespace="http://www.orcid.org/ns/activities")
    protected Works works;
    @XmlAttribute
    protected String path;

    public Educations getEducations() {
        return this.educations;
    }

    public void setEducations(Educations educations) {
        this.educations = educations;
    }

    public Employments getEmployments() {
        return this.employments;
    }

    public void setEmployments(Employments employments) {
        this.employments = employments;
    }

    public PeerReviews getPeerReviews() {
        if (this.peerReviews == null) {
            this.peerReviews = new PeerReviews();
        }
        return this.peerReviews;
    }

    public void setPeerReviews(PeerReviews peerReviews) {
        this.peerReviews = peerReviews;
    }

    public Works getWorks() {
        if (this.works == null) {
            this.works = new Works();
        }
        return this.works;
    }

    public void setWorks(Works works) {
        this.works = works;
    }

    public Fundings getFundings() {
        if (this.fundings == null) {
            this.fundings = new Fundings();
        }
        return this.fundings;
    }

    public void setFundings(Fundings fundings) {
        this.fundings = fundings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.educations == null ? 0 : this.educations.hashCode());
        result = 31 * result + (this.employments == null ? 0 : this.employments.hashCode());
        result = 31 * result + (this.fundings == null ? 0 : this.fundings.hashCode());
        result = 31 * result + (this.peerReviews == null ? 0 : this.peerReviews.hashCode());
        result = 31 * result + (this.works == null ? 0 : this.works.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivitiesSummary other = (ActivitiesSummary)obj;
        if (this.educations == null ? other.educations != null : !this.educations.equals(other.educations)) {
            return false;
        }
        if (this.employments == null ? other.employments != null : !this.employments.equals(other.employments)) {
            return false;
        }
        if (this.fundings == null ? other.fundings != null : !this.fundings.equals(other.fundings)) {
            return false;
        }
        if (this.peerReviews == null ? other.peerReviews != null : !this.peerReviews.equals(other.peerReviews)) {
            return false;
        }
        return !(this.works == null ? other.works != null : !this.works.equals(other.works));
    }

    public String toString() {
        return RecordUtil.convertToString(this);
    }

    @Override
    public Map<Long, ? extends Activity> retrieveActivitiesAsMap() {
        List<GroupableActivity> summaries;
        List<Group> groups;
        HashMap<Long, Filterable> activities = new HashMap<Long, Filterable>();
        if (this.works != null) {
            groups = this.works.getWorkGroup();
            for (WorkGroup workGroup : groups) {
                if (workGroup == null) continue;
                summaries = workGroup.getWorkSummary();
                for (WorkSummary workSummary : summaries) {
                    activities.put(workSummary.getPutCode(), workSummary);
                }
            }
        }
        if (this.peerReviews != null) {
            groups = this.peerReviews.getPeerReviewGroup();
            for (PeerReviewGroup peerReviewGroup : groups) {
                if (peerReviewGroup == null) continue;
                summaries = peerReviewGroup.getPeerReviewSummary();
                for (PeerReviewSummary peerReviewSummary : summaries) {
                    activities.put(peerReviewSummary.getPutCode(), peerReviewSummary);
                }
            }
        }
        if (this.fundings != null) {
            groups = this.fundings.getFundingGroup();
            for (FundingGroup fundingGroup : groups) {
                if (fundingGroup == null) continue;
                List<FundingSummary> fundings = fundingGroup.getFundingSummary();
                for (FundingSummary fundingSummary : fundings) {
                    activities.put(fundingSummary.getPutCode(), fundingSummary);
                }
            }
        }
        if (this.educations != null) {
            for (EducationSummary education : this.educations.getSummaries()) {
                activities.put(education.getPutCode(), education);
            }
        }
        if (this.employments != null) {
            for (EmploymentSummary employment : this.employments.getSummaries()) {
                activities.put(employment.getPutCode(), employment);
            }
        }
        return activities;
    }

    public List<? extends Activity> retrieveActivities() {
        return new ArrayList<Activity>(this.retrieveActivitiesAsMap().values());
    }

    public LastModifiedDate getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @Override
    public void setLastModifiedDate(LastModifiedDate lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

