/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.message;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public enum WorkType implements Serializable
{
    ARTISTIC_PERFORMANCE("artistic-performance"),
    BOOK_CHAPTER("book-chapter"),
    BOOK_REVIEW("book-review"),
    BOOK("book"),
    CONFERENCE_ABSTRACT("conference-abstract"),
    CONFERENCE_PAPER("conference-paper"),
    CONFERENCE_POSTER("conference-poster"),
    DATA_SET("data-set"),
    DICTIONARY_ENTRY("dictionary-entry"),
    DISCLOSURE("disclosure"),
    DISSERTATION("dissertation"),
    EDITED_BOOK("edited-book"),
    ENCYCLOPEDIA_ENTRY("encyclopedia-entry"),
    INVENTION("invention"),
    JOURNAL_ARTICLE("journal-article"),
    JOURNAL_ISSUE("journal-issue"),
    LECTURE_SPEECH("lecture-speech"),
    LICENSE("license"),
    MAGAZINE_ARTICLE("magazine-article"),
    MANUAL("manual"),
    NEWSLETTER_ARTICLE("newsletter-article"),
    NEWSPAPER_ARTICLE("newspaper-article"),
    ONLINE_RESOURCE("online-resource"),
    OTHER("other"),
    PATENT("patent"),
    REGISTERED_COPYRIGHT("registered-copyright"),
    REPORT("report"),
    RESEARCH_TECHNIQUE("research-technique"),
    RESEARCH_TOOL("research-tool"),
    SPIN_OFF_COMPANY("spin-off-company"),
    STANDARDS_AND_POLICY("standards-and-policy"),
    SUPERVISED_STUDENT_PUBLICATION("supervised-student-publication"),
    TECHNICAL_STANDARD("technical-standard"),
    TEST("test"),
    TRADEMARK("trademark"),
    TRANSLATION("translation"),
    WEBSITE("website"),
    WORKING_PAPER("working-paper"),
    UNDEFINED("undefined");

    private final String value;
    private static List<WorkType> publications;
    private static List<WorkType> conferences;

    private WorkType(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    @JsonValue
    public String jsonValue() {
        return this.name();
    }

    public static WorkType fromValue(String v) {
        for (WorkType c : WorkType.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public boolean isPublication() {
        return publications.contains(this);
    }

    public boolean isConference() {
        return conferences.contains(this);
    }

    static {
        publications = Lists.newArrayList((Object[])new WorkType[]{BOOK, BOOK_CHAPTER, BOOK_REVIEW, DICTIONARY_ENTRY, DISSERTATION, ENCYCLOPEDIA_ENTRY, EDITED_BOOK, JOURNAL_ARTICLE, JOURNAL_ISSUE, MAGAZINE_ARTICLE, MANUAL, ONLINE_RESOURCE, NEWSLETTER_ARTICLE, NEWSPAPER_ARTICLE, REPORT, RESEARCH_TOOL, SUPERVISED_STUDENT_PUBLICATION, TEST, TRANSLATION, WEBSITE, WORKING_PAPER});
        conferences = Lists.newArrayList((Object[])new WorkType[]{CONFERENCE_PAPER, CONFERENCE_ABSTRACT, CONFERENCE_POSTER});
    }
}

