/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.io.OptaPlannerXmlSerializationException;
import org.optaplanner.core.impl.io.jaxb.ElementNamespaceOverride;
import org.optaplanner.core.impl.io.jaxb.GenericJaxbIO;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkResultIO {
    private static final String SOLVER_CONFIG_XML_ELEMENT_NAME = "solverConfig";
    private static final String PLANNER_BENCHMARK_RESULT_FILENAME = "plannerBenchmarkResult.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkResultIO.class);
    private final GenericJaxbIO<PlannerBenchmarkResult> genericJaxbIO = new GenericJaxbIO(PlannerBenchmarkResult.class);

    public void writePlannerBenchmarkResult(File benchmarkReportDirectory, PlannerBenchmarkResult plannerBenchmarkResult) {
        File plannerBenchmarkResultFile = new File(benchmarkReportDirectory, PLANNER_BENCHMARK_RESULT_FILENAME);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(plannerBenchmarkResultFile), StandardCharsets.UTF_8);){
            this.write(plannerBenchmarkResult, writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed writing plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ").", e);
        }
    }

    public List<PlannerBenchmarkResult> readPlannerBenchmarkResultList(File benchmarkDirectory) {
        if (!benchmarkDirectory.exists() || !benchmarkDirectory.isDirectory()) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + benchmarkDirectory + ") does not exist or is not a directory.");
        }
        Object[] benchmarkReportDirectories = benchmarkDirectory.listFiles(File::isDirectory);
        if (benchmarkReportDirectories == null) {
            throw new IllegalStateException("Unable to list the subdirectories in the benchmarkDirectory (" + benchmarkDirectory.getAbsolutePath() + ").");
        }
        Arrays.sort(benchmarkReportDirectories);
        ArrayList<PlannerBenchmarkResult> plannerBenchmarkResultList = new ArrayList<PlannerBenchmarkResult>(benchmarkReportDirectories.length);
        for (Object benchmarkReportDirectory : benchmarkReportDirectories) {
            File plannerBenchmarkResultFile = new File((File)benchmarkReportDirectory, PLANNER_BENCHMARK_RESULT_FILENAME);
            if (!plannerBenchmarkResultFile.exists()) continue;
            PlannerBenchmarkResult plannerBenchmarkResult = this.readPlannerBenchmarkResult(plannerBenchmarkResultFile);
            plannerBenchmarkResultList.add(plannerBenchmarkResult);
        }
        return plannerBenchmarkResultList;
    }

    protected PlannerBenchmarkResult readPlannerBenchmarkResult(File plannerBenchmarkResultFile) {
        PlannerBenchmarkResult plannerBenchmarkResult;
        if (!plannerBenchmarkResultFile.exists()) {
            throw new IllegalArgumentException("The plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ") does not exist.");
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(plannerBenchmarkResultFile), StandardCharsets.UTF_8);){
            plannerBenchmarkResult = this.read(reader);
        }
        catch (OptaPlannerXmlSerializationException e) {
            LOGGER.warn("Failed reading plannerBenchmarkResultFile ({}).", (Object)plannerBenchmarkResultFile, (Object)e);
            String benchmarkReportDirectoryName = plannerBenchmarkResultFile.getParentFile().getName();
            plannerBenchmarkResult = PlannerBenchmarkResult.createUnmarshallingFailedResult(benchmarkReportDirectoryName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed reading plannerBenchmarkResultFile (" + plannerBenchmarkResultFile + ").", e);
        }
        plannerBenchmarkResult.setBenchmarkReportDirectory(plannerBenchmarkResultFile.getParentFile());
        this.restoreOmittedBidirectionalFields(plannerBenchmarkResult);
        this.restoreOtherOmittedFields(plannerBenchmarkResult);
        return plannerBenchmarkResult;
    }

    protected PlannerBenchmarkResult read(Reader reader) {
        return (PlannerBenchmarkResult)this.genericJaxbIO.readOverridingNamespace(reader, new ElementNamespaceOverride[]{ElementNamespaceOverride.of((String)SOLVER_CONFIG_XML_ELEMENT_NAME, (String)"https://www.optaplanner.org/xsd/solver")});
    }

    protected void write(PlannerBenchmarkResult plannerBenchmarkResult, Writer writer) {
        this.genericJaxbIO.writeWithoutNamespaces((Object)plannerBenchmarkResult, writer);
    }

    private void restoreOmittedBidirectionalFields(PlannerBenchmarkResult plannerBenchmarkResult) {
        for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            problemBenchmarkResult.setPlannerBenchmarkResult(plannerBenchmarkResult);
            if (problemBenchmarkResult.getProblemStatisticList() == null) {
                problemBenchmarkResult.setProblemStatisticList(new ArrayList<ProblemStatistic>(0));
            }
            for (ProblemStatistic problemStatistic : problemBenchmarkResult.getProblemStatisticList()) {
                problemStatistic.setProblemBenchmarkResult(problemBenchmarkResult);
            }
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                singleBenchmarkResult.setProblemBenchmarkResult(problemBenchmarkResult);
            }
        }
        for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            solverBenchmarkResult.setPlannerBenchmarkResult(plannerBenchmarkResult);
            for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                singleBenchmarkResult.setSolverBenchmarkResult(solverBenchmarkResult);
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    if (subSingleBenchmarkResult.getPureSubSingleStatisticList() != null) continue;
                    subSingleBenchmarkResult.setPureSubSingleStatisticList(new ArrayList<PureSubSingleStatistic>(0));
                }
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    for (PureSubSingleStatistic pureSubSingleStatistic : subSingleBenchmarkResult.getPureSubSingleStatisticList()) {
                        pureSubSingleStatistic.setSubSingleBenchmarkResult(subSingleBenchmarkResult);
                    }
                }
            }
        }
    }

    private void restoreOtherOmittedFields(PlannerBenchmarkResult plannerBenchmarkResult) {
        for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
            SolverConfig solverConfig = solverBenchmarkResult.getSolverConfig();
            DefaultSolverFactory defaultSolverFactory = new DefaultSolverFactory(solverConfig);
            solverBenchmarkResult.setScoreDefinition(defaultSolverFactory.buildSolutionDescriptor(EnvironmentMode.REPRODUCIBLE).getScoreDefinition());
        }
    }
}

