/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.validationreport;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.models.ifc2x3tc1.IfcColourOrFactor;
import org.bimserver.models.ifc2x3tc1.IfcColourRgb;
import org.bimserver.models.ifc2x3tc1.IfcPresentationStyleAssignment;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcProductRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcStyledItem;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyle;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyleRendering;
import org.bimserver.validationreport.Header;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.IssueInterface;
import org.bimserver.validationreport.IssueValidationException;
import org.bimserver.validationreport.Item;
import org.bimserver.validationreport.Line;
import org.bimserver.validationreport.Type;

public class JsonValidationReport
implements IssueInterface {
    private final List<Item> items = new ArrayList<Item>();
    private final Map<String, Boolean> checkResults = new HashMap<String, Boolean>();

    @Override
    public void addHeader(String value) {
        this.items.add(new Header(value));
    }

    public String toHtml(String header, String footer) {
        StringBuilder sb = new StringBuilder();
        sb.append(header);
        for (Item item : this.items) {
            item.toHtml(sb);
        }
        sb.append(footer);
        return sb.toString();
    }

    public ObjectNode toJson(ObjectMapper objectMapper) {
        ObjectNode result = objectMapper.createObjectNode();
        ArrayNode itemsJson = objectMapper.createArrayNode();
        ObjectNode checks = objectMapper.createObjectNode();
        result.set("checks", (JsonNode)checks);
        result.set("items", (JsonNode)itemsJson);
        for (Item item : this.items) {
            itemsJson.add((JsonNode)item.toJson(objectMapper));
        }
        for (String identifier : this.checkResults.keySet()) {
            checks.put(identifier, this.checkResults.get(identifier));
        }
        return result;
    }

    public void applyToModel(IfcModelInterface model) throws IfcModelInterfaceException {
        for (Item item : this.items) {
            IfcProductRepresentation productRepresentation;
            float transparency;
            double[] colors;
            IdEObject idEObject;
            Line line;
            if (!(item instanceof Line) || (line = (Line)item).getOid() == -1L || !((idEObject = model.get(line.getOid())) instanceof IfcProduct)) continue;
            IfcProduct product = (IfcProduct)idEObject;
            if (line.getType() == Type.SUCCESS) {
                colors = new double[]{0.2, 0.2, 0.2};
                transparency = 0.98f;
            } else {
                colors = new double[]{1.0, 0.0, 0.0};
                transparency = 0.0f;
            }
            if ((productRepresentation = product.getRepresentation()) == null) continue;
            for (IfcRepresentation representation : productRepresentation.getRepresentations()) {
                IfcStyledItem styledItem = (IfcStyledItem)model.create(IfcStyledItem.class);
                if (representation.getItems().isEmpty()) continue;
                representation.getItems().set(0, (Object)styledItem);
                IfcPresentationStyleAssignment presentationStyleAssignment = (IfcPresentationStyleAssignment)model.create(IfcPresentationStyleAssignment.class);
                styledItem.getStyles().add((Object)presentationStyleAssignment);
                IfcSurfaceStyle surfaceStyle = (IfcSurfaceStyle)model.create(IfcSurfaceStyle.class);
                presentationStyleAssignment.getStyles().add((Object)surfaceStyle);
                IfcSurfaceStyleRendering surfaceStyleRendering = (IfcSurfaceStyleRendering)model.create(IfcSurfaceStyleRendering.class);
                surfaceStyle.getStyles().add((Object)surfaceStyleRendering);
                IfcColourRgb colourRgb = (IfcColourRgb)model.create(IfcColourRgb.class);
                colourRgb.setRed(colors[0]);
                colourRgb.setGreen(colors[1]);
                colourRgb.setBlue(colors[2]);
                surfaceStyleRendering.setDiffuseColour((IfcColourOrFactor)colourRgb);
                surfaceStyleRendering.setReflectionColour((IfcColourOrFactor)colourRgb);
                surfaceStyleRendering.setSpecularColour((IfcColourOrFactor)colourRgb);
                surfaceStyleRendering.setSurfaceColour(colourRgb);
                surfaceStyleRendering.setTransmissionColour((IfcColourOrFactor)colourRgb);
                surfaceStyleRendering.setTransparency((double)transparency);
            }
        }
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void add(Type messageType, String type, String guid, long oid, String key, String is, String shouldBe) {
        this.items.add(new Line(messageType, oid, key, is, shouldBe));
    }

    @Override
    public void add(Type messageType, String type, String guid, Long oid, String key, Object is, String shouldBe) {
        this.items.add(new Line(messageType, oid, key, is == null ? "" : is.toString(), shouldBe));
    }

    @Override
    public void add(Type messageType, String message, Object is, String shouldBe) throws IssueException {
        this.add(messageType, null, null, null, message, is, shouldBe);
    }

    @Override
    public byte[] getBytes() {
        ObjectMapper objectMapper = new ObjectMapper();
        return this.toJson(objectMapper).toString().getBytes(Charsets.UTF_8);
    }

    @Override
    public void validate() throws IssueValidationException {
    }

    @Override
    public void setCheckValid(String identifier, boolean valid) {
        this.checkResults.put(identifier, valid);
    }
}

