/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils;

import java.util.Stack;
import org.bimserver.utils.TokenizeException;

public class Tokenizer {
    private final String input;
    private int leftPositionInclude;
    private int rightPositionInclude;
    private Stack<Pair> zoomStack = new Stack();

    public Tokenizer(String input) {
        this.input = input;
        this.leftPositionInclude = 0;
        this.rightPositionInclude = input.length() - 1;
    }

    public String toString() {
        return this.input.substring(this.leftPositionInclude, this.rightPositionInclude + 1);
    }

    public Tokenizer zoomIn(String startChar, String endChar) throws TokenizeException {
        String trimmed = this.toString().trim();
        if (!trimmed.startsWith(startChar)) {
            throw new TokenizeException("No '" + startChar + "' found in '" + this.input.substring(this.leftPositionInclude, this.rightPositionInclude) + "'");
        }
        String specialChar = "'";
        int leftIndex = this.input.indexOf(startChar, this.leftPositionInclude);
        int rightIndex = -1;
        int depth = 0;
        int altDepth = 0;
        for (int i = leftIndex + 1; i <= this.rightPositionInclude; ++i) {
            String c = this.input.substring(i, i + endChar.length());
            if (c.equals(endChar)) {
                if (depth == 0 && altDepth == 0) {
                    rightIndex = i;
                    break;
                }
                if (altDepth != 0) continue;
                --depth;
                continue;
            }
            if (c.equals(specialChar)) {
                altDepth = 1 - altDepth;
                continue;
            }
            if (!c.equals(startChar) || altDepth != 0) continue;
            ++depth;
        }
        if (rightIndex == -1 || rightIndex < this.leftPositionInclude) {
            throw new TokenizeException("No '" + endChar + "' found in '" + this.input.substring(this.leftPositionInclude, this.rightPositionInclude) + "'");
        }
        this.zoomStack.push(new Pair(endChar, this.rightPositionInclude));
        this.leftPositionInclude = leftIndex + startChar.length();
        this.rightPositionInclude = rightIndex - endChar.length();
        return this;
    }

    public Tokenizer readComma() throws TokenizeException {
        String toString = this.toString();
        String x = toString.trim();
        if (!x.startsWith(",")) {
            throw new TokenizeException("No comma at starting index in " + x);
        }
        int offset = toString.indexOf(",");
        this.leftPositionInclude += offset + 1;
        return this;
    }

    public String readSingleQuoted() throws TokenizeException {
        String toString = this.toString();
        String trimmed = toString.trim();
        if (!trimmed.startsWith("'")) {
            throw new TokenizeException("No opening \"'\" found in " + trimmed);
        }
        int add = toString.indexOf("'");
        int endIndex = trimmed.indexOf("'", 1);
        int lastEndIndex = -2;
        while (trimmed.length() > endIndex + 1 && trimmed.charAt(endIndex + 1) == '\'') {
            endIndex = trimmed.indexOf("'", endIndex + 2);
            if (lastEndIndex != -2 && lastEndIndex == endIndex) {
                throw new TokenizeException("No closing \"'\" found in " + trimmed);
            }
            lastEndIndex = endIndex;
        }
        if (endIndex == -1) {
            throw new TokenizeException("No closing \"'\" found in " + trimmed);
        }
        this.leftPositionInclude += endIndex + add + 1;
        return trimmed.substring(1, endIndex);
    }

    public void shouldBeFinished() throws TokenizeException {
    }

    public void zoomOut() throws TokenizeException {
        Pair pair = this.zoomStack.pop();
        String trimmed = this.input.substring(this.leftPositionInclude, pair.oldRight + 1).trim();
        String x = trimmed.substring(0, pair.rightChar.length());
        int offset = this.input.indexOf(pair.rightChar, this.leftPositionInclude);
        if (!x.equals(pair.rightChar)) {
            throw new TokenizeException(pair.rightChar + " expected, got " + x);
        }
        this.leftPositionInclude = offset + pair.rightChar.length();
        this.rightPositionInclude = pair.oldRight;
    }

    public String readAll() {
        String substring = this.input.substring(this.leftPositionInclude, this.rightPositionInclude + 1);
        this.leftPositionInclude = this.rightPositionInclude + 1;
        return substring;
    }

    public boolean isEmpty() {
        return this.toString().trim().isEmpty();
    }

    public boolean nextIsAComma() throws TokenizeException {
        String toString = this.toString();
        String x = toString.trim();
        return x.startsWith(",");
    }

    public boolean startsWith(String string) {
        return this.toString().trim().startsWith(string);
    }

    public boolean nextIsDollar() {
        String toString = this.toString();
        String x = toString.trim();
        return x.startsWith("$");
    }

    public Tokenizer readDollar() throws TokenizeException {
        String toString = this.toString();
        String x = toString.trim();
        if (!x.startsWith("$")) {
            throw new TokenizeException("No dollar at starting index in " + x);
        }
        int offset = toString.indexOf("$");
        this.leftPositionInclude += offset + 1;
        return this;
    }

    private static class Pair {
        public int oldRight;
        public String rightChar;

        public Pair(String rightChar, int oldRight) {
            this.rightChar = rightChar;
            this.oldRight = oldRight;
        }
    }
}

