/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Licenser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Licenser.class);
    private int same;
    private int changed;
    private int skipped;

    public static void main(String[] args) {
        new Licenser().start();
    }

    private void start() {
        File workspace = new File("../").getAbsoluteFile();
        for (File project : workspace.listFiles()) {
            this.processProject(project);
        }
        this.processProject(new File("C:\\Git\\BuildingSMARTLibrary\\BuildingSMARTLibrary"));
        this.processProject(new File("C:\\Git\\BinarySerializers\\BinarySerializers"));
        this.processProject(new File("C:\\Git\\CityGML\\CityGML"));
        this.processProject(new File("C:\\Git\\Collada\\Collada"));
        this.processProject(new File("C:\\Git\\Mergers\\Mergers"));
        this.processProject(new File("C:\\Git\\JavaQueryEngine\\JavaQueryEngine"));
        this.processProject(new File("C:\\Git\\JavaModelChecker\\JavaModelChecker"));
        this.processProject(new File("C:\\Git\\Charting\\Charting"));
        System.out.println("Unchanged: " + this.same);
        System.out.println("Changed: " + this.changed);
        System.out.println("Skipped: " + this.skipped);
    }

    private void processProject(File project) {
        String license;
        File srcFolder;
        if (!project.getName().startsWith(".") && (srcFolder = new File(project, "src")).exists() && (license = Licenser.getCommentedLicenseText(new File(project, "license.txt"))) != null) {
            this.process(srcFolder, license);
        }
    }

    private void process(File srcFolder, String license) {
        for (File file : srcFolder.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().startsWith(".")) continue;
                this.process(file, license);
                continue;
            }
            if (!file.getName().endsWith(".java") || file.getName().equals("Licenser.java")) continue;
            this.processFile(file, license);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCommentedLicenseText(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            String content = FileUtils.readFileToString((File)file);
            StringBuilder newContent = new StringBuilder();
            try (Scanner scanner = new Scanner(content);){
                newContent.append("/******************************************************************************\n");
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    newContent.append(" * " + line + "\n");
                }
                newContent.append(" *****************************************************************************/");
            }
            return newContent.toString();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    private void processFile(File file, String license) {
        try {
            String content = FileUtils.readFileToString((File)file);
            int indexOfPackageStart = content.indexOf("package ");
            if (indexOfPackageStart != -1) {
                int indexOfPackageEnd = content.indexOf(";", indexOfPackageStart + 1);
                int indexOfFirstImport = content.indexOf("import ", indexOfPackageEnd);
                if (indexOfFirstImport != -1 && content.substring(indexOfFirstImport - 2, indexOfFirstImport).equals("//")) {
                    indexOfFirstImport -= 2;
                }
                if (indexOfFirstImport == -1) {
                    int indexOfFirstPublic = content.indexOf("public ", indexOfPackageEnd);
                    int indexOfFirstPrivate = content.indexOf("private ", indexOfPackageEnd);
                    if (indexOfFirstPublic != -1 && indexOfFirstPrivate != -1) {
                        indexOfFirstImport = indexOfFirstPublic < indexOfFirstPrivate ? indexOfFirstPublic : indexOfFirstPrivate;
                    } else if (indexOfFirstPrivate != -1) {
                        indexOfFirstImport = indexOfFirstPrivate;
                    } else if (indexOfFirstPublic != -1) {
                        indexOfFirstImport = indexOfFirstPublic;
                    }
                }
                if (indexOfFirstImport != -1) {
                    String first = content.substring(0, indexOfPackageEnd + 1);
                    String second = content.substring(indexOfFirstImport);
                    String total = first + "\n\n" + license + "\n\n" + second;
                    if (total.equals(content)) {
                        ++this.same;
                    } else {
                        ++this.changed;
                    }
                    FileUtils.writeStringToFile((File)file, (String)total);
                } else {
                    ++this.skipped;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

