/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils;

import java.util.Formatter;
import java.util.GregorianCalendar;
import org.bimserver.utils.BinUtils;

public class Formatters {
    private Formatters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bytesToString(long bytes) {
        try (Formatter formatter = new Formatter();){
            if (bytes > 1024L) {
                if (bytes > 0x100000L) {
                    if (bytes > 0x40000000L) {
                        if (bytes > 0x10000000000L) {
                            String string = formatter.format("%9.2f", Float.valueOf((float)bytes / 1.0995116E12f)) + " TB";
                            return string;
                        }
                        String string = formatter.format("%9.2f", Float.valueOf((float)bytes / 1.0737418E9f)) + " GB";
                        return string;
                    }
                    String string = formatter.format("%9.2f", Float.valueOf((float)bytes / 1048576.0f)) + " MB";
                    return string;
                }
                String string = formatter.format("%9.2f", Float.valueOf((float)bytes / 1024.0f)) + " KB";
                return string;
            }
            String string = "" + bytes + " B";
            return string;
        }
    }

    public static final String timeSpanToString(GregorianCalendar startGc, GregorianCalendar stopGc) {
        long millis = stopGc.getTimeInMillis() - startGc.getTimeInMillis();
        return millis / 60000L + " minutes";
    }

    public static final String millisecondsToString(long millis) {
        if (millis < 1000L) {
            return millis + "ms";
        }
        if (millis < 60000L) {
            return millis / 1000L + "s";
        }
        if (millis < 3600000L) {
            long m = millis / 60000L;
            long s = millis % 60000L / 1000L;
            return Formatters.addBefore(m, 2, "0") + "m " + Formatters.addBefore(s, 2, "0") + "s";
        }
        if (millis < 86400000L) {
            long h = millis / 3600000L;
            long m = millis % 3600000L / 60000L;
            return Formatters.addBefore(h, 2, "0") + "h " + Formatters.addBefore(m, 2, "0") + "m";
        }
        long d = millis / 86400000L;
        long u = millis % 86400000L;
        return d + "d " + Formatters.addBefore(u, 2, "0") + "h";
    }

    private static String addAfter(long value, int zeros, String c) {
        String result = String.valueOf(value);
        while (result.length() < zeros) {
            result = result + c;
        }
        return result;
    }

    private static String addBefore(long value, int zeros, String c) {
        String result = String.valueOf(value);
        while (result.length() < zeros) {
            result = c + result;
        }
        return result;
    }

    private static void check(long millis, String result) {
        if (Formatters.millisecondsToString(millis).equals(result)) {
            System.out.println("OK  ");
        } else {
            System.err.println("ERR: format(" + millis + ") !equals (" + result + ") but (" + Formatters.millisecondsToString(millis) + ")");
        }
    }

    public static void main(String[] args) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar before = new GregorianCalendar();
        before.add(6, -60);
        System.out.println(before.getTime());
        System.out.println(Formatters.timeSpanToString(before, now));
    }

    public static String formatNanoSeconds(long l) {
        return l / 1000000L + " ms";
    }

    public static void dumpKey(String tableName, byte[] key) {
        if (key.length != 16) {
            return;
        }
        byte[] pidBytes = new byte[4];
        byte[] oidBytes = new byte[8];
        byte[] ridBytes = new byte[4];
        System.arraycopy(key, 0, pidBytes, 0, 4);
        System.arraycopy(key, 4, oidBytes, 0, 8);
        System.arraycopy(key, 12, ridBytes, 0, 4);
        int pid = BinUtils.byteArrayToInt(pidBytes);
        long oid = BinUtils.byteArrayToLong(oidBytes);
        int rid = BinUtils.byteArrayToInt(ridBytes);
        System.out.println(tableName + ", pid: " + pid + ", oid: " + oid + ", rid: " + rid);
    }
}

