/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.pb;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ServiceException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.shared.ConnectDisconnectListener;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketProtocolBuffersChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketProtocolBuffersChannel.class);
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private DataOutputStream dataOutputStream;
    private final Set<ConnectDisconnectListener> connectDisconnectListeners = new HashSet<ConnectDisconnectListener>();
    private TokenHolder tokenHolder;

    public SocketProtocolBuffersChannel(TokenHolder tokenHolder) {
        this.tokenHolder = tokenHolder;
    }

    public void connect(InetSocketAddress address) throws IOException {
        this.socket = new Socket(address.getAddress(), address.getPort());
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.dataOutputStream = new DataOutputStream(this.outputStream);
        this.notifyOfConnect();
    }

    public Message callBlockingMethod(ProtocolBuffersMetaData.MethodDescriptorContainer methodDescriptor, Message request) throws ServiceException {
        try {
            this.dataOutputStream.writeUTF(methodDescriptor.getServiceDescriptorContainer().getName());
            this.dataOutputStream.writeUTF(methodDescriptor.getName());
            this.dataOutputStream.writeUTF(this.tokenHolder.getToken() == null ? "" : this.tokenHolder.getToken());
            request.writeDelimitedTo((OutputStream)this.dataOutputStream);
            this.dataOutputStream.flush();
            DynamicMessage response = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)methodDescriptor.getOutputDescriptor());
            DynamicMessage.Builder responseBuilder = response.newBuilderForType();
            responseBuilder.mergeDelimitedFrom(this.inputStream);
            return responseBuilder.build();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public void notifyOfConnect() {
        for (ConnectDisconnectListener connectDisconnectListener : this.connectDisconnectListeners) {
            connectDisconnectListener.connected();
        }
    }

    public void notifyOfDisconnect() {
        for (ConnectDisconnectListener connectDisconnectListener : this.connectDisconnectListeners) {
            connectDisconnectListener.disconnected();
        }
    }

    public void registerConnectDisconnectListener(ConnectDisconnectListener connectDisconnectListener) {
        this.connectDisconnectListeners.add(connectDisconnectListener);
    }

    public void disconnect() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.notifyOfDisconnect();
    }
}

