/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.io.IOUtils;
import org.bimserver.shared.meta.SBase;
import org.bimserver.shared.meta.SClass;
import org.bimserver.shared.meta.SField;
import org.bimserver.shared.pb.ConvertException;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.utils.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBuffersConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolBuffersConverter.class);
    private final ProtocolBuffersMetaData protocolBuffersMetaData;

    public ProtocolBuffersConverter(ProtocolBuffersMetaData protocolBuffersMetaData) {
        this.protocolBuffersMetaData = protocolBuffersMetaData;
    }

    public SBase convertProtocolBuffersMessageToSObject(Message message, SBase newInstance, SClass sClass) throws ConvertException {
        try {
            Descriptors.Descriptor descriptor = message.getDescriptorForType();
            if (newInstance == null) {
                newInstance = sClass.newInstance();
            }
            Message subTypeMessage = null;
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                if (fieldDescriptor.getName().equals("__actual_type")) {
                    sClass = sClass.getServicesMap().getSType((String)message.getField(fieldDescriptor));
                    newInstance = sClass.newInstance();
                    continue;
                }
                if (fieldDescriptor.getName().startsWith("__")) {
                    if (!fieldDescriptor.getName().substring(2).equals(sClass.getSimpleName())) continue;
                    subTypeMessage = (Message)message.getField(fieldDescriptor);
                    continue;
                }
                Object val = message.getField(fieldDescriptor);
                SField field = newInstance.getSClass().getField(fieldDescriptor.getName());
                if (field == null) {
                    throw new ConvertException("No field on " + sClass.getName() + " with name " + fieldDescriptor.getName());
                }
                if (fieldDescriptor.isRepeated()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (val instanceof List) {
                        List oldList = (List)val;
                        for (Object x : oldList) {
                            list.add(this.convertFieldValue(field, x));
                        }
                    } else if (val instanceof DynamicMessage) {
                        int size = message.getRepeatedFieldCount(fieldDescriptor);
                        for (int index = 0; index < size; ++index) {
                            Object repeatedField = message.getRepeatedField(fieldDescriptor, index);
                            list.add(this.convertFieldValue(field, repeatedField));
                        }
                    } else {
                        throw new ConvertException("Field " + sClass.getName() + "." + fieldDescriptor.getName() + " should have list value");
                    }
                    newInstance.sSet(field, list);
                    continue;
                }
                SField sField = sClass.getField(fieldDescriptor.getName());
                newInstance.sSet(sField, this.convertFieldValue(sField, val));
            }
            if (subTypeMessage != null) {
                this.convertProtocolBuffersMessageToSObject(subTypeMessage, newInstance, sClass);
            }
            return newInstance;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    private Object convertFieldValue(SField field, Object val) throws ConvertException {
        if (val instanceof Descriptors.EnumValueDescriptor) {
            Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)val;
            try {
                Class<?> enumClass = Class.forName("org.bimserver.interfaces.objects." + enumValueDescriptor.getType().getName());
                for (Object v : enumClass.getEnumConstants()) {
                    Enum e = (Enum)v;
                    if (e.ordinal() != enumValueDescriptor.getNumber()) continue;
                    val = e;
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
            return val;
        }
        if (field.getType().getInstanceClass() == Date.class) {
            return new Date((Long)val);
        }
        if (field.getType().getInstanceClass() == DataHandler.class) {
            ByteString byteString = (ByteString)val;
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource("test", byteString.toByteArray());
            return new DataHandler((DataSource)byteArrayDataSource);
        }
        if (val instanceof DynamicMessage) {
            return this.convertProtocolBuffersMessageToSObject((Message)((DynamicMessage)val), null, field.isAggregate() ? field.getGenericType() : field.getType());
        }
        return val;
    }

    public Message convertSObjectToProtocolBuffersObject(SBase object, SClass definedType) throws ConvertException {
        SClass sClass;
        DynamicMessage.Builder builder = null;
        ProtocolBuffersMetaData.MessageDescriptorContainer messageDescriptor = this.protocolBuffersMetaData.getMessageDescriptor(definedType.getSimpleName());
        if (messageDescriptor == null) {
            throw new ConvertException("No message descriptor found with name " + definedType.getSimpleName());
        }
        Descriptors.Descriptor definedDescriptor = messageDescriptor.getDescriptor();
        try {
            builder = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)definedDescriptor).newBuilderForType();
        }
        catch (SecurityException e) {
            throw new ConvertException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ConvertException(e);
        }
        SClass superClass = sClass = object.getSClass();
        while (superClass.getSuperClass() != null && superClass.getSuperClass().getInstanceClass() != Object.class) {
            superClass = superClass.getSuperClass();
        }
        if (sClass != superClass && messageDescriptor.getField("__actual_type") != null) {
            builder.setField(messageDescriptor.getField("__actual_type"), (Object)sClass.getSimpleName());
            builder.setField(messageDescriptor.getField("__" + sClass.getSimpleName()), (Object)this.convertSObjectToProtocolBuffersObject(object, sClass));
        }
        for (SField field : definedType.getAllFields()) {
            try {
                Object value = object.sGet(field);
                Descriptors.FieldDescriptor fieldDescriptor = messageDescriptor.getField(field.getName());
                if (value == null) continue;
                if (value.getClass().isPrimitive() || value.getClass() == String.class || value.getClass() == Long.class || value.getClass() == Double.class || value.getClass() == Integer.class || value.getClass() == Boolean.class) {
                    builder.setField(fieldDescriptor, value);
                    continue;
                }
                if (value.getClass().isEnum()) {
                    Enum eNum = (Enum)value;
                    int ordinal = eNum.ordinal();
                    Descriptors.EnumValueDescriptor findValueByNumber = fieldDescriptor.getEnumType().findValueByNumber(ordinal);
                    builder.setField(fieldDescriptor, (Object)findValueByNumber);
                    continue;
                }
                if (value.getClass() == Date.class) {
                    builder.setField(fieldDescriptor, (Object)((Date)value).getTime());
                    continue;
                }
                if (value.getClass() == DataHandler.class) {
                    DataHandler dataHandler = (DataHandler)value;
                    InputStream inputStream = dataHandler.getInputStream();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                    ByteString byteString = ByteString.copyFrom((byte[])byteArrayOutputStream.toByteArray());
                    builder.setField(fieldDescriptor, (Object)byteString);
                    continue;
                }
                if (List.class.isAssignableFrom(value.getClass())) {
                    List list = (List)value;
                    ArrayList<Object> newList = new ArrayList<Object>();
                    for (Object o : list) {
                        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            newList.add(this.convertSObjectToProtocolBuffersObject((SBase)o, field.getGenericType()));
                            continue;
                        }
                        newList.add(o);
                    }
                    builder.setField(fieldDescriptor, newList);
                    continue;
                }
                LOGGER.error("Unimplemented: " + fieldDescriptor.getName() + ": " + value);
            }
            catch (SecurityException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return builder.build();
    }

    protected Class<?> getJavaType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BOOLEAN) {
            return Boolean.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BYTE_STRING) {
            return DataHandler.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.DOUBLE) {
            return Double.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.FLOAT) {
            return Float.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.INT) {
            return Integer.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.LONG) {
            return Long.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.STRING) {
            return String.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            try {
                return Class.forName("org.bimserver.interfaces.objects." + fieldDescriptor.getEnumType().getName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    protected Class<?> getJavaPrimitiveType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BOOLEAN) {
            return Boolean.TYPE;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BYTE_STRING) {
            return DataHandler.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.DOUBLE) {
            return Double.TYPE;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.FLOAT) {
            return Float.TYPE;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.INT) {
            return Integer.TYPE;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.LONG) {
            return Long.TYPE;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.STRING) {
            return String.class;
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            try {
                return Class.forName("org.bimserver.interfaces.objects." + fieldDescriptor.getEnumType().getName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }
}

