/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.json;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.json.JsonReflector;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.ReflectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSocketReflector
extends JsonReflector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSocketReflector.class);
    private final String remoteAddress;
    private final HttpClient httpclient;
    private final HttpContext context;
    private TokenHolder tokenHolder;

    public JsonSocketReflector(HttpClient httpclient, SServicesMap servicesMap, String remoteAddress, TokenHolder tokenHolder) {
        super(servicesMap);
        this.httpclient = httpclient;
        this.remoteAddress = remoteAddress;
        this.tokenHolder = tokenHolder;
        this.context = new BasicHttpContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonObject call(JsonObject request) throws ReflectorException {
        try {
            if (this.tokenHolder.getToken() != null) {
                request.addProperty("token", this.tokenHolder.getToken());
            }
            HttpPost httppost = new HttpPost(this.remoteAddress);
            httppost.setHeader("Content-Type", "application/json");
            httppost.setEntity((HttpEntity)new StringEntity(request.toString(), Charsets.UTF_8));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(request.toString());
            }
            HttpResponse response = this.httpclient.execute((HttpUriRequest)httppost, this.context);
            try {
                if (response.getStatusLine().getStatusCode() != 200) throw new ReflectorException("Call unsuccessful, status code: " + response.getStatusLine().getStatusCode() + " (" + response.getStatusLine().getReasonPhrase() + ")");
                HttpEntity resultEntity = response.getEntity();
                JsonParser parser = new JsonParser();
                if (LOGGER.isDebugEnabled()) {
                    JsonObject resultObject;
                    InputStream inputStream = resultEntity.getContent();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                    LOGGER.debug(new String(byteArrayOutputStream.toByteArray(), Charsets.UTF_8));
                    JsonObject jsonObject = resultObject = (JsonObject)parser.parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), Charsets.UTF_8));
                    return jsonObject;
                }
                JsonObject jsonObject = (JsonObject)parser.parse((Reader)new InputStreamReader(resultEntity.getContent(), Charsets.UTF_8));
                return jsonObject;
            }
            finally {
                httppost.releaseConnection();
            }
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
    }
}

