/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.bimserver.shared.exceptions.ErrorCode;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.json.JsonConverter;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.KeyValuePair;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.shared.reflector.ReflectorException;

public abstract class JsonReflector
implements Reflector {
    private final JsonConverter converter;
    private final SServicesMap servicesMap;

    public JsonReflector(SServicesMap servicesMap) {
        if (servicesMap == null) {
            throw new IllegalArgumentException("servicesMap cannot be null");
        }
        this.servicesMap = servicesMap;
        this.converter = new JsonConverter(servicesMap);
    }

    public Object callMethod(String interfaceName, String methodName, Class<?> definedReturnType, KeyValuePair ... args) throws ServerException, UserException, ReflectorException {
        try {
            JsonObject request = new JsonObject();
            request.add("interface", (JsonElement)new JsonPrimitive(interfaceName));
            request.add("method", (JsonElement)new JsonPrimitive(methodName));
            JsonObject parameters = new JsonObject();
            for (KeyValuePair arg : args) {
                parameters.add(arg.getFieldName(), this.converter.toJson(arg.getValue()));
            }
            request.add("parameters", (JsonElement)parameters);
            JsonObject requestObject = new JsonObject();
            requestObject.add("request", (JsonElement)request);
            JsonObject jsonResult = this.call(requestObject);
            if (!this.isOneWay()) {
                if (jsonResult == null) {
                    return null;
                }
                JsonObject response = jsonResult.getAsJsonObject("response");
                if (response.has("exception")) {
                    String message;
                    JsonObject exceptionJson = response.getAsJsonObject("exception");
                    String exceptionType = exceptionJson.get("__type").getAsString();
                    String string = message = exceptionJson.has("message") ? exceptionJson.get("message").getAsString() : "unknown";
                    if (exceptionType.equals(UserException.class.getSimpleName())) {
                        if (exceptionJson.has("errorCode")) {
                            throw new UserException(message, ErrorCode.parse((int)exceptionJson.get("errorCode").getAsInt()));
                        }
                        throw new UserException(message);
                    }
                    if (exceptionType.equals(ServerException.class.getSimpleName())) {
                        if (exceptionJson.has("errorCode")) {
                            throw new ServerException(message, ErrorCode.parse((int)exceptionJson.get("errorCode").getAsInt()));
                        }
                        throw new ServerException(message);
                    }
                    if (exceptionJson.has("errorCode")) {
                        throw new ServerException(message, ErrorCode.parse((int)exceptionJson.get("errorCode").getAsInt()));
                    }
                    throw new ServerException(message);
                }
                if (response.has("result")) {
                    JsonElement result = response.get("result");
                    SMethod method = this.servicesMap.getBySimpleName(interfaceName).getSMethod(methodName);
                    return this.converter.fromJson(method.getReturnType(), method.getGenericReturnType(), result);
                }
                return null;
            }
            return null;
        }
        catch (ReflectorException e) {
            throw e;
        }
        catch (UserException e) {
            throw e;
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
    }

    protected boolean isOneWay() {
        return false;
    }

    public abstract JsonObject call(JsonObject var1) throws ReflectorException;

    public void close() {
    }
}

