/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.json;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bimserver.plugins.serializers.CacheStoringEmfSerializerDataSource;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.shared.json.ConvertException;
import org.bimserver.shared.meta.SBase;
import org.bimserver.shared.meta.SClass;
import org.bimserver.shared.meta.SField;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.utils.ByteArrayDataSource;

public class JsonConverter {
    private final SServicesMap servicesMap;

    public JsonConverter(SServicesMap servicesMap) {
        this.servicesMap = servicesMap;
    }

    public void toJson(Object object, JsonWriter out) throws IOException, SerializerException {
        if (object instanceof SBase) {
            SBase base = (SBase)object;
            out.beginObject();
            out.name("__type");
            out.value(base.getSClass().getSimpleName());
            for (SField field : base.getSClass().getAllFields()) {
                out.name(field.getName());
                this.toJson(base.sGet(field), out);
            }
            out.endObject();
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            out.beginArray();
            for (Object value : collection) {
                this.toJson(value, out);
            }
            out.endArray();
        } else if (object instanceof Date) {
            out.value(((Date)object).getTime());
        } else if (object instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)object;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (dataHandler.getDataSource() instanceof CacheStoringEmfSerializerDataSource) {
                CacheStoringEmfSerializerDataSource cacheStoringEmfSerializerDataSource = (CacheStoringEmfSerializerDataSource)dataHandler.getDataSource();
                cacheStoringEmfSerializerDataSource.writeToOutputStream((OutputStream)baos, null);
                out.value(new String(Base64.encodeBase64((byte[])baos.toByteArray()), Charsets.UTF_8));
            } else {
                InputStream inputStream = dataHandler.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                out.value(new String(Base64.encodeBase64((byte[])baos.toByteArray()), Charsets.UTF_8));
            }
        } else if (object instanceof byte[]) {
            byte[] data = (byte[])object;
            out.value(new String(Base64.encodeBase64((byte[])data), Charsets.UTF_8));
        } else if (object instanceof String) {
            out.value((String)object);
        } else if (object instanceof Number) {
            out.value((Number)object);
        } else if (object instanceof Enum) {
            out.value(object.toString());
        } else if (object instanceof Boolean) {
            out.value(((Boolean)object).booleanValue());
        } else if (object == null) {
            out.nullValue();
        } else {
            throw new UnsupportedOperationException(object.toString());
        }
    }

    public JsonElement toJson(Object object) throws IOException {
        if (object instanceof SBase) {
            SBase base = (SBase)object;
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("__type", (JsonElement)new JsonPrimitive(base.getSClass().getSimpleName()));
            for (SField field : base.getSClass().getOwnFields()) {
                jsonObject.add(field.getName(), this.toJson(base.sGet(field)));
            }
            return jsonObject;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            JsonArray jsonArray = new JsonArray();
            for (Object value : collection) {
                jsonArray.add(this.toJson(value));
            }
            return jsonArray;
        }
        if (object instanceof Date) {
            return new JsonPrimitive((Number)((Date)object).getTime());
        }
        if (object instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)object;
            InputStream inputStream = dataHandler.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            return new JsonPrimitive(new String(Base64.encodeBase64((byte[])out.toByteArray()), Charsets.UTF_8));
        }
        if (object instanceof Boolean) {
            return new JsonPrimitive((Boolean)object);
        }
        if (object instanceof String) {
            return new JsonPrimitive((String)object);
        }
        if (object instanceof Long) {
            return new JsonPrimitive((Number)((Long)object));
        }
        if (object instanceof Integer) {
            return new JsonPrimitive((Number)((Integer)object));
        }
        if (object instanceof Double) {
            return new JsonPrimitive((Number)((Double)object));
        }
        if (object instanceof Enum) {
            return new JsonPrimitive(object.toString());
        }
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        if (object instanceof byte[]) {
            byte[] data = (byte[])object;
            return new JsonPrimitive(new String(Base64.encodeBase64((byte[])data), Charsets.UTF_8));
        }
        throw new UnsupportedOperationException(object.getClass().getName());
    }

    public Object fromJson(SClass definedType, SClass genericType, Object object) throws ConvertException, IOException {
        try {
            if (object instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)object;
                if (jsonObject.has("__type")) {
                    String type = jsonObject.get("__type").getAsString();
                    SClass sClass = this.servicesMap.getType(type);
                    SBase newObject = sClass.newInstance();
                    for (SField field : newObject.getSClass().getAllFields()) {
                        if (!jsonObject.has(field.getName())) continue;
                        newObject.sSet(field, this.fromJson(field.getType(), field.getGenericType(), jsonObject.get(field.getName())));
                    }
                    return newObject;
                }
                if (jsonObject.entrySet().size() != 0) {
                    throw new ConvertException("Missing __type field in " + jsonObject.toString());
                }
                return null;
            }
            if (object instanceof JsonArray) {
                JsonArray array = (JsonArray)object;
                if (definedType.isList()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        list.add(this.fromJson(definedType, genericType, array.get(i)));
                    }
                    return list;
                }
                if (definedType.isSet()) {
                    HashSet<Object> set = new HashSet<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        set.add(this.fromJson(definedType, genericType, array.get(i)));
                    }
                    return set;
                }
            } else {
                if (object instanceof JsonNull) {
                    return null;
                }
                if (definedType.isByteArray()) {
                    if (object instanceof JsonPrimitive) {
                        JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
                        return Base64.decodeBase64((byte[])jsonPrimitive.getAsString().getBytes(Charsets.UTF_8));
                    }
                } else if (definedType.isDataHandler()) {
                    if (object instanceof JsonPrimitive) {
                        JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
                        byte[] data = Base64.decodeBase64((byte[])jsonPrimitive.getAsString().getBytes(Charsets.UTF_8));
                        return new DataHandler((DataSource)new ByteArrayDataSource(null, data));
                    }
                } else if (definedType.isInteger()) {
                    if (object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsInt();
                    }
                } else if (definedType.isLong()) {
                    if (object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsLong();
                    }
                } else if (definedType.isEnum()) {
                    JsonPrimitive primitive = (JsonPrimitive)object;
                    for (Object enumConstantObject : definedType.getInstanceClass().getEnumConstants()) {
                        Enum enumConstant = (Enum)enumConstantObject;
                        if (!enumConstant.name().equals(primitive.getAsString())) continue;
                        return enumConstant;
                    }
                } else if (definedType.isDate()) {
                    if (object instanceof JsonPrimitive) {
                        return new Date(((JsonPrimitive)object).getAsLong());
                    }
                } else if (definedType.isString()) {
                    if (object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsString();
                    }
                    if (object instanceof JsonNull) {
                        return null;
                    }
                } else if (definedType.isBoolean()) {
                    if (object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsBoolean();
                    }
                } else if (definedType.isList()) {
                    if (genericType.isLong()) {
                        if (object instanceof JsonPrimitive) {
                            return ((JsonPrimitive)object).getAsLong();
                        }
                    } else if (genericType.isInteger()) {
                        if (object instanceof JsonPrimitive) {
                            return ((JsonPrimitive)object).getAsInt();
                        }
                    } else if (genericType.isString()) {
                        if (object instanceof JsonPrimitive) {
                            return ((JsonPrimitive)object).getAsString();
                        }
                    } else if (genericType.isDouble() && object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsDouble();
                    }
                } else if (definedType.isSet()) {
                    if (genericType.isLong()) {
                        if (object instanceof JsonPrimitive) {
                            return ((JsonPrimitive)object).getAsLong();
                        }
                    } else if (genericType.isInteger()) {
                        if (object instanceof JsonPrimitive) {
                            return ((JsonPrimitive)object).getAsInt();
                        }
                    } else if (genericType.isString() && object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsString();
                    }
                } else if (definedType.isDouble()) {
                    if (object instanceof JsonPrimitive) {
                        return ((JsonPrimitive)object).getAsDouble();
                    }
                } else if (definedType.isFloat()) {
                    if (object instanceof JsonPrimitive) {
                        return Float.valueOf(((JsonPrimitive)object).getAsFloat());
                    }
                } else if (definedType.isVoid()) {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new ConvertException(e);
        }
        throw new UnsupportedOperationException(object.toString());
    }
}

