/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.util.LinkedHashSet;
import java.util.Set;
import org.bimserver.interfaces.SServiceInterfaceService;
import org.bimserver.shared.CodeFetcher;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.LowLevelInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.NotificationRegistryInterface;
import org.bimserver.shared.interfaces.OAuthInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.interfaces.RemoteServiceInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.meta.SourceCodeFetcher;

public class InterfaceList {
    private static final Set<Class<? extends PublicInterface>> interfaces = new LinkedHashSet<Class<? extends PublicInterface>>();

    public static SServicesMap createSServicesMap() {
        SServicesMap servicesMap = new SServicesMap();
        CodeFetcher sourceCodeFetcher = new CodeFetcher();
        SServiceInterfaceService serviceInterface = new SServiceInterfaceService(servicesMap, (SourceCodeFetcher)sourceCodeFetcher, ServiceInterface.class);
        servicesMap.add((SService)serviceInterface);
        for (Class<? extends PublicInterface> clazz : InterfaceList.getInterfaces()) {
            if (clazz == ServiceInterface.class) continue;
            servicesMap.add(new SService(servicesMap, (SourceCodeFetcher)sourceCodeFetcher, clazz));
        }
        servicesMap.initialize();
        return servicesMap;
    }

    public static Set<Class<? extends PublicInterface>> getInterfaces() {
        return interfaces;
    }

    static {
        interfaces.add(ServiceInterface.class);
        interfaces.add(AdminInterface.class);
        interfaces.add(MetaInterface.class);
        interfaces.add(SettingsInterface.class);
        interfaces.add(AuthInterface.class);
        interfaces.add(PluginInterface.class);
        interfaces.add(NotificationInterface.class);
        interfaces.add(RemoteServiceInterface.class);
        interfaces.add(LowLevelInterface.class);
        interfaces.add(NotificationRegistryInterface.class);
        interfaces.add(OAuthInterface.class);
    }
}

