/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.util.UUID;
import org.bimserver.shared.Guid;

public class GuidCompressor {
    static char[] cConversionTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '$'};

    public static String getNewIfcGloballyUniqueId() {
        Guid guid = GuidCompressor.getGuidFromUncompressedString(UUID.randomUUID().toString());
        String shortString = GuidCompressor.getCompressedStringFromGuid(guid);
        return shortString;
    }

    private static Guid getGuidFromUncompressedString(String uncompressedGuidString) {
        String[] parts = uncompressedGuidString.split("-");
        Guid guid = new Guid();
        guid.Data1 = Long.parseLong(parts[0], 16);
        guid.Data2 = Integer.parseInt(parts[1], 16);
        guid.Data3 = Integer.parseInt(parts[2], 16);
        String temp = parts[3];
        guid.Data4[0] = (char)Integer.parseInt(temp.substring(0, 2), 16);
        guid.Data4[1] = (char)Integer.parseInt(temp.substring(2, 4), 16);
        temp = parts[4];
        guid.Data4[2] = (char)Integer.parseInt(temp.substring(0, 2), 16);
        guid.Data4[3] = (char)Integer.parseInt(temp.substring(2, 4), 16);
        guid.Data4[4] = (char)Integer.parseInt(temp.substring(4, 6), 16);
        guid.Data4[5] = (char)Integer.parseInt(temp.substring(6, 8), 16);
        guid.Data4[6] = (char)Integer.parseInt(temp.substring(8, 10), 16);
        guid.Data4[7] = (char)Integer.parseInt(temp.substring(10, 12), 16);
        return guid;
    }

    private static String getCompressedStringFromGuid(Guid guid) {
        long[] num = new long[6];
        char[][] str = new char[6][5];
        String result = new String();
        num[0] = guid.Data1 / 0x1000000L;
        num[1] = guid.Data1 % 0x1000000L;
        num[2] = guid.Data2 * 256 + guid.Data3 / 256;
        num[3] = guid.Data3 % 256 * 65536 + guid.Data4[0] * 256 + guid.Data4[1];
        num[4] = guid.Data4[2] * 65536 + guid.Data4[3] * 256 + guid.Data4[4];
        num[5] = guid.Data4[5] * 65536 + guid.Data4[6] * 256 + guid.Data4[7];
        int n = 3;
        for (int i = 0; i < 6; ++i) {
            if (!GuidCompressor.cv_to_64(num[i], str[i], n)) {
                return null;
            }
            for (int j = 0; j < str[i].length; ++j) {
                if (str[i][j] == '\u0000') continue;
                result = result + str[i][j];
            }
            n = 5;
        }
        return result;
    }

    private static boolean cv_to_64(long number, char[] code, int len) {
        char[] result = new char[5];
        if (len > 5) {
            return false;
        }
        long act = number;
        int nDigits = len - 1;
        for (int iDigit = 0; iDigit < nDigits; ++iDigit) {
            result[nDigits - iDigit - 1] = cConversionTable[(int)(act % 64L)];
            act /= 64L;
        }
        result[len - 1] = '\u0000';
        if (act != 0L) {
            return false;
        }
        for (int i = 0; i < result.length; ++i) {
            code[i] = result[i];
        }
        return true;
    }

    private static boolean cv_from_64(long[] res, char[] str) {
        int len;
        for (len = 1; len < 5 && str[len] != '\u0000'; ++len) {
        }
        res[0] = 0L;
        for (int i = 0; i < len; ++i) {
            int index = -1;
            for (int j = 0; j < 64; ++j) {
                if (cConversionTable[j] != str[i]) continue;
                index = j;
                break;
            }
            if (index == -1) {
                return false;
            }
            res[0] = res[0] * 64L + (long)index;
        }
        return true;
    }

    private static boolean getGuidFromCompressedString(String string, Guid guid) {
        int i;
        char[][] str = new char[6][5];
        long[][] num = new long[6][1];
        int len = string.length();
        if (len != 22) {
            return false;
        }
        int j = 0;
        int m = 2;
        for (i = 0; i < 6; ++i) {
            for (int k = 0; k < m; ++k) {
                str[i][k] = string.charAt(j + k);
            }
            str[i][m] = '\u0000';
            j += m;
            m = 4;
        }
        for (i = 0; i < 6; ++i) {
            if (GuidCompressor.cv_from_64(num[i], str[i])) continue;
            return false;
        }
        guid.Data1 = num[0][0] * 0x1000000L + num[1][0];
        guid.Data2 = (int)(num[2][0] / 256L);
        guid.Data3 = (int)(num[2][0] % 256L * 256L + num[3][0] / 65536L);
        guid.Data4[0] = (char)(num[3][0] / 256L % 256L);
        guid.Data4[1] = (char)(num[3][0] % 256L);
        guid.Data4[2] = (char)(num[4][0] / 65536L);
        guid.Data4[3] = (char)(num[4][0] / 256L % 256L);
        guid.Data4[4] = (char)(num[4][0] % 256L);
        guid.Data4[5] = (char)(num[5][0] / 65536L);
        guid.Data4[6] = (char)(num[5][0] / 256L % 256L);
        guid.Data4[7] = (char)(num[5][0] % 256L);
        return true;
    }

    private static String getUncompressedStringFromGuid(Guid guid) {
        String result = new String();
        result = result + String.format("%1$08x", guid.Data1);
        result = result + "-";
        result = result + String.format("%1$04x", guid.Data2);
        result = result + "-";
        result = result + String.format("%1$04x", guid.Data3);
        result = result + "-";
        result = result + String.format("%1$02x%2$02x", guid.Data4[0], (int)guid.Data4[1]);
        result = result + "-";
        result = result + String.format("%1$02x%2$02x%3$02x%4$02x%5$02x%6$02x", guid.Data4[2], (int)guid.Data4[3], (int)guid.Data4[4], (int)guid.Data4[5], (int)guid.Data4[6], (int)guid.Data4[7]);
        return result;
    }

    public static String compressGuidString(String uncompressedString) {
        Guid guid = GuidCompressor.getGuidFromUncompressedString(uncompressedString);
        return GuidCompressor.getCompressedStringFromGuid(guid);
    }

    public static String uncompressGuidString(String compressedString) {
        Guid guid = new Guid();
        GuidCompressor.getGuidFromCompressedString(compressedString, guid);
        return GuidCompressor.getUncompressedStringFromGuid(guid);
    }

    public static void main(String[] args) {
        System.out.println(GuidCompressor.uncompressGuidString("1_MvLDs9r0eAPqtR3GOY9_"));
    }
}

