/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins.classloaders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.bimserver.plugins.classloaders.DelegatingClassLoader;
import org.bimserver.plugins.classloaders.PublicFindClassClassLoader;
import org.bimserver.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipsePluginClassloader
extends PublicFindClassClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipsePluginClassloader.class);
    private final Map<String, Class<?>> loadedClasses = new HashMap();
    private final Path projectFolder;
    private final Path classFolder;

    public EclipsePluginClassloader(ClassLoader parentClassloader, Path projectFolder) {
        super(parentClassloader);
        this.projectFolder = projectFolder;
        this.classFolder = projectFolder.resolve("target/classes");
    }

    public String toString() {
        return "EclipsePluginClassLoader: " + this.projectFolder.toString();
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public URL findResource(String name) {
        Path file = this.projectFolder.resolve(name);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return file.toUri().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        String filename = name.replace(".", File.separator) + ".class";
        if (this.loadedClasses.containsKey(filename)) {
            return this.loadedClasses.get(filename);
        }
        Path classFile = this.classFolder.resolve(filename);
        if (Files.exists(classFile, new LinkOption[0])) {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)Files.newInputStream(classFile, new OpenOption[0]));
                Class<?> definedClass = this.defineClass(name, bytes, 0, bytes.length);
                if (definedClass != null) {
                    String packageName;
                    Package classPackage;
                    int packageIndex;
                    this.loadedClasses.put(filename, definedClass);
                    if (definedClass != null && (packageIndex = name.lastIndexOf(46)) != -1 && (classPackage = this.getPackage(packageName = name.substring(0, packageIndex))) == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                    return definedClass;
                }
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public void dumpStructure(int indent) {
        System.out.print(StringUtils.gen((String)"  ", (int)indent));
        System.out.println("EclipsePluginClassloader " + this.projectFolder);
        ClassLoader parentLoader = this.getParent();
        if (parentLoader instanceof DelegatingClassLoader) {
            DelegatingClassLoader delegatingClassLoader = (DelegatingClassLoader)parentLoader;
            delegatingClassLoader.dumpStructure(indent + 1);
        }
    }
}

