/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFetcher.class);
    private final Set<Path> paths = new LinkedHashSet<Path>();

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public URL getResource(String name) throws IOException {
        Path file = this.getFile(name);
        if (file != null && Files.exists(file, new LinkOption[0])) {
            try {
                return file.toUri().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    public Path getFile(String name) throws IOException {
        for (Path path : this.paths) {
            Path file = path.resolve(name);
            if (!Files.exists(file, new LinkOption[0])) continue;
            return file;
        }
        return null;
    }

    public List<Path> getFiles(String name) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : this.paths) {
            Path file = path.resolve(name);
            if (!Files.exists(file, new LinkOption[0])) continue;
            result.add(file);
        }
        return result;
    }
}

