/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.compare;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.bimserver.ifc.compare.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcFileCompare {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcFileCompare.class);

    public void compare(File src, File dest) throws Exception {
        File compareFile = new File("compare.txt");
        PrintWriter out = new PrintWriter(compareFile);
        try {
            FileInputStream srcStream = new FileInputStream(src);
            FileInputStream destStream = new FileInputStream(dest);
            int diffs = 0;
            FileReader srcReader = new FileReader(srcStream);
            FileReader destReader = new FileReader(destStream);
            String nextSourceLine = srcReader.getNextLine();
            String nextDestLine = destReader.getNextLine();
            while (nextSourceLine != null) {
                if (nextDestLine == null) {
                    out.close();
                    LOGGER.info("Diffs: " + diffs);
                    throw new Exception("Line count not equal");
                }
                if (!nextSourceLine.equals(nextDestLine)) {
                    out.println(nextSourceLine);
                    out.println(nextDestLine);
                    out.println();
                    ++diffs;
                }
                nextSourceLine = srcReader.getNextLine();
                nextDestLine = destReader.getNextLine();
            }
            ((InputStream)srcStream).close();
            ((InputStream)destStream).close();
            out.close();
            LOGGER.info("Diffs: " + diffs);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

