/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSimplifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaSimplifier.class);

    public static void main(String[] args) {
        new SchemaSimplifier().start();
    }

    private void start() {
        File inFile = new File("ifcxml/IFC2X3.xsd");
        File outFile = new File("ifcxml/IFC2X3_simplified.xsd");
        try {
            PrintStream out = new PrintStream(outFile);
            Scanner scanner = new Scanner(inFile);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.contains("<xs:element")) {
                    String newName;
                    int endIndex;
                    int indexName;
                    if (line.contains("name=")) {
                        indexName = line.indexOf("name=") + 6;
                        endIndex = line.indexOf("\"", indexName + 1);
                        newName = line.substring(indexName, endIndex) + "Type";
                        line = line.substring(0, indexName) + newName + line.substring(endIndex);
                    }
                    if (line.contains("ref=") && !(newName = line.substring(indexName = line.indexOf("ref=") + 5, endIndex = line.indexOf("\"", indexName + 1)) + "Type").contains("ex:")) {
                        line = line.substring(0, indexName) + newName + line.substring(endIndex);
                    }
                    if (line.contains("substitutionGroup=") && !(newName = line.substring(indexName = line.indexOf("substitutionGroup=") + 19, endIndex = line.indexOf("\"", indexName + 1)) + "Type").contains("ex:")) {
                        line = line.substring(0, indexName) + newName + line.substring(endIndex);
                    }
                }
                out.println(line);
            }
            scanner.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

