/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries.om;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.InBoundingBox;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.PartOfQuery;
import org.bimserver.emf.PackageMetaData;
import org.eclipse.emf.ecore.EClass;

public class QueryPart
extends PartOfQuery
implements CanInclude {
    private List<EClass> types;
    private Set<Long> oids;
    private Set<String> guids;
    private Map<String, Object> properties;
    private PackageMetaData packageMetaData;
    private InBoundingBox inBoundingBox;
    private List<Include> includes;
    private boolean includeAllFields;

    public QueryPart(PackageMetaData packageMetaData) {
        this.packageMetaData = packageMetaData;
    }

    public void addType(EClass type, boolean includeAllSubTypes) {
        if (this.types == null) {
            this.types = new ArrayList<EClass>();
        }
        this.types.add(type);
        if (includeAllSubTypes) {
            this.types.addAll(this.packageMetaData.getAllSubClasses(type));
        }
    }

    public void addOid(long oid) {
        if (this.oids == null) {
            this.oids = new HashSet<Long>();
        }
        this.oids.add(oid);
    }

    public void addGuid(String guid) {
        if (this.guids == null) {
            this.guids = new HashSet<String>();
        }
        this.guids.add(guid);
    }

    public List<EClass> getTypes() {
        return this.types;
    }

    public Set<Long> getOids() {
        return this.oids;
    }

    public Set<String> getGuids() {
        return this.guids;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, boolean value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public void setInBoundingBox(InBoundingBox inBoundingBox) {
        this.inBoundingBox = inBoundingBox;
    }

    public InBoundingBox getInBoundingBox() {
        return this.inBoundingBox;
    }

    @Override
    public boolean isIncludeAllFields() {
        return this.includeAllFields;
    }

    public void setIncludeAllFields(boolean includeAllFields) {
        this.includeAllFields = includeAllFields;
    }

    @Override
    public void addInclude(Include include) {
        if (this.includes == null) {
            this.includes = new ArrayList<Include>();
        }
        this.includes.add(include);
    }

    @Override
    public List<Include> getIncludes() {
        return this.includes;
    }

    @Override
    public boolean hasIncludes() {
        return this.includes != null;
    }

    public boolean hasOids() {
        return this.oids != null;
    }

    public boolean hasGuids() {
        return this.guids != null;
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    @Override
    public void dump(int indent, StringBuilder sb) {
        if (indent > 10) {
            sb.append("..trimmed\n");
            return;
        }
        if (this.hasTypes()) {
            sb.append(this.indent(indent) + "types\n");
            for (EClass type : this.getTypes()) {
                sb.append(this.indent(indent + 1) + type.getName() + "\n");
            }
        }
        if (this.hasOids()) {
            sb.append(this.indent(indent) + "oids\n");
            Iterator<Object> iterator = this.getOids().iterator();
            while (iterator.hasNext()) {
                long oid = (Long)iterator.next();
                sb.append(this.indent(indent + 1) + oid + "\n");
            }
        }
        if (this.hasGuids()) {
            sb.append(this.indent(indent) + "guids\n");
            for (String guid : this.getGuids()) {
                sb.append(this.indent(indent + 1) + guid + "\n");
            }
        }
        if (this.hasIncludes()) {
            sb.append(this.indent(indent) + "includes\n");
            for (Include include : this.getIncludes()) {
                include.dump(indent + 1, sb);
            }
        }
        if (this.hasInBoundingBox()) {
            sb.append(this.indent(indent) + "inBoundingBox\n");
            this.inBoundingBox.dump(indent + 1, sb);
        }
        if (this.hasProperties()) {
            sb.append(this.indent(indent) + "properties\n");
            for (String key : this.properties.keySet()) {
                sb.append(this.indent(indent + 1) + key + ": " + this.properties.get(key));
            }
        }
    }

    public boolean hasInBoundingBox() {
        return this.inBoundingBox != null;
    }

    public Include createInclude() {
        Include include = new Include(this.packageMetaData);
        this.addInclude(include);
        return include;
    }
}

