/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries.om;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;

public class Query {
    private final Map<String, Include> defines = new HashMap<String, Include>();
    private final List<QueryPart> queryParts = new ArrayList<QueryPart>();
    private String name;
    private PackageMetaData packageMetaData;

    public Query(String name, PackageMetaData packageMetaData) {
        this.name = name;
        this.packageMetaData = packageMetaData;
    }

    public Query(PackageMetaData packageMetaData) {
        this.name = "Query-" + new Random().nextInt();
        this.packageMetaData = packageMetaData;
    }

    public void addDefine(String name, Include include) {
        this.defines.put(name, include);
    }

    public void addQueryPart(QueryPart queryPart) {
        this.queryParts.add(queryPart);
    }

    public String getName() {
        return this.name;
    }

    public Include getDefine(String includeName) {
        return this.defines.get(includeName);
    }

    public List<QueryPart> getQueryParts() {
        return this.queryParts;
    }

    public Map<String, Include> getDefines() {
        return this.defines;
    }

    public QueryPart createQueryPart() {
        QueryPart queryPart = new QueryPart(this.packageMetaData);
        this.addQueryPart(queryPart);
        return queryPart;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("defines\n");
        for (String define : this.defines.keySet()) {
            sb.append("\t" + define + "\n");
            Include include = this.defines.get(define);
            include.dump(2, sb);
        }
        sb.append("queries\n");
        for (QueryPart queryPart : this.queryParts) {
            queryPart.dump(2, sb);
        }
        return sb.toString();
    }

    public PackageMetaData getPackageMetaData() {
        return this.packageMetaData;
    }
}

